/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.adapter.ErrorHeadIconSampleAdapter;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.VertifyClickListener;
import com.kangxin.common.byh.widget.UpPicBottomDialog;
import com.kangxin.common.util.FileUtils;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.IUpdateHeadImagePresenter;
import com.kangxin.doctor.worktable.presenter.impl.UpdateHeadImagePresenter;
import com.kangxin.doctor.worktable.presenter.impl.UpdatingHeadShotPresenter;
import com.kangxin.doctor.worktable.view.IUpDatingHeatShotView;
import com.kangxin.doctor.worktable.view.IUpdateHeadImageView;
import java.io.File;
import java.util.ArrayList;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;
import top.zibin.luban.Luban;
import top.zibin.luban.OnCompressListener;

public class PersonHeadIconFragment
extends BaseFragment
implements IToolView,
IUpdateHeadImageView,
IUpDatingHeatShotView {
    private static final String TAG = "PersonHeadIconFragment";
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    @BindView(value=2131428296)
    TextView vUploadImage;
    @BindView(value=2131428135)
    ImageView vDoctorHeadIcon;
    BaseQuickAdapter mAdapter = new ErrorHeadIconSampleAdapter(new ArrayList());
    private IUpdateHeadImagePresenter mUpdateHeadImagePresenter;
    private UpdatingHeadShotPresenter mUpdatingHeadShotPresenter;
    private ByhCommEvent.UploadImg mUpImageEvent;
    private int[] icons = new int[]{R.mipmap.sample_head_top_more, R.mipmap.sample_face_more_big, R.mipmap.sample_msk, R.mipmap.sample_color_dark, R.mipmap.sample_background_error, R.mipmap.sample_clothes_error, R.mipmap.sample_no_face, R.mipmap.sample_cover};
    private String[] titles = new String[]{"\u5934\u9876\u8fc7\u9ad8", "\u9762\u90e8\u8fc7\u5927", "\u5934\u50cf\u6a21\u7cca", "\u5149\u7ebf\u8fc7\u6697", "\u80cc\u666f\u6742\u4e71", "\u7a7f\u7740\u4fbf\u8863", "\u5934\u50cf\u4fa7\u8138", "\u906e\u6321\u9762\u90e8"};
    private String mHeadShot;

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)"\u4e0a\u4f20\u5934\u50cf");
        this.mUpdatingHeadShotPresenter = new UpdatingHeadShotPresenter(this);
        this.mUpdateHeadImagePresenter = new UpdateHeadImagePresenter(this);
        this.initData();
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this.getActivity(), 3));
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.findViewById(this.rootView, R.id.vUploadImage).setOnClickListener((View.OnClickListener)new VertifyClickListener(8756){

            protected void onClickOk(View view) {
                new UpPicBottomDialog(PersonHeadIconFragment.this.getMContext(), R.id.vUploadImage).show();
            }
        });
    }

    private void initData() {
        ArrayList<ErrorHeadIconSampleAdapter.IconErrorEntity> objects = new ArrayList<ErrorHeadIconSampleAdapter.IconErrorEntity>();
        for (int i = 0; i < this.icons.length; ++i) {
            objects.add(new ErrorHeadIconSampleAdapter.IconErrorEntity(this.icons[i], this.titles[i]));
        }
        this.mAdapter.setNewData(objects);
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_person_head_upoad;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void setImgByPersonalInformationPath(ByhCommEvent.UploadImg uploadImgEvent) {
        this.mUpImageEvent = uploadImgEvent;
        String path = (String)uploadImgEvent.getPhotoInfoList().get(0);
        if (this.getContext() == null) {
            return;
        }
        Luban.with((Context)this.getContext()).load(path).ignoreBy(20).setCompressListener(new OnCompressListener(){

            public void onStart() {
                Log.i((String)PersonHeadIconFragment.TAG, (String)"==onStart====");
            }

            public void onSuccess(File file) {
                if (file == null) {
                    return;
                }
                String filePath = file.getAbsolutePath();
                String fileSize = FileUtils.getAutoFileOrFilesSize((String)filePath);
                Log.i((String)PersonHeadIconFragment.TAG, (String)("==onSuccess====fileSize==" + fileSize));
                PersonHeadIconFragment.this.mUpdatingHeadShotPresenter.upDatingHeadShot(filePath);
            }

            public void onError(Throwable e) {
                Log.i((String)PersonHeadIconFragment.TAG, (String)("==onError==" + e.toString()));
            }
        }).launch();
    }

    @Override
    public void updateHeadImageOk(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        if (responseBody.getCode() == 200) {
            EventBus.getDefault().post((Object)new WorkTabEvent.UpdatePersonInfo());
            this.pop();
        } else {
            this.showShortToast(responseBody.getMsg());
        }
    }

    @Override
    public void showHeatShot(ResponseBody<UpImgEntity> upImgEntityResponseBody) {
        if (upImgEntityResponseBody == null) {
            return;
        }
        Log.i((String)TAG, (String)("upImgEntityResponseBody==>" + upImgEntityResponseBody.getResult()));
        String imgUrl = ((UpImgEntity)upImgEntityResponseBody.getResult()).getUrl();
        if (this.mUpImageEvent.getViewId() == R.id.vUploadImage) {
            this.mHeadShot = imgUrl;
            this.mUpdateHeadImagePresenter.updateHeadImage(this.getContext(), this.mHeadShot, true);
        }
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }
}

