/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.Event;
import com.kangxin.common.byh.event.VertifyClickListener;
import com.kangxin.common.byh.present.IPersonInfoPresenter;
import com.kangxin.common.byh.present.IVerifyPresenter;
import com.kangxin.common.byh.present.VerifyPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.byh.view.IModifySpecialityView;
import com.kangxin.common.byh.view.IPersonInfoView;
import com.kangxin.common.util.StringUtil;
import com.kangxin.doctor.worktable.GradustedInstitutionsListFragment;
import com.kangxin.doctor.worktable.PersonHeadIconFragment;
import com.kangxin.doctor.worktable.PersonInfoAddFragment;
import com.kangxin.doctor.worktable.PersonalProfilesFragment;
import com.kangxin.doctor.worktable.PracticeExperienceListFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.UpdatingQualificationsFragment;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import java.io.Serializable;
import java.util.Objects;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

public class PersonalInformationFragment
extends BaseFragment
implements IToolView,
IPersonInfoView,
IUpdateVerStatus.OnUpdateDocDetailInfoCallback,
IModifySpecialityView {
    private static final String TAG = "PersonalInformationFrag";
    private RelativeLayout vDoctorHeadIconRl;
    private RelativeLayout vDoctorQualificationRl;
    private RelativeLayout vDoctorAdeptAtRl;
    private RelativeLayout vDoctorGraduatedInstitutionsRl;
    private RelativeLayout vDoctorPracticeExperience;
    private RelativeLayout vDoctorPersonalProfilesRl;
    private RelativeLayout vDoctorPersonalNameRl;
    private ImageView vHeadShotImg;
    private TextView vDoctorNameTv;
    private TextView vGenderTv;
    private TextView vCertifiedTv;
    private ImageView vNoCertifiedImg;
    private TextView vHospitalTv;
    private TextView vDepartmentTv;
    private TextView vDoctorAdeptAtTv;
    private TextView vProfessionalTitlesTv;
    private LinearLayout mHeatAuditFailsLayout;
    private ImageView mOffImg;
    private TextView mFailsContentTv;
    IPersonInfoPresenter mPersonInfoPresenter;
    private IVerifyPresenter mVerifyPresent;
    @Autowired
    IUpdateVerStatus updateVerStatus;

    public void init() {
        this.mVerifyPresent = new VerifyPresenter((IModifySpecialityView)this);
        this.mPersonInfoPresenter = (IPersonInfoPresenter)ARouter.getInstance().navigation(IPersonInfoPresenter.class);
        this.updateVerStatus = (IUpdateVerStatus)ARouter.getInstance().navigation(IUpdateVerStatus.class);
        if (this.updateVerStatus == null || this.mPersonInfoPresenter == null) {
            ToastUtils.showShort((CharSequence)"\u767b\u5f55\u6a21\u5757\u672a\u52a0\u5165\u7f16\u8bd1");
            return;
        }
        this.vToolTitleTextView.setText((CharSequence)"\u4e2a\u4eba\u4fe1\u606f");
        this.mPersonInfoPresenter.attachView((IPersonInfoView)this);
        this.updateVerStatus.updateVertifyStatus(this.getContext());
        this.vDoctorQualificationRl = (RelativeLayout)this.findViewById(this.rootView, R.id.doctor_qualification_rl);
        this.vDoctorAdeptAtRl = (RelativeLayout)this.findViewById(this.rootView, R.id.doctor_adept_at_rl);
        this.vDoctorGraduatedInstitutionsRl = (RelativeLayout)this.findViewById(this.rootView, R.id.doctor_graduated_institutions_rl);
        this.vDoctorPracticeExperience = (RelativeLayout)this.findViewById(this.rootView, R.id.doctor_practice_experience_rl);
        this.vDoctorPersonalProfilesRl = (RelativeLayout)this.findViewById(this.rootView, R.id.doctor_personal_profiles_rl);
        this.vDoctorPersonalNameRl = (RelativeLayout)this.findViewById(this.rootView, R.id.doctor_name_rl);
        this.vDoctorHeadIconRl = (RelativeLayout)this.findViewById(this.rootView, R.id.doctor_avatar_rl);
        this.vHeadShotImg = (ImageView)this.findViewById(this.rootView, R.id.head_shot_img);
        this.vDoctorNameTv = (TextView)this.findViewById(this.rootView, R.id.doctor_name_value_tv);
        this.vGenderTv = (TextView)this.findViewById(this.rootView, R.id.doctor_gender_value_tv);
        this.vHospitalTv = (TextView)this.findViewById(this.rootView, R.id.hospital_name_value_tv);
        this.vDepartmentTv = (TextView)this.findViewById(this.rootView, R.id.department_name_value_tv);
        this.vDoctorAdeptAtTv = (TextView)this.findViewById(this.rootView, R.id.doctor_adept_at_value_tv);
        this.vCertifiedTv = (TextView)this.findViewById(this.rootView, R.id.next_icon_no_certified_tv);
        this.vNoCertifiedImg = (ImageView)this.findViewById(this.rootView, R.id.no_certified_img);
        this.vProfessionalTitlesTv = (TextView)this.findViewById(this.rootView, R.id.professional_titles_value_tv);
        this.mHeatAuditFailsLayout = (LinearLayout)this.findViewById(this.rootView, R.id.heat_audit_fails_layout);
        this.mFailsContentTv = (TextView)this.findViewById(this.rootView, R.id.fails_content_tv);
        this.mOffImg = (ImageView)this.findViewById(this.rootView, R.id.tips_off_img);
        this.mOffImg.setOnClickListener(v -> this.mHeatAuditFailsLayout.setVisibility(8));
        this.updateVerStatus.updateDocDetailInfo(this.getContext(), (IUpdateVerStatus.OnUpdateDocDetailInfoCallback)this);
        this.addOnClickListener();
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_personal_information;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        Objects.requireNonNull(this.getActivity()).finish();
        EventBus.getDefault().post((Object)new WorkTabEvent.UpdateDataSuccess());
    }

    public void showErr(String msg) {
        this.showShortToast(msg);
    }

    public void showPersonInfo(LoginSuccess responseBody) {
        if (responseBody == null) {
            return;
        }
        this.updateVerStatus.updateVertifyStatus(this.getContext());
        this.updateVerStatus.updateDocDetailInfo(this.getContext(), (IUpdateVerStatus.OnUpdateDocDetailInfoCallback)this);
        EventBus.getDefault().post((Object)new WorkTabEvent.UpdateDataSuccess());
    }

    private void addOnClickListener() {
        this.vDoctorHeadIconRl.setOnClickListener((View.OnClickListener)new VertifyClickListener(8756){

            protected void onClickOk(View view) {
                PersonHeadIconFragment personHeadIconFragment = new PersonHeadIconFragment();
                PersonalInformationFragment.this.start((ISupportFragment)personHeadIconFragment);
            }
        });
        this.vDoctorQualificationRl.setOnClickListener((View.OnClickListener)new VertifyClickListener(8756){

            protected void onClickOk(View view) {
                UpdatingQualificationsFragment uQFragment = new UpdatingQualificationsFragment();
                Bundle bundle = new Bundle();
                ExpertInfoEntity expertInfoEntity = VertifyDataUtil.getInstance((Context)PersonalInformationFragment.this.getContext()).getExpertInfo();
                bundle.putSerializable("expertInfoEntity", (Serializable)expertInfoEntity);
                uQFragment.setArguments(bundle);
                PersonalInformationFragment.this.start((ISupportFragment)uQFragment);
            }
        });
        this.vDoctorPersonalNameRl.setOnClickListener((View.OnClickListener)new VertifyClickListener(8756){

            protected void onClickOk(View view) {
                PersonInfoAddFragment personInfoAddFragment = new PersonInfoAddFragment();
                Bundle bundle = new Bundle();
                String name = PersonalInformationFragment.this.vDoctorNameTv.getText().toString();
                bundle.putString("name", name);
                personInfoAddFragment.setArguments(bundle);
                PersonalInformationFragment.this.start((ISupportFragment)personInfoAddFragment);
            }
        });
        this.vDoctorAdeptAtRl.setOnClickListener((View.OnClickListener)new VertifyClickListener(8756){

            protected void onClickOk(View view) {
                ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)PersonalInformationFragment.this.getContext()).getUserInfo();
                if (userInfoVOBean == null) {
                    return;
                }
                ARouter.getInstance().build("/login/fragmePerInfoControActivity").withInt("MSG_JUMP_TYPE", 5385).navigation();
                String speciality = userInfoVOBean.getSpeciality();
                EventBus.getDefault().postSticky((Object)new ByhCommEvent.SpecialityEvent(speciality));
            }
        });
        this.vDoctorGraduatedInstitutionsRl.setOnClickListener((View.OnClickListener)new VertifyClickListener(8756){

            protected void onClickOk(View view) {
                GradustedInstitutionsListFragment gIListFragment = new GradustedInstitutionsListFragment();
                PersonalInformationFragment.this.start((ISupportFragment)gIListFragment);
            }
        });
        this.vDoctorPersonalProfilesRl.setOnClickListener((View.OnClickListener)new VertifyClickListener(8756){

            protected void onClickOk(View view) {
                PersonalProfilesFragment profilesFragment = new PersonalProfilesFragment();
                PersonalInformationFragment.this.start((ISupportFragment)profilesFragment);
            }
        });
        this.vDoctorPracticeExperience.setOnClickListener((View.OnClickListener)new VertifyClickListener(8756){

            protected void onClickOk(View view) {
                PracticeExperienceListFragment prExperienceListFragment = new PracticeExperienceListFragment();
                PersonalInformationFragment.this.start((ISupportFragment)prExperienceListFragment);
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveExecutiveInfo(Event.ShancName speciality) {
        this.mVerifyPresent.modifySpeciality(this.getContext(), speciality.getShancDesc());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveQualifications(WorkTabEvent.UpdatingQualifications qualifications) {
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveJobTitle(WorkTabEvent.UpdatePersonInfo updatePersonInfo) {
        new Handler().postDelayed(() -> this.updateVerStatus.updateDocDetailInfo(this.getContext(), (IUpdateVerStatus.OnUpdateDocDetailInfoCallback)this), 200L);
    }

    public void updateDocDetailInfoOk() {
        ExpertInfoEntity expertInfoEntity = VertifyDataUtil.getInstance((Context)this.getContext()).getExpertInfo();
        if (expertInfoEntity == null) {
            return;
        }
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = expertInfoEntity.getUserInfoVO();
        if (userInfoVOBean == null) {
            return;
        }
        if (this.isAdded()) {
            Pretty.create().loadImage(userInfoVOBean.getHeadPortrait() + "").err(this.getResources().getDrawable(R.drawable.ic_byh_comm_header)).placeholder(this.getResources().getDrawable(R.drawable.ic_byh_comm_header)).bitmapTransform(2).into(this.vHeadShotImg);
        }
        this.vDoctorNameTv.setText((CharSequence)userInfoVOBean.getName());
        switch (expertInfoEntity.getAccountStatus()) {
            case 3: 
            case 9: {
                this.vCertifiedTv.setText((CharSequence)"\u8ba4\u8bc1\u4e2d");
                this.vCertifiedTv.setTextColor(this.mContext.getResources().getColor(R.color.color_999999));
                this.vNoCertifiedImg.setVisibility(8);
                this.mHeatAuditFailsLayout.setVisibility(8);
                break;
            }
            case 4: {
                this.vCertifiedTv.setText((CharSequence)"\u8ba4\u8bc1\u672a\u901a\u8fc7");
                this.vCertifiedTv.setTextColor(this.mContext.getResources().getColor(R.color.color_999999));
                this.vNoCertifiedImg.setVisibility(8);
                this.mHeatAuditFailsLayout.setVisibility(0);
                break;
            }
            case 5: {
                this.vCertifiedTv.setText((CharSequence)"\u5df2\u8ba4\u8bc1");
                this.vCertifiedTv.setTextColor(this.mContext.getResources().getColor(R.color.color_333333));
                this.vNoCertifiedImg.setVisibility(0);
                this.mHeatAuditFailsLayout.setVisibility(8);
                break;
            }
            case 1: 
            case 2: {
                this.vCertifiedTv.setText((CharSequence)"\u672a\u8ba4\u8bc1");
                this.vCertifiedTv.setTextColor(this.mContext.getResources().getColor(R.color.color_999999));
                this.vNoCertifiedImg.setVisibility(8);
                this.mHeatAuditFailsLayout.setVisibility(8);
            }
        }
        this.vHospitalTv.setText((CharSequence)userInfoVOBean.getHospitalName());
        this.vDepartmentTv.setText((CharSequence)userInfoVOBean.getHospitalDeptName());
        this.vProfessionalTitlesTv.setText((CharSequence)userInfoVOBean.getProfession());
        String speciality = StringUtil.changeSubText((String)userInfoVOBean.getSpeciality(), (int)12);
        this.vDoctorAdeptAtTv.setText((CharSequence)speciality);
        EventBus.getDefault().post((Object)new WorkTabEvent.UpdateUserInfo());
    }

    public void updateDocDetailInfoErr(String err) {
    }

    public void modifySpecialityOk() {
        this.updateVerStatus.updateDocDetailInfo(this.getContext(), (IUpdateVerStatus.OnUpdateDocDetailInfoCallback)this);
    }
}

