/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.service.HosCityListService;
import com.kangxin.doctor.worktable.PracticeExperienceSelectHospitalFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.PracticeExperienceInfoEntity;
import com.kangxin.doctor.worktable.entity.SavePracticeExperiencelEntity;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.IDeletePracticeExperiencePresenter;
import com.kangxin.doctor.worktable.presenter.ISavePracticeExperiencePresenter;
import com.kangxin.doctor.worktable.presenter.impl.DeletePracticeExperiencePresenter;
import com.kangxin.doctor.worktable.presenter.impl.SavePracticeExperiencePresenter;
import com.kangxin.doctor.worktable.view.IDeletePracticeExperienceView;
import com.kangxin.doctor.worktable.view.ISavePracticeExperienceView;
import com.kangxin.doctor.worktable.widget.CustomDatePicker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

public class PracticeExperienceDeleteFragment
extends BaseFragment
implements IToolView,
ISavePracticeExperienceView,
IDeletePracticeExperienceView {
    private static final String TAG = "PracticeExperienceAddFragment";
    private RelativeLayout mHospitalRl;
    private RelativeLayout mProfessionalRl;
    private RelativeLayout mStartTimeRl;
    private RelativeLayout mEndTimeRl;
    private TextView mHospitalTv;
    private TextView mDepartmentTv;
    private TextView mStartTimeTv;
    private TextView mEndTimeTv;
    private TextView mDeleteBtn;
    private String mHospitalName;
    private String mDepartmentName;
    private String mStartTimeStr;
    private String mEndTimeStr;
    private int mStdFirstDepId;
    private ISavePracticeExperiencePresenter mSavePracticeExperiencePresenter;
    private IDeletePracticeExperiencePresenter mDeletePracticeExperiencePresenter;
    private PracticeExperienceInfoEntity mPracticeExperienceInfoEntity;
    @Autowired
    HosCityListService mHosCityListService;
    private String mHospitalId;

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)"\u804c\u4e1a\u7ecf\u5386");
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mPracticeExperienceInfoEntity = (PracticeExperienceInfoEntity)bundle.getSerializable("adapterItem");
        }
        this.vRightTextView.setVisibility(0);
        this.vRightTextView.setText((CharSequence)"\u5b8c\u6210");
        this.vRightTextView.setTextColor(this.getResources().getColor(R.color.white));
        this.mSavePracticeExperiencePresenter = new SavePracticeExperiencePresenter(this);
        this.mDeletePracticeExperiencePresenter = new DeletePracticeExperiencePresenter(this);
        this.mHospitalRl = (RelativeLayout)this.findViewById(this.rootView, R.id.hospital_rl);
        this.mProfessionalRl = (RelativeLayout)this.findViewById(this.rootView, R.id.professional_rl);
        this.mStartTimeRl = (RelativeLayout)this.findViewById(this.rootView, R.id.start_time_rl);
        this.mEndTimeRl = (RelativeLayout)this.findViewById(this.rootView, R.id.end_time_rl);
        this.mHospitalTv = (TextView)this.findViewById(this.rootView, R.id.hospital_tv);
        this.mHospitalTv.setTextColor(this.getResources().getColor(R.color.color_333333));
        this.mHospitalName = this.mPracticeExperienceInfoEntity.getHospitalName();
        this.mHospitalTv.setText((CharSequence)this.mHospitalName);
        this.mDepartmentTv = (TextView)this.findViewById(this.rootView, R.id.professional_tv);
        this.mDepartmentTv.setTextColor(this.getResources().getColor(R.color.color_333333));
        this.mDepartmentName = this.mPracticeExperienceInfoEntity.getStdSecondDeptName();
        this.mDepartmentTv.setText((CharSequence)this.mDepartmentName);
        this.mStartTimeTv = (TextView)this.findViewById(this.rootView, R.id.start_time_tv);
        this.mStartTimeTv.setTextColor(this.getResources().getColor(R.color.color_333333));
        this.mStartTimeStr = this.mPracticeExperienceInfoEntity.getStartTime();
        this.mStartTimeTv.setText((CharSequence)this.mStartTimeStr.substring(0, 7));
        this.mEndTimeTv = (TextView)this.findViewById(this.rootView, R.id.end_time_tv);
        this.mEndTimeTv.setTextColor(this.getResources().getColor(R.color.color_333333));
        this.mEndTimeStr = this.mPracticeExperienceInfoEntity.getEndTime();
        this.mEndTimeTv.setText((CharSequence)this.mEndTimeStr.substring(0, 7));
        this.mDeleteBtn = (TextView)this.findViewById(this.rootView, R.id.submit_practice_experience_tv);
        this.mDeleteBtn.setBackgroundColor(this.getResources().getColor(R.color.color_E34E4E));
        this.mDeleteBtn.setText((CharSequence)"\u5220\u9664\u8fd9\u6bb5\u7ecf\u5386");
        this.addOnClickListener();
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_practice_experience_add;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }

    private void addOnClickListener() {
        this.mHospitalRl.setOnClickListener(v -> {
            PracticeExperienceSelectHospitalFragment selectHospitalFragment = new PracticeExperienceSelectHospitalFragment();
            this.start((ISupportFragment)selectHospitalFragment);
        });
        this.mProfessionalRl.setOnClickListener(v -> this.start(this.mHosCityListService.getActionBarDepartmentFragment()));
        this.mStartTimeRl.setOnClickListener(v -> {
            CustomDatePicker customDatePickerStart = new CustomDatePicker(this.mContext, this.mContext.getResources().getString(R.string.please_select_date_tips), time -> {
                this.mStartTimeStr = time.split(" ")[0];
                this.mStartTimeTv.setText((CharSequence)this.mStartTimeStr.substring(0, 7));
                this.mStartTimeTv.setTextColor(this.getResources().getColor(R.color.color_333333));
            }, "1980-01-01 00:00", this.getCurTime(), new CustomDatePicker.DialogShowOrDismiss(){

                @Override
                public void show() {
                }

                @Override
                public void dismiss() {
                }
            });
            customDatePickerStart.showSpecificTime(false);
            customDatePickerStart.setIsLoop(false);
            customDatePickerStart.show(this.stampToDate(System.currentTimeMillis()));
        });
        this.mEndTimeRl.setOnClickListener(v -> {
            CustomDatePicker customDatePickerEnd = new CustomDatePicker(this.mContext, this.mContext.getResources().getString(R.string.please_select_date_tips), time -> {
                this.mEndTimeStr = time.split(" ")[0];
                this.mEndTimeTv.setText((CharSequence)this.mEndTimeStr.substring(0, 7));
                this.mEndTimeTv.setTextColor(this.getResources().getColor(R.color.color_333333));
            }, "1980-01-01 00:00", this.getCurTime(), new CustomDatePicker.DialogShowOrDismiss(){

                @Override
                public void show() {
                }

                @Override
                public void dismiss() {
                }
            });
            customDatePickerEnd.showSpecificTime(false);
            customDatePickerEnd.setIsLoop(false);
            customDatePickerEnd.show(this.stampToDate(System.currentTimeMillis()));
        });
        this.vRightTextView.setOnClickListener(v -> {
            if (TextUtils.isEmpty((CharSequence)this.mHospitalName)) {
                this.showShortToast("\u8bf7\u9009\u62e9\u533b\u9662");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mDepartmentName)) {
                this.showShortToast("\u8bf7\u9009\u62e9\u79d1\u5ba4");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mStartTimeStr)) {
                this.showShortToast(this.getContext().getResources().getString(R.string.please_select_date_tips));
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.mEndTimeStr)) {
                this.showShortToast(this.getContext().getResources().getString(R.string.please_select_date_tips));
                return;
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = format.parse(this.mStartTimeStr);
                Date date1 = format.parse(this.mEndTimeStr);
                if (date.getTime() > date1.getTime()) {
                    this.showShortToast("\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u622a\u6b62\u65e5\u671f");
                    return;
                }
                if (date.getTime() == date1.getTime()) {
                    this.showShortToast("\u8d77\u59cb\u65e5\u671f\u4e0e\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u76f8\u540c");
                    return;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            SavePracticeExperiencelEntity savePracticeExperiencelEntity = new SavePracticeExperiencelEntity();
            savePracticeExperiencelEntity.setHospitalHeadImage("");
            savePracticeExperiencelEntity.setHospitalName(this.mHospitalName);
            savePracticeExperiencelEntity.setStdSecondDeptName(this.mDepartmentName);
            savePracticeExperiencelEntity.setStdSecondDeptId(this.mStdFirstDepId);
            savePracticeExperiencelEntity.setStartTime(this.mStartTimeStr);
            savePracticeExperiencelEntity.setEndTime(this.mEndTimeStr);
            savePracticeExperiencelEntity.setId(this.mPracticeExperienceInfoEntity.getId());
            this.mSavePracticeExperiencePresenter.savePracticeExperience(savePracticeExperiencelEntity, true);
        });
        this.mDeleteBtn.setOnClickListener(v -> this.mDeletePracticeExperiencePresenter.deleteGetPracticeExperience(this.mPracticeExperienceInfoEntity.getId(), true));
    }

    public String stampToDate(long timeMillis) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(timeMillis);
        return simpleDateFormat.format(date);
    }

    public String getCurTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.CHINA);
        return sdf.format(new Date());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveSelectHospitalName(WorkTabEvent.SelectHospitalInfo selectHospitalInfo) {
        this.mHospitalId = selectHospitalInfo.getmHospitalId();
        this.mHospitalName = selectHospitalInfo.getHospitalName();
        this.mHospitalTv.setText((CharSequence)this.mHospitalName);
        this.mHospitalTv.setTextColor(this.getResources().getColor(R.color.color_333333));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveSelectHospitalName(ByhCommEvent.HosDeptDataEvent selectDepartmentInfo) {
        this.mDepartmentName = selectDepartmentInfo.getStdSecondDeptName();
        String firstDeptCode = selectDepartmentInfo.getStdDeptId();
        if (!TextUtils.isEmpty((CharSequence)firstDeptCode)) {
            this.mStdFirstDepId = Integer.parseInt(firstDeptCode);
        }
        this.mDepartmentTv.setText((CharSequence)this.mDepartmentName);
        this.mDepartmentTv.setTextColor(this.getResources().getColor(R.color.color_333333));
    }

    @Override
    public void savePracticeExperienceInfoSuccess(ResponseBody responseBody) {
        if (responseBody.getCode() == 200) {
            EventBus.getDefault().post((Object)new WorkTabEvent.updatePracticeExperience());
            this.pop();
        } else {
            this.showShortToast(responseBody.getMsg());
        }
    }

    @Override
    public void deletePracticeExperienceInfoSuccess(ResponseBody responseBody) {
        if (responseBody.getCode() == 200) {
            EventBus.getDefault().post((Object)new WorkTabEvent.deletePracticeExperience());
            this.pop();
        } else {
            this.showShortToast(responseBody.getMsg());
        }
    }
}

