/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.blankj.utilcode.util.ToastUtils;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.PracticeExperienceSelectHospitalEntity;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.IPracticeExperienceSelectHospitalPresenter;
import com.kangxin.doctor.worktable.presenter.impl.GetPracticeExperienceSelectHospitalListPresenter;
import com.kangxin.doctor.worktable.view.IGetPracticeExperienceSelectHospitalView;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

public class PracticeExperienceSelectHospitalFragment
extends BaseFragment
implements IToolView,
IGetPracticeExperienceSelectHospitalView {
    private static final String TAG = "PracticeExperienceSelectHospitalFragment";
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    private EditText mSearchEt;
    private String mSearchKey = "";
    private List<PracticeExperienceSelectHospitalEntity> mList;
    private IPracticeExperienceSelectHospitalPresenter mHospitalListPresenter;
    private HospitalSelectListAdapter mHospitalSelectListAdapter;
    private String mHospitalNameStr;
    private String mHosId;

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)"\u533b\u9662\u540d\u79f0");
        this.vRightTextView.setVisibility(0);
        this.vRightTextView.setText((CharSequence)"\u5b8c\u6210");
        this.vRightTextView.setTextColor(this.getResources().getColor(R.color.white));
        this.mHospitalListPresenter = new GetPracticeExperienceSelectHospitalListPresenter(this);
        this.mHospitalSelectListAdapter = new HospitalSelectListAdapter(this.mList);
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.mHospitalSelectListAdapter);
        this.mHospitalSelectListAdapter.notifyDataSetChanged();
        this.mSearchEt = (EditText)this.findViewById(this.rootView, R.id.vSearchView);
        this.mSearchKey = this.mSearchEt.getText().toString().trim();
        this.mHospitalListPresenter.getHospitalList(this.mSearchKey, true);
        this.addOnClickListener();
    }

    private void addOnClickListener() {
        this.mSearchEt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                PracticeExperienceSelectHospitalFragment.this.mSearchKey = s.toString();
                PracticeExperienceSelectHospitalFragment.this.mHospitalListPresenter.getHospitalList(PracticeExperienceSelectHospitalFragment.this.mSearchKey, false);
            }
        });
        this.mHospitalSelectListAdapter.setOnItemClickListener((adapter, view, position) -> {
            PracticeExperienceSelectHospitalEntity item = (PracticeExperienceSelectHospitalEntity)adapter.getItem(position);
            this.mHosId = item.getId() + "";
            this.mHospitalNameStr = item.getHospitalName();
            this.mSearchEt.setText((CharSequence)this.mHospitalNameStr);
        });
        this.vRightTextView.setOnClickListener(v -> {
            if (TextUtils.isEmpty((CharSequence)this.mSearchKey)) {
                ToastUtils.showShort((CharSequence)"\u8bf7\u9009\u62e9\u533b\u9662\u540d\u79f0");
                return;
            }
            EventBus.getDefault().post((Object)new WorkTabEvent.SelectHospitalInfo(this.mSearchKey, this.mHosId));
            PracticeExperienceSelectHospitalFragment.HideKeyboard(this.rootView);
            this.pop();
        });
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_practice_experience_select_hospital;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        PracticeExperienceSelectHospitalFragment.HideKeyboard(this.rootView);
        this.pop();
    }

    @Override
    public void getHospitalInfoSuccess(List<PracticeExperienceSelectHospitalEntity> hospitalEntityList) {
        this.mList = hospitalEntityList;
        this.mHospitalSelectListAdapter.setNewData(this.mList);
        this.mHospitalSelectListAdapter.notifyDataSetChanged();
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }

    public class HospitalSelectListAdapter
    extends BaseQuickAdapter<PracticeExperienceSelectHospitalEntity, HospitalSelectListHolder> {
        public HospitalSelectListAdapter(List data) {
            super(R.layout.worktab_by_item_select_hospital, data);
        }

        protected void convert(HospitalSelectListHolder helper, PracticeExperienceSelectHospitalEntity item) {
            if (item != null) {
                helper.vHospitalNameTv.setText((CharSequence)item.getHospitalName());
            }
        }

        public class HospitalSelectListHolder
        extends BaseViewHolder {
            TextView vHospitalNameTv;

            public HospitalSelectListHolder(View view) {
                super(view);
                this.vHospitalNameTv = (TextView)view.findViewById(R.id.hospital_name);
            }
        }
    }
}

