/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.view.View;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.StandardSecondDepartmentEntity;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.IStandardSecondDepartmentListPresenter;
import com.kangxin.doctor.worktable.presenter.impl.StandardSecondDepartmentListPresenter;
import com.kangxin.doctor.worktable.view.IStandardSecondDepartmentListView;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

public class PracticeExperienceStandardSDepFragment
extends BaseFragment
implements IToolView,
IStandardSecondDepartmentListView {
    private static final String TAG = "PracticeExperienceStandardSDepFragment";
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    private List<StandardSecondDepartmentEntity> mList;
    private IStandardSecondDepartmentListPresenter mStandardSecondDepartListPresenter;
    private DepartmentListAdapter mDepartmentListAdapter;
    private String mDepartmentNameStr;

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)"\u79d1\u5ba4\u540d\u79f0");
        this.mStandardSecondDepartListPresenter = new StandardSecondDepartmentListPresenter(this);
        this.mDepartmentListAdapter = new DepartmentListAdapter(this.mList);
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.mDepartmentListAdapter);
        this.mDepartmentListAdapter.notifyDataSetChanged();
        this.mStandardSecondDepartListPresenter.getStandardSecondDepartmentList(true);
        this.addOnClickListener();
    }

    private void addOnClickListener() {
        this.mDepartmentListAdapter.setOnItemClickListener((adapter, view, position) -> {
            StandardSecondDepartmentEntity item = (StandardSecondDepartmentEntity)adapter.getItem(position);
            this.mDepartmentNameStr = item.getName();
            Integer stdFirstDepId = item.getStdFirstDepId();
            EventBus.getDefault().post((Object)new WorkTabEvent.SelectDepartmentInfo(this.mDepartmentNameStr, stdFirstDepId));
            this.pop();
        });
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_practice_experience_department;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }

    @Override
    public void getStandardSecondDepartmentListSuccess(List<StandardSecondDepartmentEntity> practiceExperienceInfo) {
        this.mList = practiceExperienceInfo;
        this.mDepartmentListAdapter.setNewData(this.mList);
        this.mDepartmentListAdapter.notifyDataSetChanged();
    }

    public class DepartmentListAdapter
    extends BaseQuickAdapter<StandardSecondDepartmentEntity, DepartmentListHolder> {
        public DepartmentListAdapter(List data) {
            super(R.layout.worktab_by_item_select_hospital, data);
        }

        protected void convert(DepartmentListHolder helper, StandardSecondDepartmentEntity item) {
            if (item != null) {
                helper.vDepartmentNameTv.setText((CharSequence)item.getName());
            }
        }

        public class DepartmentListHolder
        extends BaseViewHolder {
            TextView vDepartmentNameTv;

            public DepartmentListHolder(View view) {
                super(view);
                this.vDepartmentNameTv = (TextView)view.findViewById(R.id.hospital_name);
            }
        }
    }
}

