/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.entity.OrderItemEntity;
import com.kangxin.common.byh.service.IConsChatReceProvider;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.WaitResolutionOrderListAdapter;
import com.kangxin.doctor.worktable.presenter.IOrderListPresenter;
import com.kangxin.doctor.worktable.presenter.impl.OrderListPresenter;
import com.kangxin.doctor.worktable.view.INewApplyOrderListView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import java.io.Serializable;
import java.util.List;

public class ReceiverOrderListFragment
extends BaseFragment
implements INewApplyOrderListView {
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    @BindView(value=2131428252)
    SmartRefreshLayout vRefreshLayout;
    private IOrderListPresenter applyOrderListPresenter;
    private int status = 0;
    private WaitResolutionOrderListAdapter adapter = new WaitResolutionOrderListAdapter(null);
    private IConsChatReceProvider mConsuChatReceiverProvider = (IConsChatReceProvider)ARouter.getInstance().build("/consuchat/receiver/ConsuChatReceiverProvider").navigation();

    public static ReceiverOrderListFragment newInstance(int status) {
        ReceiverOrderListFragment waitReceiverFragment = new ReceiverOrderListFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("status", status);
        waitReceiverFragment.setArguments(bundle);
        return waitReceiverFragment;
    }

    public void init() {
        this.mConsuChatReceiverProvider.registerConsuChatReceiver();
        this.status = this.getArguments().getInt("status");
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.applyOrderListPresenter = new OrderListPresenter(this);
        this.dispatchEvent();
    }

    private void dispatchEvent() {
        this.vRefreshLayout.setOnRefreshListener(new OnRefreshListener(){

            public void onRefresh(RefreshLayout refreshlayout) {
                ReceiverOrderListFragment.this.applyOrderListPresenter.getReceiverOrderList(false, ReceiverOrderListFragment.this.status);
            }
        });
        this.adapter.setOnItemClickListener((tempAdapter, view, position) -> {
            int orderStatus = ((OrderItemEntity)this.adapter.getData().get(position)).getOrderStatus();
            switch (orderStatus) {
                case 20: 
                case 30: 
                case 40: {
                    OrderItemEntity orderItemEntity = (OrderItemEntity)this.adapter.getData().get(position);
                    this.sendConsMsgCast(orderItemEntity);
                }
            }
        });
    }

    private void sendConsMsgCast(OrderItemEntity orderItemEntity) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.mConsuChatReceiverProvider.sendConsuChatReceiver((Serializable)orderItemEntity);
        } else {
            Intent intent = new Intent("com.kangxin.doctor.worktable.orderlist.consulation.chat");
            intent.putExtra("ORDER_ITEM_ENTITY", (Serializable)orderItemEntity);
            this.getContext().sendBroadcast(intent);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mConsuChatReceiverProvider.unRegisterConsuChatReceiver();
    }

    public void onLazyInitView(@Nullable Bundle savedInstanceState) {
        super.onLazyInitView(savedInstanceState);
        this.applyOrderListPresenter.getReceiverOrderList(false, this.status);
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_receiver_order_wait;
    }

    public void bindData(List<OrderItemEntity> pageData) {
        if (this.adapter == null) {
            this.adapter = new WaitResolutionOrderListAdapter(pageData);
        } else {
            this.adapter.setNewData(pageData);
        }
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.vRefreshLayout.finishRefresh();
    }

    public void addMore(List<OrderItemEntity> pageData) {
        this.adapter.addData(pageData);
        this.adapter.loadMoreComplete();
    }

    public void noMore() {
        this.adapter.loadMoreEnd();
    }

    public void noData() {
        this.vRefreshLayout.finishRefresh();
    }
}

