/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.signature.ObjectKey;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.present.IOrderDetailPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.doctor.worktable.ExperetSignFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.UploadReportWriteFragment;
import com.kangxin.doctor.worktable.presenter.IReportDetailPresenter;
import com.kangxin.doctor.worktable.presenter.clc.ClcOrderDetailPresent;
import com.kangxin.doctor.worktable.presenter.clc.ClcReportDetailPresent;
import com.kangxin.doctor.worktable.presenter.impl.ReportDetailPresenter;
import com.kangxin.doctor.worktable.presenter.impl2.BHOrderDetailPresenter;
import com.kangxin.doctor.worktable.view.IOrderDetailView;
import com.kangxin.doctor.worktable.view.IReportDetailView;
import java.io.Serializable;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

@Route(path="/report/ReportDetailFragment")
public class ReportDetailFragment
extends BaseFragment
implements IToolView,
IReportDetailView,
IOrderDetailView {
    private IReportDetailPresenter mReportDetailPresenter = new ReportDetailPresenter(this);
    @BindView(value=2131428293)
    EditText vTreatPlan;
    @BindView(value=2131428298)
    TextView vUploadWrite;
    @BindView(value=2131428107)
    TextView vCommitImage;
    @BindView(value=2131428287)
    TextView vToSign;
    @BindView(value=2131428159)
    ImageView vExpertSign;
    @BindView(value=2131428199)
    TextView vNotice;
    @BindView(value=2131428220)
    TextView vPatientInfo;
    @BindView(value=2131428230)
    TextView vPatientSex;
    @BindView(value=2131428213)
    TextView vPatientAge;
    @BindView(value=2131428215)
    TextView vPatientCard;
    @BindView(value=2131428227)
    TextView vPatientPhone;
    @BindView(value=2131427409)
    ConstraintLayout bottom_layout;
    @BindView(value=2131428090)
    TextView vApplyHospital;
    @BindView(value=2131428088)
    TextView vApplyDep;
    @BindView(value=2131428089)
    TextView vApplyDoctor;
    @BindView(value=2131428119)
    TextView vConsulationHospital;
    @BindView(value=2131428116)
    TextView vConsulationDep;
    @BindView(value=2131428117)
    TextView vConsulationDoc;
    @BindView(value=2131428123)
    TextView vConsulationType;
    @BindView(value=2131428122)
    TextView vConsulationTime;
    @BindView(value=2131427461)
    TextView vDiaHospitalView;
    @BindView(value=2131427458)
    TextView vDiaDeptView;
    @BindView(value=2131427460)
    TextView vDiaDoctorView;
    @BindView(value=2131427463)
    TextView vDiaTypeView;
    @BindView(value=2131427462)
    TextView vDiaTimeView;
    @BindView(value=2131427653)
    TextView vDiaIdeaView;
    @BindView(value=2131427954)
    TextView vDiaSignView;
    @BindView(value=2131427475)
    TextView vDiaInfoView;
    private static final String OUTDEMENT = "\u95e8\u8bca";
    private static final String CONSUSTR = "\u4f1a\u8bca";
    private String mSignUrl;
    private OrderDetailEntity orderDetailEntity;
    private IOrderDetailPresenter orderDetailPresenter;
    String orderViewId;
    private int mConsuStatus;

    private void changeDiaLabelStale(String preLabel) {
        this.vDiaHospitalView.setText((CharSequence)(preLabel + "\u533b\u9662: "));
        this.vDiaDeptView.setText((CharSequence)(preLabel + "\u79d1\u5ba4: "));
        this.vDiaDoctorView.setText((CharSequence)(preLabel + "\u533b\u751f: "));
        this.vDiaTypeView.setText((CharSequence)(preLabel + "\u5f62\u5f0f: "));
        this.vDiaTimeView.setText((CharSequence)(preLabel + "\u65f6\u95f4: "));
        this.vDiaIdeaView.setText((CharSequence)(preLabel + "\u610f\u89c1"));
        this.vDiaSignView.setText((CharSequence)(preLabel + "\u4e13\u5bb6\u7b7e\u540d"));
        this.vDiaInfoView.setText((CharSequence)(preLabel + "\u4fe1\u606f"));
    }

    public static ReportDetailFragment newInstance(String orderViewId) {
        ReportDetailFragment reportDetailFragment = new ReportDetailFragment();
        Bundle bundle = new Bundle();
        bundle.putString("orderViewId", orderViewId);
        reportDetailFragment.setArguments(bundle);
        return reportDetailFragment;
    }

    public static ReportDetailFragment newInstance(OrderDetailEntity orderDetailEntity) {
        ReportDetailFragment reportDetailFragment = new ReportDetailFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable("orderDetail", (Serializable)orderDetailEntity);
        reportDetailFragment.setArguments(bundle);
        return reportDetailFragment;
    }

    public void init() {
        IUpdateVerStatus updateVerStatus = (IUpdateVerStatus)ARouter.getInstance().build("/service_update/SERVICE_UPDATE_VER_STATUS").navigation();
        this.mConsuStatus = updateVerStatus.getConsuStatus(this.getMContext());
        if (this.mConsuStatus == 4626) {
            this.changeDiaLabelStale(CONSUSTR);
            this.mReportDetailPresenter = new ReportDetailPresenter(this);
            this.orderDetailPresenter = new BHOrderDetailPresenter(this);
        } else if (this.mConsuStatus == 4627) {
            this.changeDiaLabelStale(OUTDEMENT);
            this.mReportDetailPresenter = new ClcReportDetailPresent(this);
            this.orderDetailPresenter = new ClcOrderDetailPresent(this);
        }
        this.vToolTitleTextView.setText((CharSequence)"\u62a5\u544a\u8be6\u60c5");
        this.orderDetailEntity = (OrderDetailEntity)this.getArguments().getSerializable("orderDetail");
        String orderViewId = this.getArguments().getString("orderViewId");
        if (!StringUtils.isEmpty((CharSequence)orderViewId) && this.orderDetailPresenter != null) {
            this.orderDetailPresenter.getOrderDetail(orderViewId);
        }
        this.fullView(this.orderDetailEntity);
    }

    private void fullView(OrderDetailEntity entity) {
        if (entity == null) {
            return;
        }
        this.orderDetailEntity = entity;
        this.dispatchEvent();
        int doctorId = VertifyDataUtil.getInstance((Context)this.mContext).getLoginUserId();
        if (entity != null && doctorId != entity.getExpertId()) {
            this.hideWrite();
        }
        if (entity != null && entity.getIsReport() == 1) {
            this.hideWrite();
        }
        this.vApplyHospital.setText((CharSequence)(entity.getDocHosName() + ""));
        this.vApplyDep.setText((CharSequence)(entity.getDocDepName() + ""));
        this.vApplyDoctor.setText((CharSequence)(entity.getDocName() + ""));
        this.vConsulationHospital.setText((CharSequence)(entity.getExpertHosName() + ""));
        this.vConsulationDep.setText((CharSequence)(entity.getExpertDepName() + ""));
        this.vConsulationDoc.setText((CharSequence)(entity.getExpertName() + ""));
        if (this.mConsuStatus == 4626) {
            this.vConsulationType.setText((CharSequence)(entity.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587"));
        } else if (this.mConsuStatus == 4627) {
            this.vConsulationType.setText((CharSequence)"\u89c6\u9891");
        }
        this.vConsulationTime.setText((CharSequence)(entity.getOrderBeginTime() + "\u81f3" + entity.getOrderFinishTime()));
        this.vPatientInfo.setText((CharSequence)(entity.getPatientName() + ""));
        this.vPatientSex.setText((CharSequence)(entity.getPatientSex() == 1 ? "\u7537" : "\u5973"));
        this.vPatientAge.setText((CharSequence)(entity.getPatientAge() + ""));
        String paIdcard = entity.getPatIdCard();
        if (!TextUtils.isEmpty((CharSequence)paIdcard)) {
            this.vPatientCard.setText((CharSequence)(paIdcard.replaceAll("(\\d{6})\\d{8}(\\w{4})", "$1******$2") + ""));
        }
        this.vPatientPhone.setText((CharSequence)(entity.getPatientTel() + ""));
        this.vTreatPlan.setHint((CharSequence)"");
        if (TextUtils.isEmpty((CharSequence)entity.getTreatPlan())) {
            this.vTreatPlan.setText((CharSequence)"");
        } else {
            this.vTreatPlan.setText((CharSequence)(entity.getTreatPlan() + ""));
        }
        Pretty.create().loadImage(entity.getSignature()).into(this.vExpertSign);
    }

    private void hideWrite() {
        this.bottom_layout.setVisibility(8);
        this.vToSign.setVisibility(8);
        this.vNotice.setVisibility(8);
        this.vTreatPlan.setEnabled(false);
        this.vTreatPlan.setFocusable(false);
    }

    private void dispatchEvent() {
        this.vCommitImage.setOnClickListener(v -> {
            if (StringUtils.isEmpty((CharSequence)this.vTreatPlan.getText().toString())) {
                ToastUtils.showShort((CharSequence)"\u8bf7\u586b\u5199\u4f1a\u8bca\u610f\u89c1");
                return;
            }
            this.mReportDetailPresenter.uploadReport(this.orderDetailEntity.getOrderViewId(), this.orderDetailEntity.getOrderType(), this.vTreatPlan.getText().toString(), this.mSignUrl);
        });
        this.vUploadWrite.setOnClickListener(v -> {
            UploadReportWriteFragment uploadReportWriteFragment = UploadReportWriteFragment.newInstance(this.orderDetailEntity.getOrderViewId(), this.orderDetailEntity.getOrderType());
            this.start((ISupportFragment)uploadReportWriteFragment);
        });
        this.vToSign.setOnClickListener(v -> this.startForResult((ISupportFragment)new ExperetSignFragment(), 1));
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_report_detail;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        EventBus.getDefault().post((Object)new ByhCommEvent.FinishPageEvent());
        this._mActivity.finish();
    }

    public void onFragmentResult(int requestCode, int resultCode, Bundle data) {
        super.onFragmentResult(requestCode, resultCode, data);
        if (data != null) {
            this.mSignUrl = data.getString("url");
            Pretty.create().loadImage(this.mSignUrl).sign((Key)new ObjectKey((Object)System.currentTimeMillis())).into(this.vExpertSign);
            this.vNotice.setVisibility(4);
        }
    }

    @Override
    public void success() {
        this.finishCurrentView();
        ToastUtils.showShort((CharSequence)"\u4e0a\u4f20\u6210\u529f");
        EventBus.getDefault().post((Object)new ByhCommEvent.FlushList());
    }

    @Override
    public void bindOrderDetail(OrderDetailEntity data) {
        this.fullView(data);
    }

    @Override
    public void cancleSuccess() {
    }

    @Override
    public void toDicom(String title, String url) {
    }
}

