/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.RequestWithRawCashVerifyFragment;
import me.yokeyword.fragmentation.ISupportFragment;
import org.jetbrains.annotations.NotNull;

public class RequestWithRawCashFragment
extends BaseFragment
implements IToolView,
View.OnClickListener {
    private static final String TAG = "RequestWithRawCashFragm";
    private TextView mNumberBlancesTv;
    private EditText mAmountEdit;
    private TextView mFullWithdraTv;
    private TextView mNextStepTv;
    private TextView mWithdraHolderTv;
    private String mAmount;
    private String mBundleAmount;
    private String mCardholder;

    public void init() {
        this.initViews();
    }

    private void initViews() {
        this.vToolTitleTextView.setText((CharSequence)"\u7533\u8bf7\u63d0\u73b0");
        this.mNumberBlancesTv = (TextView)this.findViewById(this.rootView, R.id.number_balances_tv);
        this.mAmountEdit = (EditText)this.findViewById(this.rootView, R.id.edt_amount);
        this.mAmountEdit.setInputType(8194);
        this.mAmountEdit.setFilters(new InputFilter[]{(source, start, end, dest, dstart, dend) -> {
            if (source.equals(".") && dest.toString().length() == 0) {
                return "0.";
            }
            if (dest.toString().contains(".")) {
                int index = dest.toString().indexOf(".");
                int length = dest.toString().substring(index).length();
                if (length == 3) {
                    return "";
                }
            }
            return null;
        }});
        this.mFullWithdraTv = (TextView)this.findViewById(this.rootView, R.id.full_withdra_tv);
        this.mNextStepTv = (TextView)this.findViewById(this.rootView, R.id.request_withdraw_cash_nextstep_tv);
        this.mWithdraHolderTv = (TextView)this.findViewById(this.rootView, R.id.withdrawal_account_tv);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mBundleAmount = bundle.getString("amount");
            this.mCardholder = bundle.getString("cardholder");
            this.mNumberBlancesTv.setText((CharSequence)("\uffe5" + this.mBundleAmount));
            this.mWithdraHolderTv.setText((CharSequence)this.mCardholder);
        }
        this.mAmountEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                RequestWithRawCashFragment.this.mAmount = RequestWithRawCashFragment.this.mAmountEdit.getText().toString().trim();
            }
        });
        this.mFullWithdraTv.setOnClickListener((View.OnClickListener)this);
        this.mNextStepTv.setOnClickListener((View.OnClickListener)this);
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_request_withraw_cash;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        RequestWithRawCashFragment.HideKeyboard(this.rootView);
        this.pop();
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.full_withdra_tv) {
            this.mAmountEdit.setText((CharSequence)this.mBundleAmount);
            RequestWithRawCashFragment.HideKeyboard(this.rootView);
        } else if (i == R.id.request_withdraw_cash_nextstep_tv) {
            if (TextUtils.isEmpty((CharSequence)this.mAmount)) {
                this.showShortToast("\u8bf7\u8f93\u5165\u63d0\u73b0\u91d1\u989d");
                return;
            }
            if (Double.valueOf(this.mBundleAmount) < Double.valueOf(this.mAmount)) {
                this.showShortToast("\u60a8\u5df2\u8d85\u8fc7\u63d0\u73b0\u4f59\u989d");
                return;
            }
            if (Double.valueOf(this.mAmount) == 0.0) {
                this.showShortToast("\u60a8\u5f53\u524d\u6ca1\u6709\u53ef\u63d0\u73b0\u91d1\u989d");
                return;
            }
            if (Double.valueOf(this.mBundleAmount) < 100.0) {
                this.showShortToast("\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u4f4e\u4e8e100\u5143");
                return;
            }
            RequestWithRawCashFragment.HideKeyboard(this.rootView);
            String phoneNum = VertifyDataUtil.getInstance((Context)this.mContext).getLoginData().getMobileNumber();
            RequestWithRawCashVerifyFragment requestWithRawCashVerifyFragment = new RequestWithRawCashVerifyFragment();
            Bundle bundle = new Bundle();
            bundle.putString("amount", this.mAmount);
            bundle.putString("phoneNum", phoneNum);
            requestWithRawCashVerifyFragment.setArguments(bundle);
            this.start((ISupportFragment)requestWithRawCashVerifyFragment);
        }
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }
}

