/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.util.CountDownUtil;
import com.kangxin.common.util.VerifyUtil;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.RequestWuthRawCashSuccessFragment;
import com.kangxin.doctor.worktable.entity.RequestWithdrawCashDataEntity;
import com.kangxin.doctor.worktable.presenter.IValidatePhoneCodePresenter;
import com.kangxin.doctor.worktable.presenter.impl.RequestWithdrawCashPresenter;
import com.kangxin.doctor.worktable.presenter.impl.ValidatePhoneAndCodePresenter;
import com.kangxin.doctor.worktable.presenter.impl.WithdrawCashSmsMsgPresenter;
import com.kangxin.doctor.worktable.view.IRequestWithdrawCashView;
import com.kangxin.doctor.worktable.view.IValidatePhoneAndCodeView;
import com.kangxin.doctor.worktable.view.IWithdrawCashSmsMsgView;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import me.yokeyword.fragmentation.ISupportFragment;
import org.jetbrains.annotations.NotNull;

public class RequestWithRawCashVerifyFragment
extends BaseFragment
implements IToolView,
IWithdrawCashSmsMsgView,
IRequestWithdrawCashView,
IValidatePhoneAndCodeView {
    private static final String TAG = "RequestWithRawCashVerifyFragment";
    private EditText mRealNameEdit;
    private TextView mVercodeTv;
    private EditText mVercodeEdit;
    private TextView mErrNoticeTv;
    private Button mSubmitbtn;
    private String mAmount;
    private String mPhoneNum;
    private String mPhoneNumEdit;
    private CountDownUtil mCountDownUtil;
    private WithdrawCashSmsMsgPresenter mWithdrawCashSmsMsgPresenter = new WithdrawCashSmsMsgPresenter(this);
    private RequestWithdrawCashPresenter mRequestWithdrawCashPresenter = new RequestWithdrawCashPresenter(this);
    private IValidatePhoneCodePresenter mValidatePhoneCodePresenter = new ValidatePhoneAndCodePresenter(this);
    private String mAuthKey;

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)"\u8eab\u4efd\u9a8c\u8bc1");
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mAmount = bundle.getString("amount");
            this.mPhoneNum = bundle.getString("phoneNum");
        }
        this.initViews();
    }

    private void initViews() {
        this.mRealNameEdit = (EditText)this.findViewById(this.rootView, R.id.et_real_name);
        this.mVercodeTv = (TextView)this.findViewById(this.rootView, R.id.tv_vercode);
        this.mVercodeEdit = (EditText)this.findViewById(this.rootView, R.id.edt_vercode);
        this.mErrNoticeTv = (TextView)this.findViewById(this.rootView, R.id.err_notice);
        this.mSubmitbtn = (Button)this.findViewById(this.rootView, R.id.bt_submit);
        this.mCountDownUtil = new CountDownUtil(this.mVercodeTv).setCountDownMillis(60000L).setCountDownColor(R.color.white, 0x1060000);
        this.isVercodeUsable(false);
        String maskNumber = this.mPhoneNum.substring(0, 3) + "****" + this.mPhoneNum.substring(7, this.mPhoneNum.length());
        this.mRealNameEdit.setText((CharSequence)maskNumber);
        if (VerifyUtil.isMobilePhoneNumber((String)this.mPhoneNum)) {
            this.isVercodeUsable(true);
        } else {
            this.isVercodeUsable(false);
        }
        this.mRealNameEdit.setGravity(8388629);
        this.mRealNameEdit.setTextDirection(3);
        this.mRealNameEdit.setSelection(this.mRealNameEdit.getText().toString().trim().length());
        this.mCountDownUtil.setOnDownEndListener(new CountDownUtil.OnDownEndListener(){

            public void onEnd() {
                String phoneNum = TextUtils.isEmpty((CharSequence)RequestWithRawCashVerifyFragment.this.mPhoneNum) ? RequestWithRawCashVerifyFragment.this.mRealNameEdit.getText().toString().trim() : RequestWithRawCashVerifyFragment.this.mPhoneNum;
                if (!TextUtils.isEmpty((CharSequence)phoneNum)) {
                    RequestWithRawCashVerifyFragment.this.isVercodeUsable(true);
                } else {
                    RequestWithRawCashVerifyFragment.this.isVercodeUsable(false);
                }
            }
        });
        this.mVercodeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String phoneNum = TextUtils.isEmpty((CharSequence)RequestWithRawCashVerifyFragment.this.mPhoneNum) ? RequestWithRawCashVerifyFragment.this.mRealNameEdit.getText().toString().trim() : RequestWithRawCashVerifyFragment.this.mPhoneNum;
                if (!TextUtils.isEmpty((CharSequence)phoneNum)) {
                    RequestWithRawCashVerifyFragment.this.isVercodeUsable(true);
                } else {
                    RequestWithRawCashVerifyFragment.this.isVercodeUsable(false);
                }
                RequestWithRawCashVerifyFragment.this.mWithdrawCashSmsMsgPresenter.sendWithdrawCashSmsMsgPhoneNum(phoneNum, false);
                RequestWithRawCashVerifyFragment.this.mCountDownUtil.start();
                RequestWithRawCashVerifyFragment.this.isVercodeUsable(false);
            }
        });
        this.mSubmitbtn.setOnClickListener((View.OnClickListener)new SubmitOnClickListener());
        this.addEdtChangeListener();
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_withrawcash_verify;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    private void addEdtChangeListener() {
        this.mRealNameEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                RequestWithRawCashVerifyFragment.this.mErrNoticeTv.setVisibility(8);
                if (TextUtils.isEmpty((CharSequence)editable.toString())) {
                    RequestWithRawCashVerifyFragment.this.mPhoneNum = "";
                    RequestWithRawCashVerifyFragment.this.mRealNameEdit.setGravity(8388627);
                    RequestWithRawCashVerifyFragment.this.mRealNameEdit.setTextDirection(4);
                    RequestWithRawCashVerifyFragment.this.mRealNameEdit.setSelection(RequestWithRawCashVerifyFragment.this.mRealNameEdit.getText().toString().trim().length());
                } else {
                    RequestWithRawCashVerifyFragment.this.mPhoneNum = RequestWithRawCashVerifyFragment.this.mRealNameEdit.getText().toString().trim();
                    RequestWithRawCashVerifyFragment.this.mRealNameEdit.setGravity(8388629);
                    RequestWithRawCashVerifyFragment.this.mRealNameEdit.setTextDirection(3);
                    RequestWithRawCashVerifyFragment.this.mRealNameEdit.setSelection(RequestWithRawCashVerifyFragment.this.mRealNameEdit.getText().toString().trim().length());
                }
                if (VerifyUtil.isMobilePhoneNumber((String)RequestWithRawCashVerifyFragment.this.mPhoneNum)) {
                    RequestWithRawCashVerifyFragment.this.isVercodeUsable(true);
                } else {
                    RequestWithRawCashVerifyFragment.this.isVercodeUsable(false);
                }
            }
        });
        this.mVercodeEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @RequiresApi(api=16)
            public void afterTextChanged(Editable editable) {
                RequestWithRawCashVerifyFragment.this.mErrNoticeTv.setVisibility(8);
            }
        });
    }

    private void isVercodeUsable(boolean isUse) {
        if (this.getContext() == null) {
            return;
        }
        if (isUse) {
            this.mCountDownUtil.setUsable(true);
            Drawable vercodeDraw = this.getContext().getResources().getDrawable(R.drawable.vercode_order_bg);
            this.mVercodeTv.setBackground(vercodeDraw);
            this.mVercodeTv.setTextColor(this.getResources().getColor(17170443));
            this.mVercodeTv.setClickable(true);
            this.mVercodeTv.setFocusable(true);
            this.mVercodeTv.setText(R.string.forget_send_getvercode);
        } else {
            this.mCountDownUtil.setUsable(false);
            Drawable edtDraw = this.getContext().getResources().getDrawable(R.drawable.edt_order_bg);
            this.mVercodeTv.setBackground(edtDraw);
            this.mVercodeTv.setTextColor(this.getResources().getColor(0x1060000));
            this.mVercodeTv.setText(R.string.forget_send_getvercode);
            this.mVercodeTv.setClickable(false);
            this.mVercodeTv.setFocusable(false);
        }
    }

    public void finishCurrentView() {
        RequestWithRawCashVerifyFragment.HideKeyboard(this.rootView);
        this.mCountDownUtil.reset();
        this.pop();
    }

    @Override
    public void getSmsMsgOk(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        if (responseBody.getCode() == 200) {
            LoginSuccess loginSuccess = (LoginSuccess)responseBody.getResult();
            this.mAuthKey = loginSuccess.getAuthKey();
        } else {
            this.showShortToast(responseBody.getMsg());
        }
    }

    public void onError(String msg) {
        this.showShortToast(msg);
    }

    @Override
    public void receiveSuccess(int code, String msg, RequestWithdrawCashDataEntity requestWithdrawCashDataEntity) {
        if (code != 200) {
            this.showShortToast(msg);
            return;
        }
        RequestWithRawCashVerifyFragment.HideKeyboard(this.rootView);
        RequestWuthRawCashSuccessFragment requestWuthRawCashSuccessFragment = new RequestWuthRawCashSuccessFragment();
        Bundle bundle = new Bundle();
        bundle.putString("amount", this.mAmount);
        bundle.putString("time", RequestWithRawCashVerifyFragment.ms2Date(System.currentTimeMillis()));
        requestWuthRawCashSuccessFragment.setArguments(bundle);
        this.start((ISupportFragment)requestWuthRawCashSuccessFragment);
    }

    private static String ms2Date(long _ms) {
        Date date = new Date(_ms);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        return format.format(date);
    }

    @Override
    public void getValidatePhoneAndCodeOk(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        if (responseBody.getCode() == 200) {
            RequestWithRawCashVerifyFragment.HideKeyboard(this.rootView);
            this.mRequestWithdrawCashPresenter.setRequestWithdrawCash(this.mAmount, true);
        } else {
            this.showShortToast(responseBody.getMsg());
        }
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }

    private class SubmitOnClickListener
    implements View.OnClickListener {
        private SubmitOnClickListener() {
        }

        public void onClick(View v) {
            if (TextUtils.isEmpty((CharSequence)RequestWithRawCashVerifyFragment.this.mPhoneNum)) {
                RequestWithRawCashVerifyFragment.this.mPhoneNumEdit = RequestWithRawCashVerifyFragment.this.mRealNameEdit.getText().toString().trim();
            } else {
                RequestWithRawCashVerifyFragment.this.mPhoneNumEdit = RequestWithRawCashVerifyFragment.this.mPhoneNum;
            }
            String verCode = RequestWithRawCashVerifyFragment.this.mVercodeEdit.getText().toString().trim();
            if (TextUtils.isEmpty((CharSequence)RequestWithRawCashVerifyFragment.this.mAuthKey)) {
                ToastUtils.showLong((CharSequence)"\u8bf7\u5148\u53d1\u9001\u9a8c\u8bc1\u7801");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)RequestWithRawCashVerifyFragment.this.mPhoneNumEdit)) {
                RequestWithRawCashVerifyFragment.this.mErrNoticeTv.setVisibility(0);
                RequestWithRawCashVerifyFragment.this.mErrNoticeTv.setText((CharSequence)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            if (!VerifyUtil.isMobilePhoneNumber((String)RequestWithRawCashVerifyFragment.this.mPhoneNumEdit)) {
                RequestWithRawCashVerifyFragment.this.mErrNoticeTv.setVisibility(0);
                RequestWithRawCashVerifyFragment.this.mErrNoticeTv.setText((CharSequence)"\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)verCode)) {
                RequestWithRawCashVerifyFragment.this.mErrNoticeTv.setVisibility(0);
                RequestWithRawCashVerifyFragment.this.mErrNoticeTv.setText((CharSequence)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            RequestWithRawCashVerifyFragment.this.mValidatePhoneCodePresenter.getValidatePhoneCodePresenter(RequestWithRawCashVerifyFragment.this.mPhoneNumEdit, verCode, RequestWithRawCashVerifyFragment.this.mAuthKey, true);
        }
    }
}

