/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import butterknife.BindView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.base.BaseFlushMoreFragment;
import com.kangxin.common.byh.entity.v2.HospitalEntityV2;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.v2.BHSampleHospitalListAdapter;
import com.kangxin.doctor.worktable.presenter.ISampleHospitalListPresenter;
import com.kangxin.doctor.worktable.presenter.impl2.BHSampleHospitalListPresenter;
import com.kangxin.doctor.worktable.view.ISampleHospitalListView;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

public class SampleHospitalListFragment
extends BaseFlushMoreFragment<HospitalEntityV2>
implements IToolView,
ISampleHospitalListView<HospitalEntityV2> {
    private static final String TAG = "SampleHospitalListFragm";
    private static final int REQUEST_HOSPITAL_CODE = 3;
    @BindView(value=2131428269)
    EditText vSearchView;
    @BindView(value=2131427915)
    View vSearchBarView;
    @BindView(value=2131427708)
    View vActionBarView;
    private static boolean isHideSearchBar = false;
    private String mAreaCode = "";
    private ISampleHospitalListPresenter mSampleHospitalListPresenter = new BHSampleHospitalListPresenter(this);

    public static SampleHospitalListFragment newInstance(String areaCode, boolean hideFlag) {
        isHideSearchBar = hideFlag;
        Bundle bundle = new Bundle();
        bundle.putString("areaCode", areaCode);
        SampleHospitalListFragment sampleHospitalListFragment = new SampleHospitalListFragment();
        sampleHospitalListFragment.setArguments(bundle);
        return sampleHospitalListFragment;
    }

    public void init() {
        super.init();
        this.mAreaCode = this.getArguments().getString("areaCode");
        this.vToolTitleTextView.setText((CharSequence)"\u533b\u9662\u540d\u79f0");
        Log.i((String)TAG, (String)("init: isHide:" + isHideSearchBar));
        if (isHideSearchBar) {
            this.vSearchBarView.setVisibility(8);
            this.vActionBarView.setVisibility(8);
        } else {
            this.vSearchBarView.setVisibility(0);
            this.vActionBarView.setVisibility(0);
        }
    }

    public void onInitComplete() {
        super.onInitComplete();
        this.dispatchEvent();
    }

    protected void flushOrLoad(boolean isGetMore) {
        Log.i((String)TAG, (String)("flushOrLoad: isGetMore:" + isGetMore));
        this.mSampleHospitalListPresenter.getHospitalList(isGetMore, this.vSearchView.getText().toString(), this.mAreaCode);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void updateHosListEvent(ByhCommEvent.UpdateHosListEvent updateHosListEvent) {
        String code = updateHosListEvent.getCode();
        String cityName = updateHosListEvent.getCityName();
        Log.i((String)TAG, (String)("updateHosListEvent: code:" + code + ", cityName:" + cityName));
        this.vSearchView.setText((CharSequence)cityName);
        this.mAreaCode = code;
        this.flushOrLoad(false);
    }

    private void dispatchEvent() {
        this.mAdapter.setOnItemClickListener((adapter, view, position) -> {
            HospitalEntityV2 hospitalEntity = (HospitalEntityV2)this.mAdapter.getData().get(position);
            int id2 = Integer.parseInt(hospitalEntity.getHospitalId());
            Bundle bundle = new Bundle();
            bundle.putInt("hospitalId", id2);
            bundle.putString("hospitalName", hospitalEntity.getHospitalName());
            this.setFragmentResult(3, bundle);
            bundle.putString("openCode", hospitalEntity.getAppCode());
            EventBus.getDefault().post((Object)new ByhCommEvent.HosEntityEvent(hospitalEntity, this.mAreaCode));
            if (!isHideSearchBar) {
                this.finishCurrentView();
            }
        });
        this.vSearchView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (isHideSearchBar) {
                    return;
                }
                Log.i((String)SampleHospitalListFragment.TAG, (String)"afterTextChanged:================");
                SampleHospitalListFragment.this.mSampleHospitalListPresenter.getHospitalList(false, SampleHospitalListFragment.this.vSearchView.getText().toString(), SampleHospitalListFragment.this.mAreaCode);
            }
        });
    }

    protected BaseQuickAdapter<HospitalEntityV2, ? extends BaseViewHolder> getBaseQuickAdapter() {
        return new BHSampleHospitalListAdapter(null);
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_sample_hospital_list;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }
}

