/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import butterknife.BindView;
import com.google.android.material.tabs.TabLayout;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.DepartmentEntity;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.DepExpertListAdapter;
import com.kangxin.doctor.worktable.fragment.v2.ExpertDepSelectPopWindowV2;
import com.kangxin.doctor.worktable.presenter.ISelectUnionExpertPresenter;
import com.kangxin.doctor.worktable.presenter.impl.SelectUnionExpertPresenter;
import com.kangxin.doctor.worktable.view.ISelectExpertView;
import com.kangxin.doctor.worktable.widget.ExpertDepSelectPopWindow;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectExpertFragment
extends BaseFragment
implements IToolView,
ISelectExpertView {
    @BindView(value=2131428283)
    public TabLayout vTabLayout;
    @BindView(value=2131428271)
    public ImageView vSelectImage;
    @BindView(value=2131428130)
    public ViewPager vDepPager;
    @BindView(value=2131428291)
    public RelativeLayout vToolBar;
    @BindView(value=2131428269)
    public EditText vSearchView;
    protected List mExpertList = new ArrayList();
    protected PagerAdapter mDepExpertListAdapter;
    protected ExpertDepSelectPopWindow vExpertDepSelectPopWindow;
    protected ISelectUnionExpertPresenter mSelectUnionExpertPresenter = new SelectUnionExpertPresenter(this);
    protected String mHospitalId = "";

    public static SelectExpertFragment newInstance(String hospitalId) {
        SelectExpertFragment selectExpertFragment = new SelectExpertFragment();
        selectExpertFragment.mHospitalId = hospitalId;
        Bundle bundle = new Bundle();
        bundle.putString("hospitalId", hospitalId);
        selectExpertFragment.setArguments(bundle);
        return selectExpertFragment;
    }

    public void init() {
        this.mHospitalId = this.getArguments().getString("hospitalId");
        this.vToolTitleTextView.setText((CharSequence)"\u9009\u62e9\u4e13\u5bb6");
        this.vSearchView.setHint((CharSequence)"\u641c\u7d22\u533b\u751f\u59d3\u540d");
        View typeSelect = View.inflate((Context)this.mContext, (int)R.layout.by_view_select_dep, null);
        this.vExpertDepSelectPopWindow = new ExpertDepSelectPopWindowV2(typeSelect, this.mHospitalId);
        this.vDepPager.setAdapter(this.mDepExpertListAdapter);
        this.vTabLayout.setupWithViewPager(this.vDepPager);
        this.mDepExpertListAdapter = new DepExpertListAdapter(this.getChildFragmentManager(), this.mExpertList);
        this.dispatchEvent();
        this.mSelectUnionExpertPresenter.getHospitalDepartmentList(this.mHospitalId);
    }

    protected void dispatchEvent() {
        this.vSelectImage.setOnClickListener(v -> this.vExpertDepSelectPopWindow.showAsDropDownAndFull((View)this.vToolBar, 0, 0));
        this.vExpertDepSelectPopWindow.setOnExpertDepSelectClickListener((hospitalId, departmentId) -> this.toItemPosition(departmentId));
    }

    protected void toItemPosition(long departmentId) {
        for (Object obj : this.mExpertList) {
            DepartmentEntity entity;
            if (!(obj instanceof DepartmentEntity) || (entity = (DepartmentEntity)obj).getId() != departmentId) continue;
            this.vDepPager.setCurrentItem(this.mExpertList.indexOf(entity));
            break;
        }
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_expert_select;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }

    public boolean onBackPressedSupport() {
        if (this.vExpertDepSelectPopWindow.isShowing()) {
            this.vExpertDepSelectPopWindow.dismiss();
            return true;
        }
        return super.onBackPressedSupport();
    }

    @Override
    public void setPagesData(List t) {
        this.mExpertList.clear();
        this.mExpertList.addAll(t);
        this.mDepExpertListAdapter.notifyDataSetChanged();
    }
}

