/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.ServiceSettingPersonalSetFragment;
import com.kangxin.doctor.worktable.ServiceSettingTypeListFragment;
import com.kangxin.doctor.worktable.adapter.ServiceSettingHospitalListAdapter;
import com.kangxin.doctor.worktable.adapter.ServiceSettingPersonalListAdapter;
import com.kangxin.doctor.worktable.entity.ServiceSettingHospitalEntity;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.IServiceSettingInfoPresenter;
import com.kangxin.doctor.worktable.presenter.impl.ServiceSettingInfoPresenter;
import com.kangxin.doctor.worktable.view.IServiceSettingInfoView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

public class ServiceSettingFragment
extends BaseFragment
implements IToolView,
IServiceSettingInfoView {
    private static final String TAG = "ServiceSettingFragment";
    private RecyclerView vRecyclerView1;
    private RecyclerView vRecyclerView2;
    private IServiceSettingInfoPresenter mServicePresenter;
    private ServiceSettingPersonalListAdapter mPersonalAdapter;
    private ServiceSettingHospitalListAdapter mHospitalAdapter;
    private List<ServiceSettingHospitalEntity> mPersonalList = new ArrayList<ServiceSettingHospitalEntity>();
    private List<ServiceSettingHospitalEntity> mHospitalList = new ArrayList<ServiceSettingHospitalEntity>();

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)"\u670d\u52a1\u8bbe\u7f6e");
        this.mServicePresenter = new ServiceSettingInfoPresenter(this);
        this.mServicePresenter.sendRequestServiceHospitalInfo();
        this.vRecyclerView1 = (RecyclerView)this.findViewById(this.rootView, R.id.vRecyclerView1);
        this.vRecyclerView2 = (RecyclerView)this.findViewById(this.rootView, R.id.vRecyclerView2);
        this.vRecyclerView1.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.vRecyclerView2.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.vRecyclerView1.setNestedScrollingEnabled(false);
        this.vRecyclerView2.setNestedScrollingEnabled(false);
        this.mPersonalAdapter = new ServiceSettingPersonalListAdapter(this.mContext);
        this.mHospitalAdapter = new ServiceSettingHospitalListAdapter(this.mContext);
        this.vRecyclerView1.setAdapter((RecyclerView.Adapter)this.mPersonalAdapter);
        this.vRecyclerView2.setAdapter((RecyclerView.Adapter)this.mHospitalAdapter);
        this.mPersonalAdapter.setOnItemClickListener((adapter, view, position) -> {
            ServiceSettingHospitalEntity item = (ServiceSettingHospitalEntity)adapter.getItem(position);
            ServiceSettingPersonalSetFragment listPersonalFragment = new ServiceSettingPersonalSetFragment();
            Bundle bundle = new Bundle();
            bundle.putSerializable("personalentity", (Serializable)item);
            listPersonalFragment.setArguments(bundle);
            this.start((ISupportFragment)listPersonalFragment);
        });
        this.mHospitalAdapter.setListener(item -> {
            ServiceSettingTypeListFragment listHospitalFragment = new ServiceSettingTypeListFragment();
            Bundle bundle = new Bundle();
            bundle.putSerializable("hospitalentity", (Serializable)item);
            listHospitalFragment.setArguments(bundle);
            this.start((ISupportFragment)listHospitalFragment);
        });
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_service_setting;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        Objects.requireNonNull(this.getActivity()).finish();
    }

    @Override
    public void receiveServiceHospitalEntity(List<ServiceSettingHospitalEntity> hospitalEntities) {
        this.separateList(this.fillHosList(hospitalEntities));
        this.mPersonalAdapter.setNewData(this.mPersonalList);
        this.mHospitalAdapter.setNewData(this.mHospitalList);
    }

    private void separateList(List<ServiceSettingHospitalEntity> hospitalEntities) {
        this.mPersonalList.clear();
        this.mHospitalList.clear();
        if (hospitalEntities == null) {
            return;
        }
        if (hospitalEntities.isEmpty()) {
            return;
        }
        for (ServiceSettingHospitalEntity serviceSettingHospitalEntity : hospitalEntities) {
            if (1 == serviceSettingHospitalEntity.getType()) {
                this.mPersonalList.add(serviceSettingHospitalEntity);
                continue;
            }
            if (2 != serviceSettingHospitalEntity.getType()) continue;
            this.mHospitalList.add(serviceSettingHospitalEntity);
        }
    }

    private List<ServiceSettingHospitalEntity> fillHosList(List<ServiceSettingHospitalEntity> hospitalEntities) {
        ArrayList<ServiceSettingHospitalEntity> fillServiceList = new ArrayList<ServiceSettingHospitalEntity>();
        for (ServiceSettingHospitalEntity serviceSettingHospitalEntity : hospitalEntities) {
            int type = serviceSettingHospitalEntity.getType();
            if (1 != type && 2 != type) continue;
            fillServiceList.add(serviceSettingHospitalEntity);
        }
        return fillServiceList;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveExecutiveInfo(WorkTabEvent.ServiceSettingUpdate updateServiceInfo) {
        this.mServicePresenter.sendRequestServiceHospitalInfo();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveExecutivePriceInfo(WorkTabEvent.ServiceSettingPriceUpdate updateServicePrice) {
        this.mServicePresenter.sendRequestServiceHospitalInfo();
    }
}

