/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.widget.SwitchCompat;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.text.TextClickableSpan;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.ServiceSettingPriceFragment;
import com.kangxin.doctor.worktable.entity.ServiceSettingHospitalEntity;
import com.kangxin.doctor.worktable.entity.ServiceSettingPriceSetEntity;
import com.kangxin.doctor.worktable.entity.v2.HosChildEntity;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.IServiceSettingPersonInfoPresenter;
import com.kangxin.doctor.worktable.presenter.impl.ServiceSettingPersonInfoPresenter;
import com.kangxin.doctor.worktable.view.IBindHosChildServiceView;
import com.kangxin.doctor.worktable.view.IServiceSettingPersonInfoView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

public class ServiceSettingPersonalSetFragment
extends BaseFragment
implements IToolView,
IServiceSettingPersonInfoView,
IBindHosChildServiceView {
    private static final String TAG = "ServiceSettingPersonalS";
    private ServiceSettingHospitalEntity mPersonalEntity;
    private int mStatus;
    private SwitchCompat vSwitchCompat;
    private TextView vTelephoneTv;
    private TextView vAmountTv;
    private TextView vStatusTv;
    private RelativeLayout vTeletextLayout;
    private int mCode;
    private IServiceSettingPersonInfoPresenter mPersonInfoPresenter = new ServiceSettingPersonInfoPresenter(this);
    private IServiceSettingPersonInfoPresenter mQueryHosChildPresent = new ServiceSettingPersonInfoPresenter(this);
    private float mAmount = 0.0f;
    private String mDicCode;

    private void setAmount(String amount) {
        if (this.mStatus == 1) {
            this.vAmountTv.setText((CharSequence)("\u00a5" + amount));
        } else if (amount == null) {
            this.vAmountTv.setText((CharSequence)"\u00a5100");
        } else {
            this.vAmountTv.setText((CharSequence)("\u00a5" + amount));
        }
    }

    public void init() {
        this.vAmountTv = (TextView)this.findViewById(this.rootView, R.id.personal_service_next_icon_teletext_tv);
        this.vSwitchCompat = (SwitchCompat)this.findViewById(this.rootView, R.id.switch_btn);
        this.vTelephoneTv = (TextView)this.findViewById(this.rootView, R.id.telephone_tv);
        this.vStatusTv = (TextView)this.findViewById(this.rootView, R.id.service_status_tv);
        this.vTeletextLayout = (RelativeLayout)this.findViewById(this.rootView, R.id.personal_service_teletext_rl);
        this.vTeletextLayout.setOnClickListener((View.OnClickListener)new TeletextLayouOnClickListener());
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mPersonalEntity = (ServiceSettingHospitalEntity)bundle.getSerializable("personalentity");
            this.vToolTitleTextView.setText((CharSequence)this.mPersonalEntity.getGroupName());
            this.mStatus = this.mPersonalEntity.getStatus();
        }
        String docId = VertifyDataUtil.getInstance((Context)this.getContext()).getDoctorId();
        String parentCode = this.mPersonalEntity.getGroupCode();
        this.mQueryHosChildPresent.dictionaryByParentCode(docId, parentCode);
        if (this.mStatus == 1) {
            this.vSwitchCompat.setChecked(true);
            this.vStatusTv.setText((CharSequence)"\u5df2\u5f00\u542f\uff0c\u53ef\u4eab\u53d7\u8be5\u670d\u52a1");
        } else if (this.mStatus == -1) {
            this.vSwitchCompat.setChecked(false);
            this.vStatusTv.setText((CharSequence)"\u5df2\u5173\u95ed");
        }
        this.vSwitchCompat.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                this.vSwitchCompat.setChecked(true);
                this.vStatusTv.setText((CharSequence)"\u5df2\u5f00\u542f\uff0c\u53ef\u4eab\u53d7\u8be5\u670d\u52a1");
                this.mStatus = 1;
                this.reqChangeDocService(this.mStatus);
            } else {
                this.vSwitchCompat.setChecked(false);
                this.vStatusTv.setText((CharSequence)"\u5df2\u5173\u95ed");
                this.mStatus = -1;
                this.reqChangeDocService(this.mStatus);
            }
        });
        String phone = this.vTelephoneTv.getText().toString();
        SpannableString spannableString = new SpannableString((CharSequence)phone);
        this.setOnclickSpan(spannableString, phone, "010-82736320", view -> this.showShortToast("010-82736320"));
        this.vTelephoneTv.setText((CharSequence)spannableString);
        this.vTelephoneTv.setMovementMethod(LinkMovementMethod.getInstance());
    }

    private void reqChangeDocService(int status) {
        ServiceSettingPriceSetEntity serviceSettingPriceSetEntity = new ServiceSettingPriceSetEntity();
        int doctorId = -1;
        String docId = VertifyDataUtil.getInstance((Context)this.getContext()).getDoctorId();
        if (!TextUtils.isEmpty((CharSequence)docId)) {
            doctorId = Integer.parseInt(docId);
        }
        serviceSettingPriceSetEntity.setDoctorId(doctorId);
        serviceSettingPriceSetEntity.setGroupCode(this.mPersonalEntity.getGroupCode());
        serviceSettingPriceSetEntity.setStatus(status);
        ServiceSettingPriceSetEntity.ListBean listBean = new ServiceSettingPriceSetEntity.ListBean();
        listBean.setAmount(Float.valueOf(this.mAmount));
        listBean.setServiceCode(this.mDicCode);
        ArrayList<ServiceSettingPriceSetEntity.ListBean> listBeanList = new ArrayList<ServiceSettingPriceSetEntity.ListBean>();
        listBeanList.add(listBean);
        serviceSettingPriceSetEntity.setList(listBeanList);
        this.mPersonInfoPresenter.doDocHosService(serviceSettingPriceSetEntity, true);
    }

    public SpannableString setOnclickSpan(SpannableString spannableString, String allString, String clickString, View.OnClickListener onClickListener) {
        spannableString.setSpan((Object)new TextClickableSpan(-14904854, onClickListener), allString.indexOf(clickString), allString.indexOf(clickString) + clickString.length(), 33);
        return spannableString;
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_service_content_setting_content;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        if (this.mCode == 200) {
            EventBus.getDefault().post((Object)new WorkTabEvent.ServiceSettingUpdate());
            this.pop();
        } else {
            EventBus.getDefault().post((Object)new WorkTabEvent.ServiceSettingUpdate());
            this.pop();
        }
    }

    @Override
    public void updatePersonInfoOk(int code) {
        this.mCode = code;
        if (code == 200) {
            if (this.mStatus == 1) {
                this.showShortToast("\u670d\u52a1\u5df2\u5f00\u542f");
            } else if (this.mStatus == -1) {
                this.showShortToast("\u670d\u52a1\u5df2\u5173\u95ed");
            }
        } else {
            if (this.mStatus == 1) {
                this.vSwitchCompat.setChecked(true);
            } else if (this.mStatus == -1) {
                this.vSwitchCompat.setChecked(false);
            }
            this.showShortToast("\u8bf7\u6c42\u5931\u8d25");
        }
    }

    @Override
    public void bindChildServiceView(List<HosChildEntity> list) {
        if (list != null && list.size() > 0) {
            HosChildEntity hosChildEntity = list.get(0);
            this.mAmount = hosChildEntity.getAmount();
            this.mDicCode = hosChildEntity.getDicCode();
            this.setAmount(hosChildEntity.getAmount() + "");
        }
    }

    public boolean onBackPressedSupport() {
        if (this.mCode == 200) {
            EventBus.getDefault().post((Object)new WorkTabEvent.ServiceSettingUpdate());
            this.pop();
        } else {
            EventBus.getDefault().post((Object)new WorkTabEvent.ServiceSettingUpdate());
            this.pop();
        }
        return true;
    }

    private class TeletextLayouOnClickListener
    implements View.OnClickListener {
        private TeletextLayouOnClickListener() {
        }

        public void onClick(View v) {
            if (ServiceSettingPersonalSetFragment.this.mStatus == 1) {
                ServiceSettingPriceFragment teletextFragment = new ServiceSettingPriceFragment();
                Bundle bundle = new Bundle();
                bundle.putSerializable("personalentity", (Serializable)ServiceSettingPersonalSetFragment.this.mPersonalEntity);
                bundle.putString("amount", ServiceSettingPersonalSetFragment.this.vAmountTv.getText().toString());
                bundle.putInt("status", ServiceSettingPersonalSetFragment.this.mStatus);
                bundle.putString("mdict_code", ServiceSettingPersonalSetFragment.this.mDicCode);
                teletextFragment.setArguments(bundle);
                ServiceSettingPersonalSetFragment.this.start((ISupportFragment)teletextFragment);
            } else if (ServiceSettingPersonalSetFragment.this.mStatus == -1) {
                ServiceSettingPersonalSetFragment.this.showShortToast("\u8bf7\u5148\u6253\u5f00\u670d\u52a1\u8bbe\u7f6e");
            }
        }
    }
}

