/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.ServiceSettingPersonalSetFragment;
import com.kangxin.doctor.worktable.entity.ServiceSettingHospitalEntity;
import com.kangxin.doctor.worktable.entity.ServiceSettingPriceSetEntity;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.IServiceSettingPersonInfoPresenter;
import com.kangxin.doctor.worktable.presenter.impl.ServiceSettingPersonInfoPresenter;
import com.kangxin.doctor.worktable.view.IServiceSettingPersonInfoView;
import java.util.ArrayList;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

public class ServiceSettingPriceFragment
extends BaseFragment
implements IToolView,
IServiceSettingPersonInfoView {
    private static final String TAG = "ServiceSettingPriceFrag";
    private TextView vTypeTv;
    private int mStatus;
    private ServiceSettingHospitalEntity mHosServiceEntity;
    private EditText mAmountEdit;
    private Button mSetFinishBtn;
    private String mAmount;
    private IServiceSettingPersonInfoPresenter mPersonInfoPresenter = new ServiceSettingPersonInfoPresenter(this);
    private String mDitCode;

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)"\u4ef7\u683c\u8bbe\u7f6e");
        this.vTypeTv = (TextView)this.findViewById(this.rootView, R.id.service_type_tv);
        this.mAmountEdit = (EditText)this.findViewById(this.rootView, R.id.edt_amount);
        this.mSetFinishBtn = (Button)this.findViewById(this.rootView, R.id.setting_finish_ok);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mHosServiceEntity = (ServiceSettingHospitalEntity)bundle.getSerializable("personalentity");
            String amount = bundle.getString("amount");
            this.mStatus = bundle.getInt("status");
            this.mDitCode = bundle.getString("mdict_code");
            this.mAmount = amount.substring(1, amount.length());
            this.mAmountEdit.setText((CharSequence)this.mAmount);
            this.vTypeTv.setText((CharSequence)this.mHosServiceEntity.getGroupName());
        }
        this.mAmountEdit.setInputType(8194);
        this.mAmountEdit.setFilters(new InputFilter[]{(source, start, end, dest, dstart, dend) -> {
            if (source.equals(".") && dest.toString().length() == 0) {
                return "0.";
            }
            if (dest.toString().contains(".")) {
                int index = dest.toString().indexOf(".");
                int length = dest.toString().substring(index).length();
                if (length == 3) {
                    return "";
                }
            }
            return null;
        }});
        this.mAmountEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                ServiceSettingPriceFragment.this.mAmount = ServiceSettingPriceFragment.this.mAmountEdit.getText().toString().trim();
            }
        });
        this.mSetFinishBtn.setOnClickListener((View.OnClickListener)new SetFinishOnClickListener());
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_service_setting_price;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        ServiceSettingPriceFragment.HideKeyboard(this.rootView);
        this.pop();
    }

    @Override
    public void updatePersonInfoOk(int code) {
        if (code == 200) {
            ServiceSettingPriceFragment.HideKeyboard(this.rootView);
            this.showShortToast("\u8bbe\u7f6e\u4ef7\u683c\u6210\u529f");
            this.popTo(ServiceSettingPersonalSetFragment.class, true);
            EventBus.getDefault().post((Object)new WorkTabEvent.ServiceSettingPriceUpdate());
        } else {
            ServiceSettingPriceFragment.HideKeyboard(this.rootView);
            this.showShortToast("\u8bbe\u7f6e\u4ef7\u683c\u5931\u8d25");
        }
    }

    private void reqChangeDocService() {
        ServiceSettingPriceSetEntity serviceSettingPriceSetEntity = new ServiceSettingPriceSetEntity();
        int doctorId = -1;
        String docId = VertifyDataUtil.getInstance((Context)this.getContext()).getDoctorId();
        if (!TextUtils.isEmpty((CharSequence)docId)) {
            doctorId = Integer.parseInt(docId);
        }
        serviceSettingPriceSetEntity.setDoctorId(doctorId);
        serviceSettingPriceSetEntity.setGroupCode(this.mHosServiceEntity.getGroupCode());
        serviceSettingPriceSetEntity.setStatus(this.mStatus);
        ServiceSettingPriceSetEntity.ListBean listBean = new ServiceSettingPriceSetEntity.ListBean();
        float amount = Float.parseFloat(this.mAmount);
        listBean.setAmount(Float.valueOf(amount));
        listBean.setServiceCode(this.mDitCode);
        ArrayList<ServiceSettingPriceSetEntity.ListBean> listBeanList = new ArrayList<ServiceSettingPriceSetEntity.ListBean>();
        listBeanList.add(listBean);
        serviceSettingPriceSetEntity.setList(listBeanList);
        this.mPersonInfoPresenter.doDocHosService(serviceSettingPriceSetEntity, true);
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }

    private class SetFinishOnClickListener
    implements View.OnClickListener {
        private SetFinishOnClickListener() {
        }

        public void onClick(View v) {
            if (TextUtils.isEmpty((CharSequence)ServiceSettingPriceFragment.this.mAmount)) {
                ServiceSettingPriceFragment.this.showShortToast("\u8bf7\u8f93\u5165\u91d1\u989d");
                return;
            }
            ServiceSettingPriceFragment.HideKeyboard(ServiceSettingPriceFragment.this.rootView);
            ServiceSettingPriceFragment.this.reqChangeDocService();
        }
    }
}

