/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.ServiceSettingDetailsListAdapter;
import com.kangxin.doctor.worktable.entity.ServiceSettingHospitalEntity;
import com.kangxin.doctor.worktable.entity.v2.HosChildEntity;
import com.kangxin.doctor.worktable.presenter.IServiceSettingPersonInfoPresenter;
import com.kangxin.doctor.worktable.presenter.impl.ServiceSettingPersonInfoPresenter;
import com.kangxin.doctor.worktable.view.IBindHosChildServiceView;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ServiceSettingTypeListFragment
extends BaseFragment
implements IToolView,
IBindHosChildServiceView {
    private static final String TAG = "ServiceSettingTypeListF";
    private RecyclerView mServiceListCycler;
    private ServiceSettingDetailsListAdapter mDetailsAdapter;
    private IServiceSettingPersonInfoPresenter mSericeListPresent;

    public void init() {
        this.mServiceListCycler = (RecyclerView)this.findViewById(this.rootView, R.id.vPatientsList);
        this.mServiceListCycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mDetailsAdapter = new ServiceSettingDetailsListAdapter();
        this.mServiceListCycler.setAdapter((RecyclerView.Adapter)this.mDetailsAdapter);
        ServiceSettingHospitalEntity hospitalEntity = null;
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            hospitalEntity = (ServiceSettingHospitalEntity)bundle.getSerializable("hospitalentity");
            this.vToolTitleTextView.setText((CharSequence)hospitalEntity.getGroupName());
        }
        this.mSericeListPresent = new ServiceSettingPersonInfoPresenter(this);
        String docId = VertifyDataUtil.getInstance((Context)this.getContext()).getDoctorId();
        if (hospitalEntity != null) {
            String parentCode = hospitalEntity.getGroupCode();
            this.mSericeListPresent.dictionaryByParentCode(docId, parentCode);
        }
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_registered_info;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }

    @Override
    public void bindChildServiceView(List<HosChildEntity> list) {
        if (list == null) {
            return;
        }
        this.mDetailsAdapter.setNewData(list);
    }
}

