/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.app.Dialog;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.TextView;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.builder.TimePickerBuilder;
import com.bigkoo.pickerview.listener.OnTimeSelectListener;
import com.bigkoo.pickerview.view.TimePickerView;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.TimeUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.SubscribeTimeEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.service.IOrderTypeProvider;
import com.kangxin.common.byh.widget.SubscribeTimeCandlerView;
import com.kangxin.common.byh.widget.SubscribeTimeView;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.presenter.ISubscribeTimePresenter;
import com.kangxin.doctor.worktable.presenter.clc.ClcSubcribeTimePresent;
import com.kangxin.doctor.worktable.presenter.impl.SubscribeTimePresenter;
import com.kangxin.doctor.worktable.view.ISubscribeTimeView;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalDateTime;

@Route(path="/immsginvite/SubscribeTimeFragment")
public class SubscribeTimeFragment
extends BaseFragment
implements IToolView,
ISubscribeTimeView {
    @BindView(value=2131428216)
    TextView vPatientCase;
    @BindView(value=2131428220)
    TextView vPatientInfo;
    @BindView(value=2131428136)
    TextView vDoctorInfo;
    @BindView(value=2131428279)
    SubscribeTimeView vSubscribeTimeView;
    @BindView(value=2131428280)
    SubscribeTimeCandlerView vSubscribeTimeViewV2;
    @BindView(value=2131428108)
    TextView vCommitSubscribe;
    @BindView(value=2131427807)
    TextView vDiaPatiLabelView;
    @BindView(value=2131427934)
    TextView vSelDiaTimeLabeView;
    private Dialog mDateDialog;
    private String date = null;
    private String time = null;
    private int mOrderId;
    private int expertId;
    private ISubscribeTimePresenter mSubscribeTimePresenter;
    private boolean isToday = true;
    private String mDiaName = "";

    public static SubscribeTimeFragment newInstance(int mOrderId, String suit, String patientName, String patientAge, String patientSex, String doctorHosName, String doctorName, int expertId) {
        SubscribeTimeFragment subscribeTimeFragment = new SubscribeTimeFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("mOrderId", mOrderId);
        bundle.putString("suit", suit);
        bundle.putString("patientName", patientName);
        bundle.putString("patientAge", patientAge);
        bundle.putString("patientSex", patientSex);
        bundle.putString("doctorHosName", doctorHosName);
        bundle.putString("doctorName", doctorName);
        bundle.putInt("expertId", expertId);
        subscribeTimeFragment.setArguments(bundle);
        return subscribeTimeFragment;
    }

    public void init() {
        IOrderTypeProvider orderTypeProvider = (IOrderTypeProvider)ARouter.getInstance().build("/ordercs/pro/OrderTypeProvider").navigation();
        if (4 == orderTypeProvider.getOrderType()) {
            this.mDiaName = "\u95e8\u8bca";
            this.mSubscribeTimePresenter = new ClcSubcribeTimePresent(this);
        } else {
            this.mDiaName = "\u4f1a\u8bca";
            this.mSubscribeTimePresenter = new SubscribeTimePresenter(this);
        }
        this.vDiaPatiLabelView.setText((CharSequence)(this.mDiaName + "\u60a3\u8005"));
        this.vSelDiaTimeLabeView.setText((CharSequence)("\u8bf7\u9009\u62e9\u9884\u7ea6" + this.mDiaName + "\u65f6\u95f4"));
        Bundle bundle = new Bundle();
        this.mOrderId = this.getArguments().getInt("mOrderId");
        this.expertId = this.getArguments().getInt("expertId");
        this.vPatientCase.setText((CharSequence)this.getArguments().getString("suit"));
        this.vPatientInfo.setText((CharSequence)(this.getArguments().getString("patientName") + "," + this.getArguments().getString("patientSex") + " , " + this.getArguments().getString("patientAge") + "\u5c81"));
        this.vDoctorInfo.setText((CharSequence)(this.getArguments().getString("doctorHosName") + " " + this.getArguments().getString("doctorName")));
        this.vToolTitleTextView.setText((CharSequence)("\u9884\u7ea6" + this.mDiaName + "\u65f6\u95f4"));
        this.mSubscribeTimePresenter.getSubscribeDate(this.expertId);
        this.dispatchEvent();
        this.initTimeView();
    }

    private void initTimeView() {
        TimePickerView pickerView = new TimePickerBuilder(this.mContext, new OnTimeSelectListener(){

            public void onTimeSelect(Date date, View v) {
                if (SubscribeTimeFragment.this.isToday && date.getTime() < new Date().getTime()) {
                    ToastUtils.showShort((CharSequence)"\u60a8\u9009\u62e9\u7684\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
                    SubscribeTimeFragment.this.time = "";
                    return;
                }
                SubscribeTimeFragment.this.time = TimeUtils.date2String((Date)date, (DateFormat)new SimpleDateFormat("HH:mm"));
            }
        }).setType(new boolean[]{false, false, false, true, true, false}).setCancelText("\u53d6\u6d88").setSubmitText("\u786e\u5b9a").setTitleSize(20).setTitleText("\u65f6\u95f4").setOutSideCancelable(false).isCyclic(true).setTitleColor(-16777216).setSubmitColor(-7829368).setCancelColor(-7829368).setTitleBgColor(-1).setBgColor(-1).setLabel("", "", "", "\u65f6", "\u5206", "").isDialog(true).setLineSpacingMultiplier(2.0f).build();
        this.mDateDialog = pickerView.getDialog();
        if (this.mDateDialog != null) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
            params.leftMargin = 0;
            params.rightMargin = 0;
            pickerView.getDialogContainerLayout().setLayoutParams((ViewGroup.LayoutParams)params);
            Window dialogWindow = this.mDateDialog.getWindow();
            if (dialogWindow != null) {
                dialogWindow.setWindowAnimations(R.style.picker_view_slide_anim);
                dialogWindow.setGravity(80);
            }
        }
    }

    private void dispatchEvent() {
        this.vSubscribeTimeView.setListener(new SubscribeTimeView.OnDateClickListener(){

            public void onClickDate(String s) {
                SubscribeTimeFragment.this.date = s;
                SubscribeTimeFragment.this.mSubscribeTimePresenter.getSubscribeTime(SubscribeTimeFragment.this.date, SubscribeTimeFragment.this.expertId);
            }

            public void onClickTime(String consultationTime) {
                SubscribeTimeFragment.this.time = consultationTime;
            }
        });
        this.vSubscribeTimeViewV2.setListener(new SubscribeTimeCandlerView.OnTimeClickListener(){

            public void onClick(int year, int month, int day) {
                SubscribeTimeFragment.this.date = year + "-" + month + "-" + day;
                if (day == new LocalDateTime().getDayOfMonth()) {
                    SubscribeTimeFragment.this.isToday = true;
                } else {
                    SubscribeTimeFragment.this.isToday = false;
                }
                SubscribeTimeFragment.this.mDateDialog.show();
            }
        });
        this.vCommitSubscribe.setOnClickListener(v -> {
            if (StringUtils.isEmpty((CharSequence)this.date)) {
                ToastUtils.showShort((CharSequence)"\u8bf7\u9009\u62e9\u65e5\u671f");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)this.time)) {
                ToastUtils.showShort((CharSequence)"\u8bf7\u9009\u62e9\u5177\u4f53\u65f6\u95f4");
                return;
            }
            this.mSubscribeTimePresenter.commitSubscribeTime(this.mOrderId, this.date, this.time);
        });
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_subscribe_time;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.getActivity().finish();
    }

    @Override
    public void bindDate(List<String> listResponseBody) {
        this.vSubscribeTimeView.bindDate(listResponseBody);
        this.date = listResponseBody.get(0);
    }

    @Override
    public void bindTime(List<SubscribeTimeEntity> result) {
        this.vSubscribeTimeView.bindTime(result);
    }

    @Override
    public void subscribeSuccess() {
        ToastUtils.showShort((CharSequence)"\u9884\u7ea6\u6210\u529f");
        EventBus.getDefault().post((Object)new ByhCommEvent.ShowMainBarEvent());
        this.getActivity().finish();
    }
}

