/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.content.Context;
import android.os.Handler;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.PersonInfoBody;
import com.kangxin.common.byh.entity.SelZhicEntity;
import com.kangxin.common.byh.entity.VertifyIDCardEntity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.byh.entity.v2.HospitalEntityV2;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.present.IUserPresent;
import com.kangxin.common.byh.present.IVerifyPresenter;
import com.kangxin.common.byh.present.VerifyPresenter;
import com.kangxin.common.byh.present.impl.UserPresent;
import com.kangxin.common.byh.util.StringUtil;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IPersonInfoView;
import com.kangxin.common.byh.view.IPersonalInfoVerifyView;
import com.kangxin.common.byh.view.IVerNameByIdcardView;
import com.kangxin.common.byh.widget.UpPicBottomDialog;
import com.kangxin.common.util.FileUtils;
import com.kangxin.common.util.VerifyUtil;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.presenter.impl.UpdatingQualificationPresenter;
import com.kangxin.doctor.worktable.view.IUpDatingQualificationView;
import java.io.File;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;
import top.zibin.luban.Luban;
import top.zibin.luban.OnCompressListener;

public class UpdatingQualificationsFragment
extends BaseFragment
implements IToolView,
IUpDatingQualificationView,
IPersonalInfoVerifyView,
IPersonInfoView,
IVerNameByIdcardView {
    private static final String TAG = "UpdatingQualificationsF";
    private ImageView mUploadCardId1View;
    private ImageView mUploadCardId2View;
    private ImageView mUploadCertifyView;
    private RelativeLayout mHospitalRl;
    private TextView mHospitalTv;
    private RelativeLayout mDepartmentRl;
    private TextView mDepartmentTv;
    private RelativeLayout mTitlesRl;
    private TextView mTitlesTv;
    private UpdatingQualificationPresenter mUpdatingQualificationPresenter;
    private ByhCommEvent.UploadImg mUpImageEvent;
    private EditText mIdCardNumEdt;
    private EditText mUserNameEdtView;
    private long mHospitalId = -1L;
    private String mHospitalName = "";
    private PersonInfoBody mPersonInfoBody;
    private IUserPresent mUserPresent;
    private IVerifyPresenter mVertifyPresent;
    private String mDefaultUserName = null;
    private String mIdcardNum;
    private String mUserName;
    private String mIdcardFront;
    private String mIdcardBack;
    private String mBadgeUrl;
    private SelZhicEntity mSelZhicEntity;
    private HospitalEntityV2 mHospitalEntity;
    private String mAreaCode;
    private ByhCommEvent.HosDeptDataEvent mHosDeptData;

    private String getDisplayName() {
        String currName = this.mUserNameEdtView.getText().toString().trim();
        if (this.mDefaultUserName != null && this.mDefaultUserName.equals(currName)) {
            ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getContext()).getUserInfo();
            if (userInfoVOBean != null) {
                return userInfoVOBean.getName();
            }
            return null;
        }
        return currName;
    }

    public void init() {
        this.vToolTitleTextView.setText((CharSequence)"\u66f4\u65b0\u8d44\u8d28");
        this.mUserPresent = new UserPresent((IPersonInfoView)this);
        this.mVertifyPresent = new VerifyPresenter((IVerNameByIdcardView)this);
        this.mUpdatingQualificationPresenter = new UpdatingQualificationPresenter(this);
        this.mUploadCardId1View = (ImageView)this.findViewById(this.rootView, R.id.add_cardid1);
        this.mUploadCardId2View = (ImageView)this.findViewById(this.rootView, R.id.add_cardid2);
        this.mUploadCertifyView = (ImageView)this.findViewById(this.rootView, R.id.add_certify);
        this.mUserNameEdtView = (EditText)this.findViewById(this.rootView, R.id.real_name_edt);
        this.mHospitalRl = (RelativeLayout)this.findViewById(this.rootView, R.id.update_hospital_rl);
        this.mHospitalTv = (TextView)this.findViewById(this.rootView, R.id.update_hospital_value_tv);
        this.mDepartmentRl = (RelativeLayout)this.findViewById(this.rootView, R.id.update_department_rl);
        this.mDepartmentTv = (TextView)this.findViewById(this.rootView, R.id.update_department_value_tv);
        this.mTitlesRl = (RelativeLayout)this.findViewById(this.rootView, R.id.titles_rl);
        this.mTitlesTv = (TextView)this.findViewById(this.rootView, R.id.titles_value_tv);
        this.mHospitalRl.setOnClickListener((View.OnClickListener)new ExecutiveTitleOnClickListener());
        this.mDepartmentRl.setOnClickListener((View.OnClickListener)new ExecutiveTitleOnClickListener());
        this.mTitlesRl.setOnClickListener((View.OnClickListener)new ExecutiveTitleOnClickListener());
        this.mIdCardNumEdt = (EditText)this.findViewById(this.rootView, R.id.id_card_num_edt);
        this.mIdCardNumEdt.setGravity(16);
        this.mIdCardNumEdt.setGravity(8388629);
        this.mIdCardNumEdt.setTextDirection(3);
        this.mIdCardNumEdt.setSelection(this.mIdCardNumEdt.getText().toString().trim().length());
        this.addOnClickListener();
        this.bindUserInfoToViews();
    }

    private void bindUserInfoToViews() {
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getContext()).getUserInfo();
        if (userInfoVOBean == null) {
            return;
        }
        this.mIdcardFront = userInfoVOBean.getCredFront();
        this.mIdcardBack = userInfoVOBean.getCredBack();
        this.mBadgeUrl = userInfoVOBean.getBadgeUrl();
        this.showUploadImg(this.mIdcardFront, this.mUploadCardId1View);
        this.showUploadImg(this.mIdcardBack, this.mUploadCardId2View);
        this.showUploadImg(this.mBadgeUrl, this.mUploadCertifyView);
        this.mHospitalName = userInfoVOBean.getHospitalName();
        this.mHospitalTv.setText((CharSequence)this.mHospitalName);
        this.mHospitalTv.setTextColor(this.getResources().getColor(R.color.color_333333));
        this.mDepartmentTv.setText((CharSequence)userInfoVOBean.getHospitalDeptName());
        this.mDepartmentTv.setTextColor(this.getResources().getColor(R.color.color_333333));
        this.mTitlesTv.setText((CharSequence)userInfoVOBean.getProfession());
        this.mTitlesTv.setTextColor(this.getResources().getColor(R.color.color_333333));
        this.mIdcardNum = userInfoVOBean.getCredNo();
        this.mIdCardNumEdt.setText((CharSequence)this.mIdcardNum);
        String name = userInfoVOBean.getName();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            String defaultName = StringUtil.subNameToStarName((String)name);
            this.mUserNameEdtView.setText((CharSequence)defaultName);
            this.mDefaultUserName = defaultName;
        } else {
            this.mUserNameEdtView.setHint((CharSequence)"***");
        }
        String hosId = userInfoVOBean.getHospitalId();
        if (!TextUtils.isEmpty((CharSequence)hosId)) {
            this.mHospitalId = Long.parseLong(hosId);
        }
        this.mAreaCode = userInfoVOBean.getAreaCode();
        if (this.mHospitalEntity == null) {
            this.mHospitalEntity = new HospitalEntityV2();
        }
        this.mHospitalEntity.setHospitalId(this.mHospitalId + "");
        this.mHospitalEntity.setHospitalName(userInfoVOBean.getHospitalName());
        this.mHospitalEntity.setOrganCode(userInfoVOBean.getHospitalCode() + "");
        String appCode = VertifyDataUtil.getInstance((Context)this.getContext()).getOpenCode();
        this.mHospitalEntity.setAppCode(appCode);
        if (this.mHosDeptData == null) {
            this.mHosDeptData = new ByhCommEvent.HosDeptDataEvent();
        }
        this.mHosDeptData.setStdDeptId(userInfoVOBean.getHospitalDeptId() + "");
        this.mHosDeptData.setHosDeptCode(userInfoVOBean.getHospitalDeptId() + "");
        this.mHosDeptData.setHosDeptName(userInfoVOBean.getHospitalDeptName());
        this.mHosDeptData.setStdFirstDeptCode(userInfoVOBean.getStdFirstDeptId() + "");
        this.mHosDeptData.setStdFirstDeptName(userInfoVOBean.getStdFirstDeptName());
        this.mHosDeptData.setStdSecondDeptCode(userInfoVOBean.getStdSecondDeptId() + "");
        this.mHosDeptData.setStdSecondDeptName(userInfoVOBean.getStdSecondDeptName());
        if (this.mSelZhicEntity == null) {
            this.mSelZhicEntity = new SelZhicEntity();
        }
        this.mSelZhicEntity.setDicCode(userInfoVOBean.getProfessionCode());
        this.mSelZhicEntity.setDicName(userInfoVOBean.getProfession());
    }

    private void addOnClickListener() {
        this.mIdCardNumEdt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable editable) {
                if (TextUtils.isEmpty((CharSequence)editable.toString())) {
                    UpdatingQualificationsFragment.this.mIdCardNumEdt.setGravity(8388627);
                    UpdatingQualificationsFragment.this.mIdCardNumEdt.setTextDirection(4);
                    UpdatingQualificationsFragment.this.mIdCardNumEdt.setSelection(UpdatingQualificationsFragment.this.mIdCardNumEdt.getText().toString().trim().length());
                } else {
                    UpdatingQualificationsFragment.this.mIdCardNumEdt.setGravity(8388629);
                    UpdatingQualificationsFragment.this.mIdCardNumEdt.setTextDirection(3);
                    UpdatingQualificationsFragment.this.mIdCardNumEdt.setSelection(UpdatingQualificationsFragment.this.mIdCardNumEdt.getText().toString().trim().length());
                }
            }
        });
        this.registerClickUploadImgDialog(R.id.add_cardid1);
        this.registerClickUploadImgDialog(R.id.add_cardid2);
        this.registerClickUploadImgDialog(R.id.add_certify);
        this.findViewById(this.rootView, R.id.updating_qualifications_tv).setOnClickListener(view -> {
            this.mPersonInfoBody = new PersonInfoBody();
            this.mIdcardNum = this.mIdCardNumEdt.getText().toString().trim();
            boolean idcardIsNull = TextUtils.isEmpty((CharSequence)this.mIdcardNum);
            if (idcardIsNull && TextUtils.isEmpty((CharSequence)this.mBadgeUrl)) {
                ToastUtils.showLong((CharSequence)"\u8bf7\u4e0a\u4f20\u6267\u4e1a\u8bc1\u4e66\u6216\u8005\u586b\u5199\u8eab\u4efd\u8bc1\u53f7");
                return;
            }
            if (this.mHospitalId == -1L) {
                this.showShortToast("\u8bf7\u9009\u62e9\u533b\u9662");
                return;
            }
            if (this.mHospitalEntity == null) {
                this.showShortToast("\u8bf7\u9009\u62e9\u533b\u9662");
                return;
            }
            if (this.mHosDeptData == null) {
                this.showShortToast("\u8bf7\u9009\u62e9\u79d1\u5ba4");
                return;
            }
            if (this.mSelZhicEntity == null) {
                this.showShortToast("\u8bf7\u9009\u62e9\u804c\u79f0");
                return;
            }
            this.mUserName = this.getDisplayName();
            if (!idcardIsNull) {
                this.mIdcardNum = VerifyUtil.changeIdcard((String)this.mIdcardNum);
                if (!TextUtils.isEmpty((CharSequence)this.mUserName)) {
                    this.mVertifyPresent.verNameByIdcard(this.getContext(), this.mUserName, this.mIdcardNum);
                } else {
                    ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getContext()).getUserInfo();
                    if (userInfoVOBean != null) {
                        String userName = userInfoVOBean.getName();
                        if (!TextUtils.isEmpty((CharSequence)userName)) {
                            this.mVertifyPresent.verNameByIdcard(this.getContext(), userName, this.mIdcardNum);
                        } else {
                            ToastUtils.showLong((CharSequence)"\u8bf7\u586b\u5199\u533b\u751f\u59d3\u540d");
                        }
                    }
                }
            } else {
                this.reqUpdatePersonInfo();
            }
        });
    }

    private void reqUpdatePersonInfo() {
        PersonInfoBody personInfoBody = new PersonInfoBody();
        LoginSuccess loginSuccess = VertifyDataUtil.getInstance((Context)this.getContext()).getLoginData();
        if (!TextUtils.isEmpty((CharSequence)this.mUserName)) {
            personInfoBody.setDisplayName(this.mUserName);
        }
        personInfoBody.setPhone(loginSuccess.getMobileNumber());
        personInfoBody.setAccountNo(loginSuccess.getMobileNumber());
        personInfoBody.setAreaCode(this.mAreaCode);
        personInfoBody.setChannelCode("DOCTOR_ANDROID");
        personInfoBody.setAppCode(this.mHospitalEntity.getAppCode());
        personInfoBody.setHospitalId(this.mHospitalEntity.getHospitalId());
        personInfoBody.setHospitalCode(this.mHospitalEntity.getOrganCode());
        personInfoBody.setHospitalDeptCode(this.mHosDeptData.getStdDeptId());
        personInfoBody.setHospitalDeptName(this.mHosDeptData.getHosDeptName());
        if (!TextUtils.isEmpty((CharSequence)this.mIdcardNum)) {
            if (!VerifyUtil.isIdNo((String)this.mIdcardNum)) {
                this.showShortToast("\u8eab\u4efd\u8bc1\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
                return;
            }
            personInfoBody.setIdCardNo(this.mIdcardNum);
            personInfoBody.setCredTypeCode("01");
        }
        personInfoBody.setBadgeUrl(this.mBadgeUrl);
        personInfoBody.setIdCardBack(this.mBadgeUrl);
        personInfoBody.setIdCardFront(this.mIdcardFront);
        personInfoBody.setProfession(this.mSelZhicEntity.getDicName());
        personInfoBody.setProfessionCode(this.mSelZhicEntity.getDicCode());
        personInfoBody.setRegHospitalName(this.mHospitalEntity.getHospitalName());
        String firstDeptCode = this.mHosDeptData.getStdFirstDeptCode();
        String secondDeptCode = this.mHosDeptData.getStdSecondDeptCode();
        if (TextUtils.isEmpty((CharSequence)firstDeptCode)) {
            ToastUtils.showLong((CharSequence)"firstDeptCode is null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)secondDeptCode)) {
            ToastUtils.showLong((CharSequence)"secondDeptCode is null");
            return;
        }
        personInfoBody.setStdFristDeptCode(this.fillFloatToInt(firstDeptCode));
        personInfoBody.setStdSecondDeptCode(this.fillFloatToInt(secondDeptCode));
        personInfoBody.setStdFristDeptName(this.mHosDeptData.getStdFirstDeptName());
        personInfoBody.setStdSecondDeptName(this.mHosDeptData.getStdSecondDeptName());
        this.mUserPresent.updatePersonInfo(personInfoBody);
    }

    private String fillFloatToInt(String value) {
        String result = "";
        if (TextUtils.isEmpty((CharSequence)value)) {
            return result;
        }
        if (!value.contains(".0")) {
            return value;
        }
        result = value.split("\\.0")[0];
        return result;
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_updating_qualifications;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        UpdatingQualificationsFragment.HideKeyboard(this.rootView);
        this.pop();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void setImgByQualificationsPath(ByhCommEvent.UploadImg uploadImgEvent) {
        this.mUpImageEvent = uploadImgEvent;
        String path = (String)uploadImgEvent.getPhotoInfoList().get(0);
        if (this.getContext() == null) {
            return;
        }
        Luban.with((Context)this.getContext()).load(path).ignoreBy(20).setCompressListener(new OnCompressListener(){

            public void onStart() {
                Log.i((String)UpdatingQualificationsFragment.TAG, (String)"==onStart====");
            }

            public void onSuccess(File file) {
                String filePath = file.getAbsolutePath();
                String fileSize = FileUtils.getAutoFileOrFilesSize((String)filePath);
                Log.i((String)UpdatingQualificationsFragment.TAG, (String)("==onSuccess====fileSize==" + fileSize));
                UpdatingQualificationsFragment.this.mUpdatingQualificationPresenter.upDatingQualification(filePath);
            }

            public void onError(Throwable e) {
                Log.i((String)UpdatingQualificationsFragment.TAG, (String)("==onError==" + e.toString()));
            }
        }).launch();
    }

    private void showUploadImg(String path, ImageView imageView) {
        Log.i((String)TAG, (String)("==showUploadImg==>" + path));
        Pretty.create().loadImage(path).err(this.getResources().getDrawable(R.drawable.ic_byhim_add)).placeholder(this.getResources().getDrawable(R.drawable.ic_byhim_add)).diskCacheStrategy(DiskCacheStrategy.NONE).into(imageView);
    }

    private void registerClickUploadImgDialog(int viewId) {
        this.findViewById(this.rootView, viewId).setOnClickListener(view -> new UpPicBottomDialog((Context)this.getActivity(), viewId).show());
    }

    @Override
    public void showQualificationInfo(ResponseBody<UpImgEntity> upImgEntityResponseBody) {
        Log.i((String)TAG, (String)("upImgEntityResponseBody==>" + upImgEntityResponseBody.getResult()));
        String imgUrl = ((UpImgEntity)upImgEntityResponseBody.getResult()).getUrl();
        if (this.mUpImageEvent.getViewId() == R.id.add_cardid1) {
            this.mIdcardFront = imgUrl;
            this.showUploadImg(this.mIdcardFront, this.mUploadCardId1View);
        } else if (this.mUpImageEvent.getViewId() == R.id.add_cardid2) {
            this.mIdcardBack = imgUrl;
            this.showUploadImg(this.mIdcardBack, this.mUploadCardId2View);
        } else if (this.mUpImageEvent.getViewId() == R.id.add_certify) {
            this.mBadgeUrl = imgUrl;
            this.showUploadImg(this.mBadgeUrl, this.mUploadCertifyView);
        }
    }

    public void onError(String msg) {
        Log.i((String)TAG, (String)("==onError==>" + msg));
        this.showShortToast(msg);
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }

    public void showVerifyResult(ResponseBody responseBody) {
        if (responseBody == null) {
            return;
        }
        if (responseBody.getCode() == 200) {
            VertifyIDCardEntity idCardEntity = (VertifyIDCardEntity)responseBody.getResult();
            if (idCardEntity.getCode() == 0) {
                EventBus.getDefault().post((Object)new WorkTabEvent.UpdatingQualifications(this.mPersonInfoBody));
                this.pop();
            } else {
                this.showShortToast(idCardEntity.getMsg());
            }
        } else {
            this.showShortToast(responseBody.getMsg());
        }
    }

    public void showErr(String msg) {
    }

    public void showPersonInfo(LoginSuccess responseBody) {
        VertifyDataUtil.getInstance((Context)this.getContext()).setAccountStatus(responseBody.getAccountStatus());
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                EventBus.getDefault().post((Object)new WorkTabEvent.UpdatePersonInfo());
                UpdatingQualificationsFragment.this.pop();
            }
        }, 500L);
    }

    public void vertifySuccess(VertifyIDCardEntity vertifyIDCardEntity) {
        this.mUserName = vertifyIDCardEntity.getName();
        this.reqUpdatePersonInfo();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveExecutiveInfo(SelZhicEntity dictEntityListBean) {
        if (dictEntityListBean == null) {
            return;
        }
        this.mSelZhicEntity = dictEntityListBean;
        this.mTitlesTv.setText((CharSequence)dictEntityListBean.getDicName());
        this.mTitlesTv.setTextColor(this.getResources().getColor(R.color.color_333333));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveHospitalData(ByhCommEvent.HosEntityEvent hosEntityEvent) {
        HospitalEntityV2 hospitalEntityV2 = hosEntityEvent.getmHosEntity();
        this.mAreaCode = hospitalEntityV2.getDistrictCode();
        if (hospitalEntityV2 == null) {
            return;
        }
        this.mHospitalEntity = hospitalEntityV2;
        this.mHospitalId = Long.parseLong(hospitalEntityV2.getHospitalId());
        this.mHospitalName = hospitalEntityV2.getHospitalName();
        this.mHospitalTv.setText((CharSequence)this.mHospitalName);
        this.mHospitalTv.setTextColor(this.getResources().getColor(R.color.color_333333));
        this.mDepartmentTv.setText((CharSequence)"\u8bf7\u9009\u62e9");
        this.mDepartmentTv.setTextColor(this.getResources().getColor(R.color.color_999999));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveDepartmentData(ByhCommEvent.HosDeptDataEvent hosDeptDataEvent) {
        if (hosDeptDataEvent == null) {
            return;
        }
        this.mHosDeptData = hosDeptDataEvent;
        if (hosDeptDataEvent != null) {
            this.mDepartmentTv.setText((CharSequence)this.mHosDeptData.getStdDeptName());
            this.mDepartmentTv.setTextColor(this.getResources().getColor(R.color.color_333333));
        }
    }

    private class ExecutiveTitleOnClickListener
    implements View.OnClickListener {
        private ExecutiveTitleOnClickListener() {
        }

        public void onClick(View v) {
            if (v.getId() == R.id.update_hospital_rl) {
                ARouter.getInstance().build("/login/fragmePerInfoControActivity").withInt("MSG_JUMP_TYPE", 5382).navigation();
            } else if (v.getId() == R.id.update_department_rl) {
                if (UpdatingQualificationsFragment.this.mHospitalId == -1L) {
                    UpdatingQualificationsFragment.this.showShortToast("\u8bf7\u9009\u62e9\u533b\u9662");
                    return;
                }
                ARouter.getInstance().build("/login/fragmePerInfoControActivity").withInt("MSG_JUMP_TYPE", 5383).withLong("HOSPITAL_ID", UpdatingQualificationsFragment.this.mHospitalId).withString("HOS_APP_CODE", UpdatingQualificationsFragment.this.mHospitalEntity.getAppCode()).navigation();
            } else if (v.getId() == R.id.titles_rl) {
                ARouter.getInstance().build("/login/fragmePerInfoControActivity").withInt("MSG_JUMP_TYPE", 5384).navigation();
            }
        }
    }
}

