/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import butterknife.BindView;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.widget.BottomSelectDialog;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.presenter.IUploadpatientSignPresenter;
import com.kangxin.doctor.worktable.presenter.impl.UploadpatientSignPresenter;
import com.kangxin.doctor.worktable.view.IUploadPatientSignView;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UploadPatientSignFragment
extends BaseFragment
implements IToolView,
IUploadPatientSignView {
    private static final int REQUEST_IMAGE_SIGN = 1;
    @BindView(value=2131428296)
    TextView vUploadImage;
    @BindView(value=2131428105)
    TextView vCommit;
    @BindView(value=2131428275)
    ImageView vSignImage;
    private String mImagePath;
    private String mOrderId;
    private IUploadpatientSignPresenter mUploadpatientSignPresenter = new UploadpatientSignPresenter(this);

    public static UploadPatientSignFragment newInstance(String orderId, String mSignUrl) {
        UploadPatientSignFragment uploadPatientSignFragment = new UploadPatientSignFragment();
        if (mSignUrl == null) {
            mSignUrl = "";
        }
        uploadPatientSignFragment.mOrderId = orderId;
        uploadPatientSignFragment.mImagePath = mSignUrl;
        Bundle bundle = new Bundle();
        bundle.putString("orderId", orderId);
        bundle.putString("mImagePath", mSignUrl);
        uploadPatientSignFragment.setArguments(bundle);
        return uploadPatientSignFragment;
    }

    public void init() {
        this.mOrderId = this.getArguments().getString("orderId");
        this.mImagePath = this.getArguments().getString("mImagePath");
        this.vToolTitleTextView.setText((CharSequence)"\u4e0a\u4f20\u7b7e\u7f72\u7167\u7247");
        if (this.mImagePath != null && !this.mImagePath.equals("")) {
            Pretty.create().loadImage(this.mImagePath).into(this.vSignImage);
            this.vUploadImage.setText((CharSequence)"\u91cd\u65b0\u4e0a\u4f20\u7167\u7247");
        }
        this.dispatchEvent();
    }

    private void dispatchEvent() {
        this.vUploadImage.setOnClickListener(v -> this.requestEachPermission(new String[]{"android.permission.CAMERA"}).subscribe(permission2 -> {
            if (permission2.granted) {
                new BottomSelectDialog(this.mContext, 3).setImageSelectListener(new BottomSelectDialog.ImageSelectListener(){

                    public void onImageList(List<String> strings) {
                        UploadPatientSignFragment.this.mImagePath = strings.get(0);
                        Pretty.create().loadImage(UploadPatientSignFragment.this.mImagePath).into(UploadPatientSignFragment.this.vSignImage);
                        UploadPatientSignFragment.this.vUploadImage.setText((CharSequence)"\u91cd\u65b0\u4e0a\u4f20\u7167\u7247");
                        UploadPatientSignFragment.this.vCommit.setBackgroundColor(UploadPatientSignFragment.this.getResources().getColor(R.color.colorPrimary));
                    }
                }).show();
            } else {
                ToastUtils.showShort((CharSequence)("\u8bf7\u7ed9\u4e0e\u6743\u9650-" + permission2.name));
            }
        }));
        this.vCommit.setOnClickListener(v -> {
            if (StringUtils.isEmpty((CharSequence)this.mImagePath)) {
                ToastUtils.showShort((CharSequence)"\u8bf7\u9009\u62e9\u7167\u7247");
                return;
            }
            this.mUploadpatientSignPresenter.uploadPatientSignImage(this.mOrderId, this.mImagePath);
        });
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_patient_sign_upload;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }

    @Override
    public void success(String url) {
        Bundle bundle = new Bundle();
        bundle.putString("url", url);
        this.setFragmentResult(1, bundle);
        this.finishCurrentView();
    }
}

