/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable;

import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import butterknife.BindView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.byh.widget.BottomSelectDialog;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.presenter.IUploadReportWritePresenter;
import com.kangxin.doctor.worktable.presenter.clc.ClcUpReportWritePresent;
import com.kangxin.doctor.worktable.presenter.impl.UploadReportWritePresenter;
import com.kangxin.doctor.worktable.view.IUploadReportWriteView;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

public class UploadReportWriteFragment
extends BaseFragment
implements IToolView,
IUploadReportWriteView {
    @BindView(value=2131428296)
    TextView vUploadImage;
    @BindView(value=2131428105)
    TextView vCommit;
    @BindView(value=2131428275)
    ImageView vSignImage;
    private String mSignUrl;
    private String mOrderUuid;
    private int mOrderType;
    private IUploadReportWritePresenter mPresenter;

    public static UploadReportWriteFragment newInstance(String mOrderUuid, int orderType) {
        UploadReportWriteFragment uploadReportWriteFragment = new UploadReportWriteFragment();
        Bundle bundle = new Bundle();
        bundle.putString("orderUuid", mOrderUuid);
        bundle.putInt("orderType", orderType);
        uploadReportWriteFragment.setArguments(bundle);
        return uploadReportWriteFragment;
    }

    public void init() {
        IUpdateVerStatus updateVerStatus = (IUpdateVerStatus)ARouter.getInstance().build("/service_update/SERVICE_UPDATE_VER_STATUS").navigation();
        int consuStatus = updateVerStatus.getConsuStatus(this.getMContext());
        if (consuStatus == 4626) {
            this.mPresenter = new UploadReportWritePresenter(this);
        } else if (consuStatus == 4627) {
            this.mPresenter = new ClcUpReportWritePresent(this);
        }
        this.vToolTitleTextView.setText((CharSequence)"\u624b\u5199\u62a5\u544a");
        this.mOrderUuid = this.getArguments().getString("orderUuid");
        this.mOrderType = this.getArguments().getInt("orderType");
        this.dispatchEvent();
    }

    private void dispatchEvent() {
        this.vCommit.setOnClickListener(v -> {
            if (!StringUtils.isEmpty((CharSequence)this.mSignUrl)) {
                this.mPresenter.uploadExpertReport(this.mOrderUuid, this.mSignUrl, this.mOrderType);
            }
        });
        this.vUploadImage.setOnClickListener(v -> this.openDialog());
    }

    private void openDialog() {
        BottomSelectDialog bottomSelectDialog = new BottomSelectDialog(this.mContext, 3);
        bottomSelectDialog.setImageSelectListener(strings -> {
            this.mSignUrl = (String)strings.get(0);
            Pretty.create().loadImage(this.mSignUrl).into(this.vSignImage);
        });
        bottomSelectDialog.show();
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_consulation_report_write;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this._mActivity.finish();
    }

    @Override
    public void success() {
        ToastUtils.showShort((CharSequence)"\u4e0a\u4f20\u6210\u529f");
        EventBus.getDefault().post((Object)new ByhCommEvent.FlushList());
        this.finishCurrentView();
    }
}

