/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.activity;

import android.content.Intent;
import android.os.Build;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.service.IConsChatReceProvider;
import com.kangxin.doctor.worktable.OrderApplySignFragment;
import com.kangxin.doctor.worktable.OrderApplySuccessFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.fragment.v2.VerNameFragment;
import java.io.Serializable;
import me.yokeyword.fragmentation.ISupportFragment;

@Route(path="/framcontrwk/FrameNotitleActivity")
public class FrameNotitleActivity
extends BaseActivity {
    private IConsChatReceProvider mConsuChatReceiverProvider = (IConsChatReceProvider)ARouter.getInstance().build("/consuchat/receiver/ConsuChatReceiverProvider").navigation();

    public void start() {
        int jumpType = this.getIntent().getIntExtra("MSG_JUMP_TYPE", -1);
        this.mConsuChatReceiverProvider.registerConsuChatReceiver();
        switch (jumpType) {
            case 86400: {
                OrderDetailEntity orderDetailEntity = (OrderDetailEntity)this.getIntent().getSerializableExtra("ORDER_DETAILS_KEY");
                this.jumpByStatus(orderDetailEntity);
                break;
            }
            case 86403: {
                this.loadRootFragment(R.id.frame_content, (ISupportFragment)VerNameFragment.getInstance());
            }
        }
    }

    private void jumpByStatus(OrderDetailEntity orderDetailEntity) {
        if (orderDetailEntity == null) {
            return;
        }
        int status = orderDetailEntity.getOrderStatus();
        switch (status) {
            case 8: 
            case 10: 
            case 50: {
                OrderApplySuccessFragment orderApplySuccessFragment = OrderApplySuccessFragment.newInstance(orderDetailEntity.getOrderViewId(), orderDetailEntity.getOrderApplicationChannels(), true);
                this.loadRootFragment(R.id.frame_content, (ISupportFragment)orderApplySuccessFragment);
                break;
            }
            case 5: {
                OrderApplySignFragment orderApplySignFragment = OrderApplySignFragment.newInstance(orderDetailEntity.getOrderId(), orderDetailEntity.getOrderViewId(), orderDetailEntity.getDocHosName(), orderDetailEntity.getOrderApplicationChannels(), true);
                this.loadRootFragment(R.id.frame_content, (ISupportFragment)orderApplySignFragment);
                break;
            }
            case 40: {
                if (Build.VERSION.SDK_INT >= 26) {
                    this.mConsuChatReceiverProvider.sendConsuChatReceiver((Serializable)orderDetailEntity);
                } else {
                    Intent intent = new Intent("com.kangxin.doctor.worktable.orderlist.consulation.chat");
                    intent.putExtra("ORDER_DETAIL_ENTITY", (Serializable)orderDetailEntity);
                    this.sendBroadcast(intent);
                }
                this.finish();
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mConsuChatReceiverProvider.unRegisterConsuChatReceiver();
    }

    public int getContentLayoutId() {
        return R.layout.frame_layout;
    }
}

