/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.activity;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.SchoolEntity;
import com.kangxin.doctor.worktable.presenter.impl.SchoolSearchPresent;
import com.kangxin.doctor.worktable.view.SchoolDatasView;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;

@Route(path="/minecenter/SearchSchoolActivity")
public class SearchSchoolActivity
extends BaseActivity
implements IToolView,
SchoolDatasView {
    private SchoolSearchPresent mSchoolSearchPresent;
    @BindView(value=2131427912)
    EditText mSearchEdit;
    @BindView(value=2131427916)
    RecyclerView mSchoolListCycle;
    private String mFriendName = "";

    public void start() {
        this.mSchoolListCycle.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getBaseContext()));
        this.mSchoolSearchPresent = new SchoolSearchPresent(this);
        this.mSchoolSearchPresent.reqGetSchool(this.mFriendName, true);
        this.vToolTitleTextView.setText((CharSequence)"\u5b66\u6821\u540d\u79f0");
        this.vToolRightTextView.setVisibility(0);
        this.vToolRightTextView.setTextColor(-1);
        this.vToolRightTextView.setText((CharSequence)"\u5b8c\u6210");
        this.vToolRightTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String schoolName = SearchSchoolActivity.this.mSearchEdit.getText().toString().trim();
                if (TextUtils.isEmpty((CharSequence)schoolName)) {
                    SearchSchoolActivity.this.showShortToast("\u8bf7\u9009\u62e9\u5b66\u6821");
                    return;
                }
                EventBus.getDefault().post((Object)new ByhCommEvent.SchoolDataEvent(schoolName));
                SearchSchoolActivity.this.finish();
            }
        });
        this.mSearchEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                SearchSchoolActivity.this.mFriendName = s.toString();
                SearchSchoolActivity.this.mSchoolSearchPresent.reqGetSchool(SearchSchoolActivity.this.mFriendName, false);
            }
        });
    }

    public int getContentLayoutId() {
        return R.layout.worktab_search_school_activity;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.finish();
        SearchSchoolActivity.HideKeyboard(this.rootView);
    }

    @Override
    public void bindSchoolDatas(List<SchoolEntity> schoolEntities) {
        BaseQuickAdapter<SchoolEntity, BaseViewHolder> baseQuickAdapter = new BaseQuickAdapter<SchoolEntity, BaseViewHolder>(R.layout.worktab_simple_list_item, schoolEntities){

            protected void convert(BaseViewHolder helper, SchoolEntity item) {
                helper.setText(R.id.school_name, (CharSequence)item.getSchoolName());
            }
        };
        baseQuickAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                SchoolEntity schoolEntity = (SchoolEntity)adapter.getItem(position);
                SearchSchoolActivity.this.mSearchEdit.setText((CharSequence)schoolEntity.getSchoolName());
            }
        });
        this.mSchoolListCycle.setAdapter((RecyclerView.Adapter)baseQuickAdapter);
    }

    public void onError(String msg) {
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }
}

