/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.blankj.utilcode.util.TimeUtils;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.AccountBillinfoDataEntity;
import com.kangxin.doctor.worktable.util.ServCodeEnum;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class AccountBillinfoAdapter
extends BaseQuickAdapter<AccountBillinfoDataEntity.ContentBean, AccountBillinfoListHolder> {
    private Context mContext;

    public AccountBillinfoAdapter(@Nullable List data, Context context) {
        super(R.layout.by_item_account_billinfo_list, data);
        this.mContext = context;
    }

    protected void convert(AccountBillinfoListHolder helper, AccountBillinfoDataEntity.ContentBean item) {
        int type;
        String name = ServCodeEnum.getServName(item.getServCode());
        if (!TextUtils.isEmpty((CharSequence)name)) {
            helper.vAccountSourceTv.setText((CharSequence)name);
        } else {
            helper.vAccountSourceTv.setText((CharSequence)"\u5176\u4ed6\u7c7b\u578b");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date = TimeUtils.string2Date((String)item.getXCreateTime(), (DateFormat)simpleDateFormat);
        String time = TimeUtils.date2String((Date)date);
        if (!TextUtils.isEmpty((CharSequence)time)) {
            helper.vAccountCreateTime.setText((CharSequence)time);
        }
        if ((type = item.getBillType()) == 1) {
            helper.vAccountAcrualMoney.setTextColor(this.mContext.getResources().getColor(R.color.color_3576E0));
            helper.vAccountAcrualMoney.setText((CharSequence)("+ " + item.getBillMoney() + "\u5143"));
        } else {
            helper.vAccountAcrualMoney.setTextColor(this.mContext.getResources().getColor(R.color.color_FFA826));
            helper.vAccountAcrualMoney.setText((CharSequence)("- " + item.getBillMoney() + "\u5143"));
        }
    }

    public class AccountBillinfoListHolder
    extends BaseViewHolder {
        TextView vAccountSourceTv;
        TextView vAccountCreateTime;
        TextView vAccountAcrualMoney;

        public AccountBillinfoListHolder(View view) {
            super(view);
            this.vAccountSourceTv = (TextView)view.findViewById(R.id.source_tv);
            this.vAccountCreateTime = (TextView)view.findViewById(R.id.create_time_tv);
            this.vAccountAcrualMoney = (TextView)view.findViewById(R.id.actual_money_tv);
        }
    }
}

