/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.adapter;

import cn.finalteam.toolsfinal.StringUtils;
import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.DoctorConsultationAllOrderEntity;
import com.kangxin.doctor.worktable.util.TimeUtil;
import java.util.List;

public class ConsulationDoctorOrderListAdapter
extends BaseMultiItemQuickAdapter<DoctorConsultationAllOrderEntity, BaseViewHolder> {
    private OnClickItemListener listener;

    public void setListener(OnClickItemListener listener) {
        this.listener = listener;
    }

    public ConsulationDoctorOrderListAdapter(List<DoctorConsultationAllOrderEntity> data) {
        super(data);
        this.addItemType(6, R.layout.by_item_order_list_new_apply);
        this.addItemType(55, R.layout.by_item_order_list_wait_resolution);
        this.addItemType(5, R.layout.by_item_order_list_wait_resolution);
        this.addItemType(8, R.layout.by_item_order_list_wait_resolution);
        this.addItemType(10, R.layout.by_item_order_list_wait_resolution);
        this.addItemType(20, R.layout.by_item_order_list_wait_resolution);
        this.addItemType(30, R.layout.by_item_order_list_running);
        this.addItemType(40, R.layout.by_item_order_list_complete);
        this.addItemType(50, R.layout.worktab_by_item_order_list_cancel);
    }

    protected void convert(BaseViewHolder helper, DoctorConsultationAllOrderEntity item) {
        switch (item.getOrderStatus()) {
            case 6: {
                this.newApply(helper, item);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 20: 
            case 55: {
                this.waitResolution(helper, item);
                break;
            }
            case 30: {
                this.running(helper, item);
                break;
            }
            case 40: {
                this.completeOrder(helper, item);
                break;
            }
            case 50: {
                this.cancel(helper, item);
            }
        }
    }

    private void waitResolution(BaseViewHolder holder, DoctorConsultationAllOrderEntity item) {
        switch (item.getOrderStatus()) {
            case 55: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u5f85\u5904\u7406");
                break;
            }
            case 5: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u5f85\u60a3\u8005\u7b7e\u7f72");
                break;
            }
            case 8: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u5f85\u5206\u914d");
                break;
            }
            case 10: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u672a\u652f\u4ed8");
                break;
            }
            case 20: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u5f85\u63a5\u8bca");
                break;
            }
            default: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u672a\u77e5\u72b6\u6001");
            }
        }
        holder.setText(R.id.vTime, (CharSequence)TimeUtil.getChatTime(false, TimeUtil.stringToLong(item.getOrderCreateTimeStr(), "yyyy-MM-dd HH:mm"))).setText(R.id.vPatientInfo, (CharSequence)(item.getPatientName() + "\uff0c" + item.getPatientAge() + "\uff0c" + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vOrderType, (CharSequence)(item.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587")).setText(R.id.vExpertInfo, (CharSequence)("" + item.getExpertHosName() + " " + item.getExpertName()));
        holder.itemView.setOnClickListener(v -> this.listener.onClick(item));
    }

    private void completeOrder(BaseViewHolder holder, DoctorConsultationAllOrderEntity item) {
        holder.setText(R.id.vTime, (CharSequence)TimeUtil.getChatTime(false, TimeUtil.stringToLong(item.getOrderUpdateTimeStr(), "yyyy-MM-dd HH:mm"))).setText(R.id.vPatientInfo, (CharSequence)(item.getPatientName() + "\uff0c" + item.getPatientAge() + "\uff0c" + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vOrderType, (CharSequence)(item.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587")).setText(R.id.vExpertInfo, (CharSequence)("" + item.getExpertHosName() + " " + item.getExpertName())).setText(R.id.vStartTime, (CharSequence)(item.getOrderBeginTime() + "")).setText(R.id.vEndTime, (CharSequence)(item.getOrderFinishTime() + "")).setText(R.id.vOrderStatus, (CharSequence)"\u5df2\u5b8c\u6210");
        holder.itemView.setOnClickListener(v -> this.listener.onClick(item));
    }

    private void running(BaseViewHolder holder, DoctorConsultationAllOrderEntity item) {
        holder.setText(R.id.vTime, (CharSequence)TimeUtil.getChatTime(false, TimeUtil.stringToLong(item.getOrderUpdateTimeStr(), "yyyy-MM-dd HH:mm"))).setText(R.id.vPatientInfo, (CharSequence)(item.getPatientName() + "\uff0c" + item.getPatientAge() + "\uff0c" + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vOrderType, (CharSequence)(item.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587")).setText(R.id.vExpertInfo, (CharSequence)("" + item.getExpertHosName() + " " + item.getExpertName())).setText(R.id.vOrderStatus, (CharSequence)"\u8fdb\u884c\u4e2d");
        if (!StringUtils.isBlank((String)item.getOrderBeginTime())) {
            holder.setText(R.id.vStartTime, (CharSequence)(item.getOrderBeginTime() + ""));
        } else {
            holder.setText(R.id.vStartTime, (CharSequence)(item.getConsultationDate() + item.getConsultationTime() + ""));
        }
        holder.itemView.setOnClickListener(v -> this.listener.onClick(item));
    }

    private void newApply(BaseViewHolder baseViewHolder, DoctorConsultationAllOrderEntity item) {
        baseViewHolder.setText(R.id.vTime, (CharSequence)TimeUtil.getChatTime(false, TimeUtil.stringToLong(item.getOrderUpdateTimeStr(), "yyyy-MM-dd HH:mm"))).setText(R.id.vPatientName, (CharSequence)("@" + item.getPatientName())).setText(R.id.vPatientSexAge, (CharSequence)("\uff0c" + item.getPatientAge() + "\uff0c" + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vPatientCase, (CharSequence)("\u4e3b\u8bc9\uff1a" + item.getPatCaseMainSuit() + ""));
        baseViewHolder.itemView.setOnClickListener(v -> this.listener.onClick(item));
    }

    private void cancel(BaseViewHolder holder, DoctorConsultationAllOrderEntity item) {
        holder.setText(R.id.vTime, (CharSequence)TimeUtil.getChatTime(false, TimeUtil.stringToLong(item.getOrderUpdateTimeStr(), "yyyy-MM-dd HH:mm"))).setText(R.id.vPatientInfo, (CharSequence)(item.getPatientName() + "\uff0c" + item.getPatientAge() + "\uff0c" + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vOrderType, (CharSequence)(item.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587")).setText(R.id.vExpertInfo, (CharSequence)("" + item.getExpertHosName() + " " + item.getExpertName())).setText(R.id.vStartTime, (CharSequence)(item.getOrderClosedTime() + "")).setText(R.id.vOrderStatus, (CharSequence)"\u5df2\u53d6\u6d88");
        holder.itemView.setOnClickListener(v -> this.listener.onClick(item));
    }

    public static interface OnClickItemListener {
        public void onClick(DoctorConsultationAllOrderEntity var1);
    }
}

