/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.adapter;

import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.DoctorManagerPatientsInfoDataEntity;
import com.kangxin.doctor.worktable.util.TimeUtil;
import java.util.List;

public class DoctorManagerPatientsInfoAdapter
extends BaseQuickAdapter<DoctorManagerPatientsInfoDataEntity.PageDataBean, DoctorManagerPatientsInfoListHolder> {
    private OnClickItemListener listener;

    public void setListener(OnClickItemListener listener) {
        this.listener = listener;
    }

    public DoctorManagerPatientsInfoAdapter(@Nullable List data) {
        super(R.layout.by_item_patients_info_list, data);
    }

    protected void convert(DoctorManagerPatientsInfoListHolder holder, DoctorManagerPatientsInfoDataEntity.PageDataBean item) {
        holder.vPatientsNameTv.setText((CharSequence)(item.getName() + ""));
        holder.vPatientsGenderTv.setText((CharSequence)(item.getGender() == 1 ? "\u7537" : "\u5973"));
        holder.vPatientsAgeTv.setText((CharSequence)(item.getAge() + ""));
        String createDate = TimeUtil.utc2Local(item.getCreateTime());
        holder.vPatientsCreateTimeTv.setText((CharSequence)(createDate + ""));
        holder.itemView.setOnClickListener(v -> {
            if (this.listener != null) {
                this.listener.onClick(item);
            }
        });
    }

    public static interface OnClickItemListener {
        public void onClick(DoctorManagerPatientsInfoDataEntity.PageDataBean var1);
    }

    public class DoctorManagerPatientsInfoListHolder
    extends BaseViewHolder {
        TextView vPatientsNameTv;
        TextView vPatientsGenderTv;
        TextView vPatientsAgeTv;
        TextView vPatientsCreateTimeTv;

        public DoctorManagerPatientsInfoListHolder(View view) {
            super(view);
            this.vPatientsNameTv = (TextView)view.findViewById(R.id.patients_name_tv);
            this.vPatientsGenderTv = (TextView)view.findViewById(R.id.patients_gender_tv);
            this.vPatientsAgeTv = (TextView)view.findViewById(R.id.patients_age_tv);
            this.vPatientsCreateTimeTv = (TextView)view.findViewById(R.id.patients_create_time_tv);
        }
    }
}

