/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.adapter;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.blankj.utilcode.util.StringUtils;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.Pretty;
import com.kangxin.common.byh.entity.UnionHospitalEntity;
import com.kangxin.doctor.worktable.R;
import java.util.List;

public class HospitalListAdapter
extends BaseQuickAdapter<UnionHospitalEntity, HospitalListHolder> {
    public HospitalListAdapter(@Nullable List data) {
        super(R.layout.by_item_hospital_list, data);
    }

    protected void convert(HospitalListHolder helper, UnionHospitalEntity item) {
        Pretty.create().loadImage(item.getHospitalLogo()).into(helper.vHospitalIcon);
        helper.vHospitalName.setText((CharSequence)(item.getHospitalName() + ""));
        if (!StringUtils.isEmpty((CharSequence)item.getHosType())) {
            helper.vHospitalType.setText((CharSequence)(item.getHosType() + ""));
            helper.vHospitalType.setVisibility(0);
        }
        helper.vHospitalDepCount.setText((CharSequence)(item.getDepartmentNum() + ""));
        helper.vHospitalExpertCount.setText((CharSequence)(item.getDoctorNum() + ""));
        if (item.getHotDepartmentName() != null) {
            String[] split = item.getHotDepartmentName().split(",");
            String hotHosName = "";
            for (int i = 0; i < (split.length > 3 ? 3 : split.length); ++i) {
                hotHosName = split[i] + " " + hotHosName;
            }
            helper.vHospitalDep1.setText((CharSequence)hotHosName);
        }
        if (item.getIsCenterHospital() != null && item.getIsCenterHospital() == 1) {
            helper.vHospitalTypeCenter.setVisibility(0);
        }
        helper.itemView.setTag((Object)("" + item.getHospitalId()));
    }

    public class HospitalListHolder
    extends BaseViewHolder {
        ImageView vHospitalIcon;
        TextView vHospitalName;
        TextView vHospitalType;
        TextView vHospitalTypeCenter;
        TextView vHospitalDepCount;
        TextView vHospitalExpertCount;
        TextView vHospitalImportent;
        TextView vHospitalDep1;
        TextView vHospitalDep2;
        TextView vHospitalDep3;

        public HospitalListHolder(View view) {
            super(view);
            this.vHospitalIcon = (ImageView)view.findViewById(R.id.vHospitalIcon);
            this.vHospitalTypeCenter = (TextView)view.findViewById(R.id.vHospitalTypeCenter);
            this.vHospitalName = (TextView)view.findViewById(R.id.vHospitalName);
            this.vHospitalType = (TextView)view.findViewById(R.id.vHospitalType);
            this.vHospitalDepCount = (TextView)view.findViewById(R.id.vHospitalDepCount);
            this.vHospitalExpertCount = (TextView)view.findViewById(R.id.vHospitalExpertCount);
            this.vHospitalImportent = (TextView)view.findViewById(R.id.vHospitalImportent);
            this.vHospitalDep1 = (TextView)view.findViewById(R.id.vHospitalDep1);
            this.vHospitalDep2 = (TextView)view.findViewById(R.id.vHospitalDep2);
            this.vHospitalDep3 = (TextView)view.findViewById(R.id.vHospitalDep3);
        }
    }
}

