/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.adapter;

import android.util.Log;
import android.view.View;
import android.widget.TextView;
import cn.finalteam.toolsfinal.StringUtils;
import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.byh.entity.OrderItemEntity;
import com.kangxin.doctor.worktable.R;
import java.util.List;

public class NewApplyOrderListAdapter
extends BaseMultiItemQuickAdapter<OrderItemEntity, BaseViewHolder> {
    private static final String TAG = "NewApplyOrderListAdapte";
    private OnClickItemListener listener;

    public void setListener(OnClickItemListener listener) {
        this.listener = listener;
    }

    public NewApplyOrderListAdapter(List<OrderItemEntity> data) {
        super(data);
        this.addItemType(6, R.layout.by_item_order_list_new_apply);
        this.addItemType(55, R.layout.by_item_order_list_wait_resolution);
        this.addItemType(5, R.layout.by_item_order_list_wait_resolution);
        this.addItemType(8, R.layout.by_item_order_list_wait_resolution);
        this.addItemType(10, R.layout.by_item_order_list_wait_resolution);
        this.addItemType(20, R.layout.by_item_order_list_wait_resolution);
        this.addItemType(30, R.layout.by_item_order_list_running);
        this.addItemType(40, R.layout.by_item_order_list_complete);
        this.addItemType(50, R.layout.worktab_by_item_order_list_cancle);
    }

    protected void convert(BaseViewHolder helper, OrderItemEntity item) {
        int viewType = helper.getItemViewType();
        switch (item.getOrderStatus()) {
            case 6: {
                this.newApply(helper, item);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 20: 
            case 55: {
                this.waitResolution(helper, item);
                break;
            }
            case 30: {
                this.running(helper, item);
                break;
            }
            case 40: {
                this.completeOrder(helper, item);
            }
            case 50: {
                this.cancleOrder(helper, item);
            }
        }
    }

    private void cancleOrder(BaseViewHolder holder, OrderItemEntity item) {
        switch (item.getOrderStatus()) {
            case 50: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u5df2\u53d6\u6d88");
                holder.setText(R.id.vEndTime, (CharSequence)item.getCloseTime());
            }
        }
        holder.setText(R.id.vTime, (CharSequence)(item.getOrderUpdateTimeStr() + "")).setText(R.id.vPatientInfo, (CharSequence)(item.getPatientName() + "," + item.getPatientAge() + "," + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vOrderType, (CharSequence)(item.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587")).setText(R.id.vExpertInfo, (CharSequence)("" + item.getExpertHosName() + " " + item.getExpertName())).setText(R.id.vStartTime, (CharSequence)(item.getOrderCreateTimeStr() + ""));
    }

    private void waitResolution(BaseViewHolder holder, final OrderItemEntity item) {
        switch (item.getOrderStatus()) {
            case 55: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u5f85\u5904\u7406");
                break;
            }
            case 5: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u5f85\u60a3\u8005\u7b7e\u7f72");
                break;
            }
            case 8: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u5f85\u5206\u914d");
                break;
            }
            case 10: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u5f85\u652f\u4ed8");
                break;
            }
            case 20: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u5f85\u63a5\u8bca");
                break;
            }
            default: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u672a\u77e5\u72b6\u6001");
            }
        }
        Log.i((String)TAG, (String)("groupid:" + item.getGroupId() + ", name:" + item.getPatientName()));
        holder.setText(R.id.vTime, (CharSequence)(item.getOrderUpdateTimeStr() + "")).setText(R.id.vPatientInfo, (CharSequence)(item.getPatientName() + "," + item.getPatientAge() + "," + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vOrderType, (CharSequence)(item.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587")).setText(R.id.vExpertInfo, (CharSequence)("" + item.getExpertHosName() + " " + item.getExpertName()));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NewApplyOrderListAdapter.this.listener.onClick(item);
            }
        });
    }

    private void completeOrder(BaseViewHolder holder, final OrderItemEntity item) {
        int orderStatus = item.getOrderStatus();
        switch (orderStatus) {
            case 40: {
                holder.setText(R.id.vOrderStatus, (CharSequence)"\u5df2\u5b8c\u6210");
                holder.setText(R.id.vEndTime, (CharSequence)item.getFinishTime());
            }
        }
        holder.setText(R.id.vTime, (CharSequence)(item.getOrderUpdateTimeStr() + "")).setText(R.id.vPatientInfo, (CharSequence)(item.getPatientName() + "," + item.getPatientAge() + "," + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vOrderType, (CharSequence)(item.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587")).setText(R.id.vExpertInfo, (CharSequence)("" + item.getExpertHosName() + " " + item.getExpertName())).setText(R.id.vStartTime, (CharSequence)(item.getOrderBeginTime() + ""));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NewApplyOrderListAdapter.this.listener.onClick(item);
            }
        });
    }

    private void running(BaseViewHolder holder, final OrderItemEntity item) {
        if (!StringUtils.isBlank((String)item.getBeginTime())) {
            holder.setText(R.id.vStartTime, (CharSequence)(item.getBeginTime() + ""));
        } else {
            holder.setText(R.id.vStartTime, (CharSequence)(item.getConsultationTime() + ""));
        }
        holder.setText(R.id.vTime, (CharSequence)(item.getOrderCreateTimeStr() + "")).setText(R.id.vPatientInfo, (CharSequence)(item.getPatientName() + "," + item.getPatientAge() + "," + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vOrderType, (CharSequence)(item.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587")).setText(R.id.vExpertInfo, (CharSequence)("" + item.getExpertHosName() + " " + item.getExpertName())).setText(R.id.vOrderStatus, (CharSequence)"\u8fdb\u884c\u4e2d");
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NewApplyOrderListAdapter.this.listener.onClick(item);
            }
        });
    }

    private void newApply(BaseViewHolder baseViewHolder, final OrderItemEntity item) {
        baseViewHolder.setText(R.id.vTime, (CharSequence)(item.getOrderUpdateTimeStr() + "")).setText(R.id.vPatientName, (CharSequence)("@" + item.getPatientName())).setText(R.id.vPatientSexAge, (CharSequence)("," + item.getPatientAge() + "," + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vPatientCase, (CharSequence)("\u4e3b\u8bc9:" + item.getPatCaseMainSuit() + ""));
        baseViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NewApplyOrderListAdapter.this.listener.onClick(item);
            }
        });
    }

    public static interface OnClickItemListener {
        public void onClick(OrderItemEntity var1);
    }

    public static class CompleteOrderListViewHolder
    extends BaseViewHolder {
        TextView vTime;
        TextView vPatientAgeAndSex;
        TextView vOrderType;
        TextView vOrderStatus;
        TextView vExpertInfo;
        TextView vStartTime;
        TextView vEndTime;

        public CompleteOrderListViewHolder(View view) {
            super(view);
            this.vTime = (TextView)view.findViewById(R.id.vTime);
            this.vPatientAgeAndSex = (TextView)view.findViewById(R.id.vPatientInfo);
            this.vOrderType = (TextView)view.findViewById(R.id.vOrderType);
            this.vOrderStatus = (TextView)view.findViewById(R.id.vOrderStatus);
            this.vExpertInfo = (TextView)view.findViewById(R.id.vExpertInfo);
            this.vStartTime = (TextView)view.findViewById(R.id.vStartTime);
            this.vEndTime = (TextView)view.findViewById(R.id.vEndTime);
        }
    }

    public static class RunningOrderListViewHolder
    extends BaseViewHolder {
        TextView vTime;
        TextView vPatientAgeAndSex;
        TextView vOrderType;
        TextView vOrderStatus;
        TextView vExpertInfo;
        TextView vStartTime;

        public RunningOrderListViewHolder(View view) {
            super(view);
            this.vTime = (TextView)view.findViewById(R.id.vTime);
            this.vPatientAgeAndSex = (TextView)view.findViewById(R.id.vPatientInfo);
            this.vOrderType = (TextView)view.findViewById(R.id.vOrderType);
            this.vOrderStatus = (TextView)view.findViewById(R.id.vOrderStatus);
            this.vExpertInfo = (TextView)view.findViewById(R.id.vExpertInfo);
            this.vStartTime = (TextView)view.findViewById(R.id.vStartTime);
        }
    }

    public static class WaitOrderListViewHolder
    extends BaseViewHolder {
        TextView vTime;
        TextView vPatientAgeAndSex;
        TextView vOrderType;
        TextView vOrderStatus;
        TextView vExpertInfo;

        public WaitOrderListViewHolder(View view) {
            super(view);
            this.vTime = (TextView)view.findViewById(R.id.vTime);
            this.vPatientAgeAndSex = (TextView)view.findViewById(R.id.vPatientInfo);
            this.vOrderType = (TextView)view.findViewById(R.id.vOrderType);
            this.vOrderStatus = (TextView)view.findViewById(R.id.vOrderStatus);
            this.vExpertInfo = (TextView)view.findViewById(R.id.vExpertInfo);
        }
    }

    public static class NewApplyOrderListViewHolder
    extends BaseViewHolder {
        TextView vTime;
        TextView vPatientName;
        TextView vPatientAgeAndSex;
        TextView vPatientCase;

        public NewApplyOrderListViewHolder(View view) {
            super(view);
            this.vTime = (TextView)view.findViewById(R.id.vTime);
            this.vPatientName = (TextView)view.findViewById(R.id.vPatientName);
            this.vPatientAgeAndSex = (TextView)view.findViewById(R.id.vPatientSexAge);
            this.vPatientCase = (TextView)view.findViewById(R.id.vPatientCase);
        }
    }
}

