/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.adapter;

import android.graphics.Color;
import android.view.View;
import android.widget.TextView;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.StringUtils;
import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.byh.entity.OrderItemEntity;
import com.kangxin.common.byh.entity.OrderItemEntityV2;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.doctor.worktable.R;
import java.util.List;

public class OrderListAdapterV2
extends BaseMultiItemQuickAdapter<OrderItemEntityV2, OrderListViewHolderV2> {
    private OnClickItemListener listener;
    private IUpdateVerStatus updateVerStatus = (IUpdateVerStatus)ARouter.getInstance().build("/service_update/SERVICE_UPDATE_VER_STATUS").navigation();
    private int mConsuStatus = this.updateVerStatus.getConsuStatus(this.mContext);

    public void setListener(OnClickItemListener listener) {
        this.listener = listener;
    }

    public OrderListAdapterV2(List<OrderItemEntityV2> data) {
        super(data);
        this.addItemType(5, R.layout.worktab_by_item_wait_sign_v2);
        this.addItemType(6, R.layout.worktab_by_item_newapply_v2);
        this.addItemType(56, R.layout.worktab_by_item_draft_v2);
        this.addItemType(8, R.layout.worktab_by_item_wait_distribute_v2);
        this.addItemType(10, R.layout.worktab_by_item_wait_pay_v2);
        this.addItemType(20, R.layout.worktab_by_item_wait_receive_v2);
        this.addItemType(30, R.layout.worktab_by_item_running_v2);
        this.addItemType(40, R.layout.worktab_by_item_finish_v2);
        this.addItemType(50, R.layout.worktab_by_item_cancle_v2);
    }

    protected void convert(OrderListViewHolderV2 helper, OrderItemEntityV2 item) {
        switch (item.getOrderStatus()) {
            case 5: {
                this.waitSign(helper, item);
                break;
            }
            case 6: {
                this.newApply(helper, item);
                break;
            }
            case 56: {
                this.draft(helper, item);
                break;
            }
            case 8: {
                this.waitDistribution(helper, item);
                break;
            }
            case 10: {
                this.waitPay(helper, item);
                break;
            }
            case 20: {
                this.waitingReceiver(helper, item);
                break;
            }
            case 30: {
                this.running(helper, item);
                break;
            }
            case 40: {
                this.finish(helper, item);
                break;
            }
            case 50: {
                this.cancle(helper, item);
            }
        }
        if (helper.vDiagNameView != null) {
            if (this.mConsuStatus == 4626) {
                helper.vDiagNameView.setText((CharSequence)"\u4f1a\u8bca\u4e13\u5bb6");
            } else if (this.mConsuStatus == 4627) {
                helper.vDiagNameView.setText((CharSequence)"\u95e8\u8bca\u4e13\u5bb6");
            }
        }
        if (helper.vOrderType != null && this.mConsuStatus == 4627) {
            helper.vOrderType.setVisibility(4);
        }
        if (helper.vDiaTimeLabelView != null) {
            if (this.mConsuStatus == 4626) {
                helper.vDiaTimeLabelView.setText((CharSequence)"\u4f1a\u8bca\u65f6\u95f4");
            } else if (this.mConsuStatus == 4627) {
                helper.vDiagNameView.setText((CharSequence)"\u95e8\u8bca\u65f6\u95f4");
            }
        }
    }

    private void bgColor(OrderListViewHolderV2 helper, OrderItemEntityV2 itemEntityV2) {
        if (itemEntityV2.getProcedure() == 1) {
            helper.colorView.setBackgroundColor(Color.parseColor((String)"#3BCC62"));
        } else {
            helper.colorView.setBackgroundColor(Color.parseColor((String)"#FF7475"));
        }
    }

    private void cancle(OrderListViewHolderV2 helper, OrderItemEntityV2 item) {
        helper.vOrderType.setText((CharSequence)(item.getOrderType() == 5 ? "\u56fe\u6587" : "\u89c6\u9891"));
        helper.vConsulationEndTime.setText((CharSequence)item.getCloseTime());
        helper.vConsulationStartTime.setText((CharSequence)item.getStartTime());
        helper.vOrderTime.setText((CharSequence)(item.getOrderUpdateTimeStr() + ""));
        helper.vPatientInfo.setText((CharSequence)(item.getPatientName() + " " + (item.getPatientSex() == 1 ? "\u7537" : "\u5973") + " " + item.getPatientAge()));
        helper.vExpertInfo.setText((CharSequence)(item.getExpertHosName() + " " + item.getExpertDeptName() + " " + item.getExpertName()));
        helper.mine_apply.setText((CharSequence)(item.getProcedure() == 1 ? "\u6211\u7684\u7533\u8bf7" : "\u6211\u7684\u63a5\u6536"));
        this.noExpertInfo(helper, item);
        this.bgColor(helper, item);
    }

    private void finish(OrderListViewHolderV2 helper, OrderItemEntityV2 item) {
        helper.vOrderType.setText((CharSequence)(item.getOrderType() == 5 ? "\u56fe\u6587" : "\u89c6\u9891"));
        helper.vOrderStatus.setText((CharSequence)(item.getIsHaveReport() == 1 ? "\u5df2\u4f20\u62a5\u544a" : "\u672a\u4f20\u62a5\u544a"));
        helper.vConsulationEndTime.setText((CharSequence)item.getEndTime());
        helper.vConsulationStartTime.setText((CharSequence)item.getStartTime());
        helper.vOrderTime.setText((CharSequence)(item.getOrderUpdateTimeStr() + ""));
        helper.vPatientInfo.setText((CharSequence)(item.getPatientName() + " " + (item.getPatientSex() == 1 ? "\u7537" : "\u5973") + " " + item.getPatientAge()));
        helper.vExpertInfo.setText((CharSequence)(item.getExpertHosName() + " " + item.getExpertDeptName() + " " + item.getExpertName()));
        helper.mine_apply.setText((CharSequence)(item.getProcedure() == 1 ? "\u6211\u7684\u7533\u8bf7" : "\u6211\u7684\u63a5\u6536"));
        this.noExpertInfo(helper, item);
        this.bgColor(helper, item);
    }

    private void running(OrderListViewHolderV2 helper, OrderItemEntityV2 item) {
        helper.vOrderType.setText((CharSequence)(item.getOrderType() == 5 ? "\u56fe\u6587" : "\u89c6\u9891"));
        if (StringUtils.isEmpty((CharSequence)item.getStartTime())) {
            helper.vEndTime.setText((CharSequence)item.getConsultationTime());
        } else {
            helper.vEndTime.setText((CharSequence)item.getStartTime());
        }
        helper.vOrderTime.setText((CharSequence)(item.getOrderUpdateTimeStr() + ""));
        helper.vPatientInfo.setText((CharSequence)(item.getPatientName() + " " + (item.getPatientSex() == 1 ? "\u7537" : "\u5973") + " " + item.getPatientAge()));
        helper.vExpertInfo.setText((CharSequence)(item.getExpertHosName() + " " + item.getExpertDeptName() + " " + item.getExpertName()));
        helper.mine_apply.setText((CharSequence)(item.getProcedure() == 1 ? "\u6211\u7684\u7533\u8bf7" : "\u6211\u7684\u63a5\u6536"));
        this.noExpertInfo(helper, item);
        this.bgColor(helper, item);
    }

    private void waitSign(OrderListViewHolderV2 helper, OrderItemEntityV2 item) {
        helper.vOrderType.setText((CharSequence)(item.getOrderType() == 5 ? "\u56fe\u6587" : "\u89c6\u9891"));
        helper.vOrderTime.setText((CharSequence)(item.getOrderUpdateTimeStr() + ""));
        helper.vPatientInfo.setText((CharSequence)(item.getPatientName() + " " + (item.getPatientSex() == 1 ? "\u7537" : "\u5973") + " " + item.getPatientAge()));
        helper.vExpertInfo.setText((CharSequence)(item.getExpertHosName() + " " + item.getExpertDeptName() + " " + item.getExpertName()));
        helper.mine_apply.setText((CharSequence)(item.getProcedure() == 1 ? "\u6211\u7684\u7533\u8bf7" : "\u6211\u7684\u63a5\u6536"));
        this.noExpertInfo(helper, item);
        this.bgColor(helper, item);
    }

    private void waitPay(OrderListViewHolderV2 helper, OrderItemEntityV2 item) {
        helper.vOrderType.setText((CharSequence)(item.getOrderType() == 5 ? "\u56fe\u6587" : "\u89c6\u9891"));
        helper.vOrderTime.setText((CharSequence)(item.getStartTime() + ""));
        helper.vPatientInfo.setText((CharSequence)(item.getPatientName() + " " + (item.getPatientSex() == 1 ? "\u7537" : "\u5973") + " " + item.getPatientAge()));
        helper.vExpertInfo.setText((CharSequence)(item.getExpertHosName() + " " + item.getExpertDeptName() + " " + item.getExpertName()));
        helper.mine_apply.setText((CharSequence)(item.getProcedure() == 1 ? "\u6211\u7684\u7533\u8bf7" : "\u6211\u7684\u63a5\u6536"));
        this.noExpertInfo(helper, item);
        this.bgColor(helper, item);
    }

    private void waitDistribution(OrderListViewHolderV2 helper, OrderItemEntityV2 item) {
        helper.vOrderType.setText((CharSequence)(item.getOrderType() == 5 ? "\u56fe\u6587" : "\u89c6\u9891"));
        helper.vOrderTime.setText((CharSequence)(item.getStartTime() + ""));
        helper.vPatientInfo.setText((CharSequence)(item.getPatientName() + " " + (item.getPatientSex() == 1 ? "\u7537" : "\u5973") + " " + item.getPatientAge()));
        helper.vExpertInfo.setText((CharSequence)(item.getExpertHosName() + " " + item.getExpertDeptName() + " " + item.getExpertName()));
        helper.mine_apply.setText((CharSequence)(item.getProcedure() == 1 ? "\u6211\u7684\u7533\u8bf7" : "\u6211\u7684\u63a5\u6536"));
        this.noExpertInfo(helper, item);
        this.bgColor(helper, item);
    }

    private void waitingReceiver(OrderListViewHolderV2 helper, OrderItemEntityV2 item) {
        helper.vOrderType.setText((CharSequence)(item.getOrderType() == 5 ? "\u56fe\u6587" : "\u89c6\u9891"));
        helper.vTime.setText((CharSequence)(item.getOrderUpdateTimeStr() + ""));
        helper.vPatientInfo.setText((CharSequence)(item.getPatientName() + " " + (item.getPatientSex() == 1 ? "\u7537" : "\u5973") + " " + item.getPatientAge()));
        helper.vExpertInfo.setText((CharSequence)(item.getExpertHosName() + " " + item.getExpertDeptName() + " " + item.getExpertName()));
        helper.mine_apply.setText((CharSequence)(item.getProcedure() == 1 ? "\u6211\u7684\u7533\u8bf7" : "\u6211\u7684\u63a5\u6536"));
        this.noExpertInfo(helper, item);
        this.bgColor(helper, item);
    }

    private void draft(OrderListViewHolderV2 helper, OrderItemEntityV2 item) {
    }

    private void newApply(OrderListViewHolderV2 helper, OrderItemEntityV2 item) {
        helper.vMainSuit.setText((CharSequence)item.getMainSuit());
        helper.vTime.setText((CharSequence)(item.getOrderUpdateTimeStr() + ""));
        helper.vPatientInfo.setText((CharSequence)(item.getPatientName() + " " + (item.getPatientSex() == 1 ? "\u7537" : "\u5973") + " " + item.getPatientAge()));
        helper.mine_apply.setText((CharSequence)(item.getProcedure() == 1 ? "\u6211\u7684\u7533\u8bf7" : "\u6211\u7684\u63a5\u6536"));
        this.noExpertInfo(helper, item);
        this.bgColor(helper, item);
    }

    private void noExpertInfo(OrderListViewHolderV2 helper, OrderItemEntityV2 item) {
        View view;
        if ((StringUtils.isEmpty((CharSequence)item.getExpertHosName()) || StringUtils.isEmpty((CharSequence)item.getExpertDeptName())) && (view = helper.itemView.findViewById(R.id.vExpertInfo)) != null) {
            helper.setText(R.id.vExpertInfo, "\u6682\u65e0");
        }
    }

    public static interface OnClickItemListener {
        public void onClick(OrderItemEntity var1);
    }

    class OrderListViewHolderV2
    extends BaseViewHolder {
        TextView vOrderType;
        TextView vConsulationEndTime;
        TextView vConsulationStartTime;
        TextView vOrderStatus;
        TextView vOrderTime;
        TextView vPatientInfo;
        TextView vExpertInfo;
        TextView mine_apply;
        TextView vEndTime;
        TextView vTime;
        TextView vMainSuit;
        TextView vDiagNameView;
        View colorView;
        TextView vDiaTimeLabelView;

        public OrderListViewHolderV2(View view) {
            super(view);
            this.vOrderType = (TextView)view.findViewById(R.id.vOrderType);
            this.vConsulationEndTime = (TextView)view.findViewById(R.id.vConsulationEndTime);
            this.vConsulationStartTime = (TextView)view.findViewById(R.id.vConsulationStartTime);
            this.vOrderStatus = (TextView)view.findViewById(R.id.vOrderStatus);
            this.vOrderTime = (TextView)view.findViewById(R.id.vOrderTime);
            this.vPatientInfo = (TextView)view.findViewById(R.id.vPatientInfo);
            this.vExpertInfo = (TextView)view.findViewById(R.id.vExpertInfo);
            this.mine_apply = (TextView)view.findViewById(R.id.mine_apply);
            this.vEndTime = (TextView)view.findViewById(R.id.vEndTime);
            this.vTime = (TextView)view.findViewById(R.id.vTime);
            this.vMainSuit = (TextView)view.findViewById(R.id.vMainSuit);
            this.colorView = view.findViewById(R.id.view);
            this.vDiagNameView = (TextView)view.findViewById(R.id.order_expert);
            this.vDiaTimeLabelView = (TextView)view.findViewById(R.id.consulation_time);
        }
    }
}

