/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.adapter;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.Pretty;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.PracticeExperienceInfoEntity;
import com.kangxin.doctor.worktable.util.TimeUtil;
import java.util.List;

public class PracticeExperienceListAdapter
extends BaseQuickAdapter<PracticeExperienceInfoEntity, PracticeExperienceListHolder> {
    private Context mContext;

    public PracticeExperienceListAdapter(Context context, @Nullable List data) {
        super(R.layout.by_item_personal_graduated_institutions, data);
        this.mContext = context;
    }

    protected void convert(PracticeExperienceListHolder helper, PracticeExperienceInfoEntity item) {
        if (item != null) {
            Pretty.create().loadImage(item.getHospitalHeadImage()).err(R.mipmap.ic_work_experience).placeholder(R.mipmap.ic_work_experience).bitmapTransform(1).into(helper.vImg);
            helper.vCollegeTv.setText((CharSequence)item.getHospitalName());
            helper.vSpecializedTv.setText((CharSequence)item.getStdSecondDeptName());
            String startTimeStr = item.getStartTime();
            String endTimeStr = item.getEndTime();
            if (!startTimeStr.isEmpty() && !endTimeStr.isEmpty()) {
                startTimeStr = startTimeStr.split("T")[0];
                startTimeStr = TimeUtil.dateToStamp(startTimeStr);
                endTimeStr = endTimeStr.split("T")[0];
                endTimeStr = TimeUtil.dateToStamp(endTimeStr);
                helper.vGraduationTimeTv.setText((CharSequence)(startTimeStr + " - " + endTimeStr));
            }
        }
    }

    public class PracticeExperienceListHolder
    extends BaseViewHolder {
        TextView vCollegeTv;
        TextView vSpecializedTv;
        TextView vGraduationTimeTv;
        ImageView vImg;

        public PracticeExperienceListHolder(View view) {
            super(view);
            this.vCollegeTv = (TextView)view.findViewById(R.id.college_tv);
            this.vSpecializedTv = (TextView)view.findViewById(R.id.specialized_tv);
            this.vGraduationTimeTv = (TextView)view.findViewById(R.id.graduation_time_tv);
            this.vImg = (ImageView)view.findViewById(R.id.head_shot_img);
        }
    }
}

