/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.Pretty;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.entity.ServiceSettingHospitalEntity;
import java.util.List;

public class ServiceSettingHospitalListAdapter
extends BaseQuickAdapter<ServiceSettingHospitalEntity, ServiceSettingHospitalListHolder> {
    private Context mContext;
    private OnClickItemListener mListener;

    public void setListener(OnClickItemListener listener) {
        this.mListener = listener;
    }

    public ServiceSettingHospitalListAdapter(Context context) {
        super(R.layout.worktab_by_item_service_setting_hospital_list);
        this.mContext = context;
    }

    public ServiceSettingHospitalListAdapter(@Nullable List<ServiceSettingHospitalEntity> data, Context context) {
        super(R.layout.worktab_by_item_service_setting_hospital_list, data);
        this.mContext = context;
    }

    protected void convert(ServiceSettingHospitalListHolder helper, ServiceSettingHospitalEntity item) {
        if (!TextUtils.isEmpty((CharSequence)item.getGroupName())) {
            helper.vHospitalServiceTv.setText((CharSequence)(item.getGroupName() + ""));
            if (item.getStatus() == -1) {
                helper.vHospitalServiceNextTv.setText((CharSequence)"\u672a\u5f00\u901a");
                helper.vHospitalServiceNextTv.setTextColor(this.mContext.getResources().getColor(R.color.color_999999));
                helper.vHospitalServiceNextImg.setVisibility(4);
                helper.itemView.setClickable(false);
            } else if (item.getStatus() == 1) {
                helper.vHospitalServiceNextTv.setText((CharSequence)"\u5df2\u5f00\u901a");
                helper.vHospitalServiceNextTv.setTextColor(this.mContext.getResources().getColor(R.color.colorPrimary));
                helper.vHospitalServiceNextImg.setVisibility(0);
                helper.itemView.setClickable(true);
                helper.itemView.setOnClickListener(v -> {
                    if (this.mListener != null) {
                        this.mListener.onClick(item);
                    }
                });
            }
            Pretty.create().loadImage(item.getIcon() + "").bitmapTransform(1).into(helper.vHospitalServiceImg);
        }
    }

    public static interface OnClickItemListener {
        public void onClick(ServiceSettingHospitalEntity var1);
    }

    class ServiceSettingHospitalListHolder
    extends BaseViewHolder {
        ImageView vHospitalServiceImg;
        TextView vHospitalServiceTv;
        TextView vHospitalServiceNextTv;
        ImageView vHospitalServiceNextImg;

        public ServiceSettingHospitalListHolder(View view) {
            super(view);
            this.vHospitalServiceImg = (ImageView)view.findViewById(R.id.hospital_service_img);
            this.vHospitalServiceTv = (TextView)view.findViewById(R.id.hospital_service_tv);
            this.vHospitalServiceNextTv = (TextView)view.findViewById(R.id.hospital_service_next_icon_tv);
            this.vHospitalServiceNextImg = (ImageView)view.findViewById(R.id.hospital_service_next_icon_img);
        }
    }
}

