/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.adapter;

import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import cn.finalteam.toolsfinal.StringUtils;
import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.byh.entity.OrderItemEntity;
import com.kangxin.doctor.worktable.R;
import java.util.List;

public class WaitResolutionOrderListAdapter
extends BaseMultiItemQuickAdapter<OrderItemEntity, BaseViewHolder> {
    public WaitResolutionOrderListAdapter(@Nullable List<OrderItemEntity> data) {
        super(data);
        this.addItemType(8, R.layout.by_item_order_receiver_wait);
        this.addItemType(20, R.layout.by_item_order_receiver_wait);
        this.addItemType(30, R.layout.by_item_order_receiver_running);
        this.addItemType(40, R.layout.by_item_order_receiver_complete);
        this.addItemType(50, R.layout.by_item_order_list_complete);
    }

    protected void convert(BaseViewHolder helper, OrderItemEntity item) {
        switch (helper.getItemViewType()) {
            case 8: 
            case 20: {
                this.waitResolution(helper, item);
                break;
            }
            case 30: {
                this.running(helper, item);
                break;
            }
            case 40: {
                this.completeOrder(helper, item);
            }
        }
    }

    private void waitResolution(BaseViewHolder holder, OrderItemEntity item) {
        holder.setText(R.id.vTime, (CharSequence)item.getOrderUpdateTimeStr()).setText(R.id.vPatientInfo, (CharSequence)(item.getPatientName() + "," + item.getPatientAge() + "," + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vOrderType, (CharSequence)(item.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587")).setText(R.id.vExpertInfo, (CharSequence)("" + item.getExpertHosName() + " " + item.getExpertName())).setText(R.id.vOrderStatus, (CharSequence)"\u5f85\u63a5\u8bca");
    }

    private void completeOrder(BaseViewHolder holder, OrderItemEntity item) {
        holder.setText(R.id.vTime, (CharSequence)item.getOrderUpdateTimeStr()).setText(R.id.vPatientInfo, (CharSequence)(item.getPatientName() + "," + item.getPatientAge() + "," + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vOrderType, (CharSequence)(item.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587")).setText(R.id.vExpertInfo, (CharSequence)("" + item.getExpertHosName() + " " + item.getExpertName())).setText(R.id.vOrderStatus, (CharSequence)"\u5df2\u5b8c\u6210").setText(R.id.vStartTime, (CharSequence)(item.getBeginTime() + "")).setText(R.id.vEndTime, (CharSequence)(item.getFinishTime() + ""));
    }

    private void running(BaseViewHolder holder, OrderItemEntity item) {
        holder.setText(R.id.vTime, (CharSequence)item.getOrderCreateTimeStr()).setText(R.id.vPatientInfo, (CharSequence)(item.getPatientName() + "," + item.getPatientAge() + "," + (item.getPatientSex() == 1 ? "\u7537" : "\u5973"))).setText(R.id.vOrderType, (CharSequence)(item.getOrderType() == 4 ? "\u89c6\u9891" : "\u56fe\u6587")).setText(R.id.vExpertInfo, (CharSequence)("" + item.getExpertHosName() + " " + item.getExpertName())).setText(R.id.vOrderStatus, (CharSequence)"\u8fdb\u884c\u4e2d");
        if (!StringUtils.isBlank((String)item.getBeginTime())) {
            holder.setText(R.id.vStartTime, (CharSequence)(item.getBeginTime() + ""));
        } else {
            holder.setText(R.id.vStartTime, (CharSequence)(item.getConsultationTime() + ""));
        }
    }

    class CompleteOrderListViewHolder
    extends BaseViewHolder {
        TextView vTime;
        TextView vPatientAgeAndSex;
        TextView vOrderType;
        TextView vOrderStatus;
        TextView vExpertInfo;
        TextView vStartTime;
        TextView vEndTime;

        public CompleteOrderListViewHolder(View view) {
            super(view);
            this.vTime = (TextView)view.findViewById(R.id.vTime);
            this.vPatientAgeAndSex = (TextView)view.findViewById(R.id.vPatientInfo);
            this.vOrderType = (TextView)view.findViewById(R.id.vOrderType);
            this.vOrderStatus = (TextView)view.findViewById(R.id.vOrderStatus);
            this.vExpertInfo = (TextView)view.findViewById(R.id.vExpertInfo);
            this.vStartTime = (TextView)view.findViewById(R.id.vStartTime);
            this.vEndTime = (TextView)view.findViewById(R.id.vEndTime);
        }
    }

    class RunningOrderListViewHolder
    extends BaseViewHolder {
        TextView vTime;
        TextView vPatientAgeAndSex;
        TextView vOrderType;
        TextView vOrderStatus;
        TextView vExpertInfo;
        TextView vStartTime;

        public RunningOrderListViewHolder(View view) {
            super(view);
            this.vTime = (TextView)view.findViewById(R.id.vTime);
            this.vPatientAgeAndSex = (TextView)view.findViewById(R.id.vPatientInfo);
            this.vOrderType = (TextView)view.findViewById(R.id.vOrderType);
            this.vOrderStatus = (TextView)view.findViewById(R.id.vOrderStatus);
            this.vExpertInfo = (TextView)view.findViewById(R.id.vExpertInfo);
            this.vStartTime = (TextView)view.findViewById(R.id.vStartTime);
        }
    }

    class WaitOrderListViewHolder
    extends BaseViewHolder {
        TextView vTime;
        TextView vPatientAgeAndSex;
        TextView vOrderType;
        TextView vOrderStatus;
        TextView vExpertInfo;

        public WaitOrderListViewHolder(View view) {
            super(view);
            this.vTime = (TextView)view.findViewById(R.id.vTime);
            this.vPatientAgeAndSex = (TextView)view.findViewById(R.id.vPatientInfo);
            this.vOrderType = (TextView)view.findViewById(R.id.vOrderType);
            this.vOrderStatus = (TextView)view.findViewById(R.id.vOrderStatus);
            this.vExpertInfo = (TextView)view.findViewById(R.id.vExpertInfo);
        }
    }
}

