/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.adapter.v2;

import android.graphics.Color;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.alibaba.android.arouter.launcher.ARouter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.Pretty;
import com.kangxin.common.byh.entity.v2.ExpertItemEntityV2;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.doctor.worktable.R;
import java.util.List;

public class BHExpertListAdapter
extends BaseQuickAdapter<ExpertItemEntityV2, ExpertListViewHolder> {
    private boolean isFamousExpert;
    private int mConsuStatus;

    public BHExpertListAdapter(boolean isFamousExpert, @Nullable List<ExpertItemEntityV2> data) {
        super(R.layout.by_item_expert_list, data);
        this.isFamousExpert = isFamousExpert;
        IUpdateVerStatus updateVerStatus = (IUpdateVerStatus)ARouter.getInstance().build("/service_update/SERVICE_UPDATE_VER_STATUS").navigation();
        this.mConsuStatus = updateVerStatus.getConsuStatus(this.mContext);
    }

    protected void convert(ExpertListViewHolder helper, ExpertItemEntityV2 item) {
        Pretty.create().loadImage(item.getHeadPortrait()).into(helper.vHeadView);
        helper.vExpertName.setText((CharSequence)item.getName());
        helper.vHospitalName.setText((CharSequence)item.getRegHospitalName());
        helper.vExpertLevel.setText((CharSequence)item.getProfession());
        helper.vExpertDepartment.setText((CharSequence)item.getHospitalDeptName());
        helper.vExpertAdept.setText((CharSequence)item.getSpeciality());
        if (this.mConsuStatus == 4626) {
            this.bindGroupConsuItem(helper, item);
        } else if (this.mConsuStatus == 4627) {
            this.bindOutDeptItem(helper, item);
        }
    }

    private void bindOutDeptItem(ExpertListViewHolder helper, ExpertItemEntityV2 item) {
        helper.vGraphName.setVisibility(4);
        helper.vGraphImgView.setVisibility(4);
        helper.vExpertAmount.setVisibility(4);
        helper.vGraphCount.setVisibility(4);
        helper.vVideoConsuName.setText((CharSequence)"\u8fdc\u7a0b\u95e8\u8bca");
        helper.vApply.setText((CharSequence)"\u7533\u8bf7\u95e8\u8bca");
        if (item.getRemoteClcStatus() == null || item.getRemoteClcStatus() == -1) {
            helper.vExpertVideoAmount.setText((CharSequence)"\u6682\u672a\u5f00\u901a");
            helper.vExpertVideoAmount.setTextColor(Color.parseColor((String)"#999999"));
            helper.setImageResource(R.id.video, R.mipmap.ic_ychz1);
            helper.vVideoCount.setVisibility(8);
        } else {
            helper.vExpertVideoAmount.setTextColor(Color.parseColor((String)"#999999"));
            helper.vExpertVideoAmount.setText((CharSequence)("" + item.getRemotelcPrice() + "\u5143"));
            helper.vVideoCount.setVisibility(0);
            helper.setImageResource(R.id.video, R.mipmap.ic_ychz);
            item.setOpenVideoService(true);
        }
    }

    private void bindGroupConsuItem(ExpertListViewHolder helper, ExpertItemEntityV2 item) {
        if (item.getGraphicStatus() == null || item.getGraphicStatus() == -1) {
            helper.vExpertAmount.setText((CharSequence)"\u6682\u672a\u5f00\u901a");
            helper.vExpertAmount.setTextColor(Color.parseColor((String)"#999999"));
            helper.setImageResource(R.id.graph, R.mipmap.ic_twhz1);
            helper.vGraphCount.setVisibility(8);
        } else {
            helper.vExpertAmount.setTextColor(Color.parseColor((String)"#999999"));
            double graphicPrice = item.getGraphicPrice();
            helper.vExpertAmount.setText((CharSequence)("" + graphicPrice + "\u5143"));
            helper.vGraphCount.setVisibility(0);
            helper.setImageResource(R.id.graph, R.mipmap.ic_twhz);
            item.setOpenGraphService(true);
        }
        if (item.getVideoStatus() == null || item.getVideoStatus() == -1) {
            helper.vExpertVideoAmount.setText((CharSequence)"\u6682\u672a\u5f00\u901a");
            helper.vExpertVideoAmount.setTextColor(Color.parseColor((String)"#999999"));
            helper.setImageResource(R.id.video, R.mipmap.ic_ychz1);
            helper.vVideoCount.setVisibility(8);
        } else {
            helper.vExpertVideoAmount.setTextColor(Color.parseColor((String)"#999999"));
            helper.vExpertVideoAmount.setText((CharSequence)("" + item.getVideoPrice() + "\u5143"));
            helper.vVideoCount.setVisibility(0);
            helper.setImageResource(R.id.video, R.mipmap.ic_ychz);
            item.setOpenVideoService(true);
        }
        helper.addOnClickListener(R.id.vApply);
    }

    class ExpertListViewHolder
    extends BaseViewHolder {
        ImageView vHeadView;
        TextView vExpertName;
        TextView vHospitalName;
        TextView vApply;
        TextView vExpertAdept;
        TextView vExpertAmount;
        TextView vExpertVideoAmount;
        TextView vExpertLevel;
        TextView vExpertDepartment;
        TextView vVideoCount;
        TextView vGraphCount;
        TextView vGraphName;
        ImageView vGraphImgView;
        TextView vVideoConsuName;

        public ExpertListViewHolder(View view) {
            super(view);
            this.vHeadView = (ImageView)view.findViewById(R.id.vHeadView);
            this.vExpertName = (TextView)view.findViewById(R.id.vExpertName);
            this.vHospitalName = (TextView)view.findViewById(R.id.vHospitalName);
            this.vApply = (TextView)view.findViewById(R.id.vApply);
            this.vExpertAdept = (TextView)view.findViewById(R.id.vExpertAdept);
            this.vExpertAmount = (TextView)view.findViewById(R.id.vExpertAmount);
            this.vExpertVideoAmount = (TextView)view.findViewById(R.id.vExpertVideoAmount);
            this.vExpertLevel = (TextView)view.findViewById(R.id.vExpertLevel);
            this.vExpertDepartment = (TextView)view.findViewById(R.id.vExpertDepartment);
            this.vVideoCount = (TextView)view.findViewById(R.id.vVideoCount);
            this.vGraphCount = (TextView)view.findViewById(R.id.vGraphCount);
            this.vGraphName = (TextView)view.findViewById(R.id.graph_name);
            this.vGraphImgView = (ImageView)view.findViewById(R.id.graph);
            this.vVideoConsuName = (TextView)view.findViewById(R.id.video_consu_name);
        }
    }
}

