/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.adapter.v2;

import android.content.Context;
import android.graphics.Color;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.DepartmentEntity;
import com.kangxin.common.byh.entity.MenuDepartmentList;
import com.kangxin.common.byh.entity.v2.HospitalDepEntityV2;
import com.kangxin.common.byh.entity.v2.HospitalDepsmallEntityV2;
import com.kangxin.common.byh.entity.v2.OneDepEntityV2;
import com.kangxin.common.byh.entity.v2.TwoDepEntityV2;
import com.kangxin.common.byh.module.IHospitalModule;
import com.kangxin.common.widget.ProgressDialogObserver;
import com.kangxin.common.widget.adapter.RelationMoveAdapter;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.module.impl2.BHHospitalModule;
import io.reactivex.Observer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BHHospitalDepAdapter
extends RelationMoveAdapter<MenuDepartmentList> {
    private static final String TAG = "BHHospitalDepAdapter";
    private Context mContext;
    private IHospitalModule hospitalModule;
    private List<OneDepEntityV2> hopitalList;
    private List<TwoDepEntityV2> departmentEntities;
    private List<HospitalDepEntityV2> hospitalListDep;
    private List<HospitalDepsmallEntityV2> departmentEntitiesDep;
    private boolean isStandardDepartment = false;

    public BHHospitalDepAdapter(final Context mContext, long mHospitalId, String openCode) {
        this.mContext = mContext;
        this.hospitalModule = new BHHospitalModule();
        Log.i((String)TAG, (String)("BHHospitalDepAdapter: mHosId:" + mHospitalId + ", openCode:" + openCode));
        this.hospitalModule.getHospitalAllDepartmentListV2(Long.valueOf(mHospitalId), openCode).subscribe((Observer)new ProgressDialogObserver<ResponseBody<List<HospitalDepEntityV2>>>(){

            public void onNext(ResponseBody<List<HospitalDepEntityV2>> listResponseBody) {
                BHHospitalDepAdapter.this.hospitalListDep = (List)listResponseBody.getData();
                if (BHHospitalDepAdapter.this.hospitalListDep != null && BHHospitalDepAdapter.this.hospitalListDep.size() > 0) {
                    BHHospitalDepAdapter.this.departmentEntitiesDep = ((HospitalDepEntityV2)BHHospitalDepAdapter.this.hospitalListDep.get(0)).getDeptList();
                }
                BHHospitalDepAdapter.this.flushView();
            }

            protected Context attachContext() {
                return mContext;
            }
        });
    }

    public BHHospitalDepAdapter(Context mContext, boolean isShowHotDepartment) {
        this.mContext = mContext;
        this.hospitalModule = new BHHospitalModule();
        this.isStandardDepartment = true;
        this.hospitalModule.getStandardDepartmentV2().subscribe(listResponseBody -> {
            this.hopitalList = (List)listResponseBody.getData();
            if (this.hopitalList != null) {
                this.departmentEntities = this.hopitalList.get(0).getStdSecondDeptVOS();
            }
            this.flushView();
        });
    }

    public List<OneDepEntityV2> getHopitalList() {
        return this.hopitalList;
    }

    public BHHospitalDepAdapter(Context mContext) {
        this(mContext, true);
    }

    @Deprecated
    private List<MenuDepartmentList> parseHotDepartment(List<MenuDepartmentList> result) {
        MenuDepartmentList menuDepartmentList = new MenuDepartmentList();
        menuDepartmentList.setDisplayName("\u70ed\u95e8\u79d1\u5ba4");
        menuDepartmentList.setShortName("\u70ed\u95e8\u79d1\u5ba4");
        menuDepartmentList.setIconUrl("");
        menuDepartmentList.setRemark("remark");
        ArrayList<DepartmentEntity> departmentEntities = new ArrayList<DepartmentEntity>();
        DepartmentEntity departmentEntity = new DepartmentEntity();
        departmentEntity.setHospitalId(0);
        departmentEntity.setName("\u5168\u90e8\u79d1\u5ba4");
        departmentEntity.setStdSecondDepId(0);
        departmentEntity.setStdFirstDepId(0);
        departmentEntities.add(departmentEntity);
        menuDepartmentList.setStandardSecondDepartmentList(departmentEntities);
        result.add(0, menuDepartmentList);
        return result;
    }

    public int getLeftSize() {
        if (this.isStandardDepartment) {
            if (this.hopitalList == null) {
                return 0;
            }
            return this.hopitalList.size();
        }
        if (this.hospitalListDep == null) {
            return 0;
        }
        return this.hospitalListDep.size();
    }

    public int getRightSize() {
        if (this.isStandardDepartment) {
            if (this.departmentEntities == null) {
                return 0;
            }
            return this.departmentEntities.size();
        }
        if (this.departmentEntitiesDep == null) {
            return 0;
        }
        return this.departmentEntitiesDep.size();
    }

    @NotNull
    public View getLeftItem() {
        return View.inflate((Context)this.mContext, (int)R.layout.worktab_by_item_text_dep, null);
    }

    @NotNull
    public View getRightItem() {
        return View.inflate((Context)this.mContext, (int)R.layout.by_item_text_right, null);
    }

    public void leftDefaultStyle(View view) {
        if (view != null) {
            TextView textView = (TextView)view;
            textView.setTextColor(Color.parseColor((String)"#333333"));
            textView.setBackgroundColor(Color.parseColor((String)"#F4F4F4"));
        }
    }

    public void rightDefaultStyle(View view) {
        if (view != null) {
            TextView textView = (TextView)view.findViewById(R.id.vText);
            view.findViewById(R.id.vRightImage).setVisibility(4);
            textView.setTextColor(Color.parseColor((String)"#333333"));
        }
    }

    public void leftSelectedStyle(@NotNull View view) {
        TextView textView = (TextView)view;
        textView.setTextColor(Color.parseColor((String)"#3576E0"));
        textView.setBackgroundColor(Color.parseColor((String)"#ffffff"));
    }

    public void rightSelectedStyle(@NotNull View view) {
        view.findViewById(R.id.vRightImage).setVisibility(0);
        TextView textView = (TextView)view.findViewById(R.id.vText);
        textView.setTextColor(Color.parseColor((String)"#3576E0"));
    }

    public void fullRightView(int position, @Nullable List<? extends MenuDepartmentList> datas, @Nullable View view) {
        TextView textView = (TextView)view.findViewById(R.id.vText);
        textView.setTextColor(Color.parseColor((String)"#3576E0"));
        if (this.isStandardDepartment) {
            textView.setText((CharSequence)this.departmentEntities.get(position).getStdSecondDeptName());
            view.setTag((Object)(this.departmentEntities.get(position).getStdSecondDeptId() + ""));
        } else {
            textView.setText((CharSequence)this.departmentEntitiesDep.get(position).getDeptName());
            view.setTag((Object)(this.departmentEntitiesDep.get(position).getDeptId() + ""));
        }
    }

    public void fullLeftView(int position, @Nullable List<? extends MenuDepartmentList> datas, @Nullable View view) {
        TextView leftItem = (TextView)view;
        if (this.isStandardDepartment) {
            leftItem.setText((CharSequence)this.hopitalList.get(position).getStdFirstDeptName());
            leftItem.setTag((Object)(this.hopitalList.get(position).getStdFirstDeptId() + ""));
        } else if (this.hospitalListDep != null && this.hospitalListDep.size() > 0) {
            leftItem.setText((CharSequence)this.hospitalListDep.get(position).getDisplayName());
            leftItem.setTag((Object)this.hospitalListDep.get(position).getStandDeptId());
        }
    }

    public void updateRightEvent(int position) {
        if (this.isStandardDepartment) {
            this.departmentEntities = this.hopitalList.get(position).getStdSecondDeptVOS();
        } else {
            this.departmentEntitiesDep = this.hospitalListDep.get(position).getDeptList();
        }
    }

    public List<HospitalDepEntityV2> getHospitalListDep() {
        return this.hospitalListDep;
    }
}

