/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.fragment.v2;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.activity.MulitImageShowActivity;
import com.kangxin.common.byh.adapter.SelectImageListAdapter;
import com.kangxin.common.byh.entity.ExpertItemEntity;
import com.kangxin.common.byh.entity.OrderApplyEntity;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.entity.PatientEntity;
import com.kangxin.common.byh.entity.UpdateCaseEntity;
import com.kangxin.common.byh.entity.response.PatientDetailEntity;
import com.kangxin.common.byh.entity.v2.ExpertItemEntityV2;
import com.kangxin.common.byh.entity.v2.PatientEntityV2;
import com.kangxin.common.byh.global.ByConstant;
import com.kangxin.common.byh.inter.IPatientCaseUpdateEvent;
import com.kangxin.common.byh.present.IOrderApplyPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.byh.widget.BottomSelectDialog;
import com.kangxin.common.byh.widget.SelectImageDecoration;
import com.kangxin.common.util.StringUtil;
import com.kangxin.common.widget.SpanColorTextView;
import com.kangxin.doctor.worktable.AddPatientFragment;
import com.kangxin.doctor.worktable.BuildConfig;
import com.kangxin.doctor.worktable.CityFragment;
import com.kangxin.doctor.worktable.DepartmentFilterFragment;
import com.kangxin.doctor.worktable.FamousExpertFragment;
import com.kangxin.doctor.worktable.NewApplyFragment;
import com.kangxin.doctor.worktable.OrderApplySignFragment;
import com.kangxin.doctor.worktable.OrderApplySuccessFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.SampleHospitalListFragment;
import com.kangxin.doctor.worktable.SelectHospitalFragment;
import com.kangxin.doctor.worktable.fragment.v2.UnionHospitalListFragment;
import com.kangxin.doctor.worktable.presenter.clc.ClcOrderPresent;
import com.kangxin.doctor.worktable.presenter.impl2.BHOrderApplyPresenter;
import com.kangxin.doctor.worktable.util.SkipUtil;
import com.kangxin.doctor.worktable.view.IOrderApplyView;
import com.kangxin.doctor.worktable.widget.OrderTypeSelectDialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.jetbrains.annotations.NotNull;

@Route(path="/workTable/OrderApplyFragment")
public class BHOrderApplyFragment
extends BaseFragment
implements IToolView,
IOrderApplyView {
    private static final String TAG = "BHOrderApplyFragment";
    private static final int REQUEST_CITY_CODE = 1;
    private static final int REQUEST_DEPARTMENT_CODE = 2;
    private static final int REQUEST_HOSPITAL_CODE = 3;
    @BindView(value=2131428101)
    TextView vChangeExpert;
    @BindView(value=2131427587)
    TextView vDiaRequiDescView;
    @BindView(value=2131428084)
    TextView vAddPatient;
    @BindView(value=2131428272)
    TextView vSelectPatient;
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    @BindView(value=2131428197)
    TextView vMustUploadCaseFile;
    @BindView(value=2131428154)
    TextView vExpertName;
    @BindView(value=2131428150)
    TextView vExpertLevel;
    @BindView(value=2131428147)
    TextView vExpertHospital;
    @BindView(value=2131428142)
    TextView vExpertDepartment;
    @BindView(value=2131428209)
    TextView vOrderType;
    @BindView(value=2131428225)
    TextView vPatientName;
    @BindView(value=2131428230)
    TextView vPatientSex;
    @BindView(value=2131428213)
    TextView vPatientAge;
    @BindView(value=2131428215)
    TextView vPatientCard;
    @BindView(value=2131428227)
    TextView vPatientPhone;
    @BindView(value=2131428244)
    TextView vPresentHistory;
    @BindView(value=2131427924)
    TextView vSelhosStartView;
    @BindView(value=2131428194)
    EditText vMainSuit;
    @BindView(value=2131428260)
    EditText vResult;
    @BindView(value=2131428196)
    EditText vMudi;
    @BindView(value=2131428236)
    EditText vPerHistory;
    @BindView(value=2131428195)
    EditText vMedicalHistory;
    @BindView(value=2131428164)
    EditText vFamilyHistory;
    @BindView(value=2131428092)
    TextView vAreaSelect;
    @BindView(value=2131427385)
    TextView vAreaLabelView;
    @BindView(value=2131428061)
    SpanColorTextView vConsuTypeView;
    @BindView(value=2131427569)
    View vExpertInfoLayout;
    @BindView(value=2131428183)
    TextView vHospitalSelect;
    @BindView(value=2131427513)
    TextView vDeptLabelView;
    @BindView(value=2131427797)
    TextView vConsuTypeLabelView;
    @BindView(value=2131427753)
    TextView vExpertNameLabelView;
    @BindView(value=2131427606)
    TextView vDiaDirecLabelView;
    @BindView(value=2131428131)
    TextView vDepartmentSelect;
    @BindView(value=2131428211)
    TextView vOrderTypeSelect;
    @BindView(value=2131428148)
    ConstraintLayout vExpertInfo;
    @BindView(value=2131428246)
    ConstraintLayout vQuickDistribute;
    @BindView(value=2131428247)
    ConstraintLayout vQucikDistributeHeadLayout;
    @BindView(value=2131428105)
    TextView vCommit;
    @BindView(value=2131428268)
    ScrollView vScrollView;
    @BindView(value=2131427664)
    TextView vInitDiagnoseView;
    @BindView(value=2131427666)
    TextView vInitDiaStartView;
    @BindView(value=2131427459)
    TextView vConsuDirectStartView;
    @BindView(value=2131427563)
    TextView vDiaLabelView;
    AlertDialog vAlertDialog;
    OrderTypeSelectDialog orderTypeSelectDialog;
    private SelectImageListAdapter mAdapter;
    private ExpertItemEntityV2 mExpertEntity;
    private int mOrderType = -1;
    private static int mApplicationChannels = 10;
    private boolean isQuickDistribute = false;
    private String mPatientId;
    private long mHospitalId;
    private Integer mDepartmentId;
    private int mCityId;
    private IOrderApplyPresenter mOrderApplyPresenter;
    List<PatientDetailEntity.AttchMentEntity> caseAttachmentList;
    List<Integer> ids = new ArrayList<Integer>();
    private Long mOrderId;
    boolean isUpdateOrder;
    private OrderDetailEntity orderDetailEntity = null;
    private PatientEntity mPatientEntity;
    private static boolean isOutDement = false;
    @Autowired
    IUpdateVerStatus mUpdateVerStatus;
    private int mConsuStatus;
    private String mDiaName = "";
    private String mBirthDate;
    private String openCode;

    public static BHOrderApplyFragment newInstance(int mApplicationChannels) {
        ExpertItemEntityV2 entity = new ExpertItemEntityV2();
        if (mApplicationChannels == 50) {
            BHOrderApplyFragment.mApplicationChannels = 50;
            isOutDement = true;
            return BHOrderApplyFragment.newInstance(entity, 4, true);
        }
        if (mApplicationChannels == 30) {
            return BHOrderApplyFragment.newInstance(entity, 4, true);
        }
        return BHOrderApplyFragment.newInstance(entity, 4, 10);
    }

    public static BHOrderApplyFragment newInstance(ExpertItemEntityV2 mExpertEntity, int mOrderType, boolean isQuickDistribute) {
        BHOrderApplyFragment orderApplyFragment = new BHOrderApplyFragment();
        orderApplyFragment.mExpertEntity = mExpertEntity;
        orderApplyFragment.mOrderType = mOrderType;
        orderApplyFragment.isQuickDistribute = isQuickDistribute;
        Bundle bundle = new Bundle();
        bundle.putSerializable("mExpertEntity", (Serializable)mExpertEntity);
        bundle.putInt("mOrderType", mOrderType);
        if (isQuickDistribute && !isOutDement) {
            mApplicationChannels = 30;
        }
        bundle.putInt("mApplicationChannels", mApplicationChannels);
        bundle.putBoolean("isQuickDistribute", isQuickDistribute);
        orderApplyFragment.setArguments(bundle);
        return orderApplyFragment;
    }

    public static BHOrderApplyFragment newInstance(ExpertItemEntityV2 expertItemEntity, int orderType, int mApplicationChannels) {
        BHOrderApplyFragment orderApplyFragment = new BHOrderApplyFragment();
        orderApplyFragment.mExpertEntity = expertItemEntity;
        orderApplyFragment.mOrderType = orderType;
        BHOrderApplyFragment.mApplicationChannels = mApplicationChannels;
        Bundle bundle = new Bundle();
        bundle.putSerializable("mExpertEntity", (Serializable)expertItemEntity);
        bundle.putInt("mOrderType", orderType);
        bundle.putBoolean("isQuickDistribute", orderApplyFragment.isQuickDistribute);
        bundle.putInt("mApplicationChannels", mApplicationChannels);
        orderApplyFragment.setArguments(bundle);
        return orderApplyFragment;
    }

    public static BHOrderApplyFragment newInstance(OrderDetailEntity orderApplyEntity, boolean isUpdateOrder) {
        ExpertItemEntityV2 expertItemEntity = ExpertItemEntityV2.parse((OrderDetailEntity)orderApplyEntity);
        PatientEntity patientEntity = PatientEntity.parse((OrderDetailEntity)orderApplyEntity);
        BHOrderApplyFragment orderApplyFragment = new BHOrderApplyFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable("mExpertEntity", (Serializable)expertItemEntity);
        bundle.putInt("mOrderType", orderApplyEntity.getOrderType());
        bundle.putBoolean("isQuickDistribute", orderApplyFragment.isQuickDistribute);
        bundle.putInt("mApplicationChannels", orderApplyEntity.getOrderApplicationChannels());
        bundle.putSerializable("mPatientEntity", (Serializable)patientEntity);
        bundle.putBoolean("isUpdateOrder", isUpdateOrder);
        bundle.putSerializable("orderEntity", (Serializable)orderApplyEntity);
        orderApplyFragment.setArguments(bundle);
        return orderApplyFragment;
    }

    public void init() {
        this.mConsuStatus = this.mUpdateVerStatus.getConsuStatus(this.getMContext());
        if (this.mConsuStatus == 4626) {
            this.mDiaName = "\u4f1a\u8bca";
            this.mOrderApplyPresenter = new BHOrderApplyPresenter(this);
        } else if (this.mConsuStatus == 4627) {
            this.mDiaName = "\u95e8\u8bca";
            this.mOrderApplyPresenter = new ClcOrderPresent(this);
            this.vSelectPatient.setVisibility(8);
        }
        this.vToolTitleTextView.setText((CharSequence)(this.mDiaName + "\u7533\u8bf7\u5355"));
        this.vMudi.setHint((CharSequence)("\u8bf7\u8f93\u5165" + this.mDiaName + "\u76ee\u7684"));
        this.vDiaDirecLabelView.setText((CharSequence)(this.mDiaName + "\u76ee\u7684"));
        this.vDiaRequiDescView.setText((CharSequence)("\u586b\u5199\u60a8\u7684" + this.mDiaName + "\u8981\u6c42, \u7ba1\u7406\u5458\u5e2e\u60a8\u5feb\u901f\u5206\u914d\u5230\u5408\u9002\u7684" + this.mDiaName + "\u4e13\u5bb6"));
        Bundle arguments = this.getArguments();
        this.mOrderType = arguments.getInt("mOrderType");
        mApplicationChannels = arguments.getInt("mApplicationChannels");
        this.isQuickDistribute = arguments.getBoolean("isQuickDistribute");
        this.vDiaLabelView.setText((CharSequence)(this.mDiaName + "\u4e13\u5bb6"));
        this.vConsuTypeLabelView.setText((CharSequence)(this.mDiaName + "\u7c7b\u578b"));
        this.mExpertEntity = (ExpertItemEntityV2)arguments.getSerializable("mExpertEntity");
        PatientEntity mPatientEntity = null;
        if (this.isQuickDistribute) {
            this.mExpertEntity = null;
            this.mOrderType = -1;
        }
        if (arguments.getSerializable("mPatientEntity") != null) {
            mPatientEntity = (PatientEntity)arguments.getSerializable("mPatientEntity");
        }
        this.isUpdateOrder = arguments.getBoolean("isUpdateOrder", false);
        if (arguments.getSerializable("orderEntity") != null) {
            this.orderDetailEntity = (OrderDetailEntity)arguments.getSerializable("orderEntity");
        }
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext, 0, false));
        ArrayList arrayList = new ArrayList();
        this.mAdapter = new SelectImageListAdapter(arrayList);
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.showAddImage();
        this.vRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SelectImageDecoration(20));
        this.initAlertDialog();
        this.orderTypeSelectDialog = new OrderTypeSelectDialog(this.mContext);
        if (this.mExpertEntity != null) {
            this.mHospitalId = this.mExpertEntity.getHospitalId();
        }
        if (mPatientEntity != null) {
            this.fullPatientInfo(mPatientEntity);
        }
        if (this.orderDetailEntity != null) {
            this.fullOrderInfo();
        }
        this.styleSwitch();
        this.dispatchEvent();
        if (this.mConsuStatus == 4627) {
            this.vInitDiaStartView.setVisibility(8);
            this.vConsuDirectStartView.setVisibility(8);
            this.vMustUploadCaseFile.setVisibility(8);
        }
    }

    private void fullOrderInfo() {
        this.vMainSuit.setText((CharSequence)this.orderDetailEntity.getPatCaseMainSuit());
        this.vPresentHistory.setText((CharSequence)this.orderDetailEntity.getPresentHistory());
        this.vPerHistory.setText((CharSequence)this.orderDetailEntity.getPastHistory());
        this.vFamilyHistory.setText((CharSequence)this.orderDetailEntity.getPatCaseFamilyHistory());
        this.vMedicalHistory.setText((CharSequence)this.orderDetailEntity.getPatCaseMedicationHistory());
        this.vResult.setText((CharSequence)this.orderDetailEntity.getPatPrimaryDiagno());
        this.vMudi.setText((CharSequence)this.orderDetailEntity.getPatCaseConsultAim());
    }

    private void styleSwitch() {
        Log.i((String)TAG, (String)("styleSwitch: isQuickDistribute:" + this.isQuickDistribute + ", isUpdateOrder:" + this.isUpdateOrder));
        if (this.isQuickDistribute && !this.isUpdateOrder) {
            this.vExpertInfo.setVisibility(4);
            this.vQuickDistribute.setVisibility(0);
            this.vQucikDistributeHeadLayout.setVisibility(0);
        } else {
            this.vExpertInfo.setVisibility(0);
            this.vQuickDistribute.setVisibility(4);
            this.vQucikDistributeHeadLayout.setVisibility(8);
            this.fullExpertInfo(this.mExpertEntity);
        }
        if (!BuildConfig.isMustUploadCaseFile.booleanValue()) {
            this.vMustUploadCaseFile.setVisibility(8);
        }
        if (this.isUpdateOrder) {
            this.vAddPatient.setVisibility(8);
            this.vSelectPatient.setVisibility(8);
            this.vChangeExpert.setVisibility(8);
        }
        this.vSelhosStartView.setVisibility(8);
        if (this.isQuickDistribute && this.mConsuStatus == 4627) {
            this.vAreaLabelView.setVisibility(8);
            this.vAreaLabelView.setVisibility(8);
            this.vConsuTypeView.setVisibility(8);
            this.vOrderTypeSelect.setVisibility(8);
            this.vAreaSelect.setVisibility(8);
            this.vExpertInfoLayout.setVisibility(4);
            this.vDeptLabelView.setVisibility(8);
            this.vConsuTypeLabelView.setVisibility(8);
            this.vExpertNameLabelView.setVisibility(8);
            this.vExpertName.setVisibility(8);
            this.vExpertDepartment.setVisibility(8);
            this.vOrderType.setVisibility(8);
            this.vSelhosStartView.setVisibility(0);
        }
    }

    private void initAlertDialog() {
        String title = this.mDiaName + "\u7533\u8bf7";
        this.vAlertDialog = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)title).setMessage((CharSequence)this.getContext().getResources().getString(R.string.exit_applicaiton_tips)).setPositiveButton((CharSequence)"\u53d6\u6d88", (dialog, which) -> dialog.dismiss()).setNegativeButton((CharSequence)this.getContext().getResources().getString(R.string.ok_exit), (dialog, which) -> {
            if (this.isQuickDistribute) {
                this._mActivity.finish();
            } else {
                this.pop();
            }
        }).create();
    }

    private void dispatchEvent() {
        this.orderTypeSelectDialog.setListener((position, value) -> {
            if (value == 4) {
                this.vOrderTypeSelect.setText((CharSequence)this.getContext().getResources().getString(R.string.video));
            } else if (value == 5) {
                this.vOrderTypeSelect.setText((CharSequence)this.getContext().getResources().getString(R.string.graphic));
            }
            this.mOrderType = value;
        });
        this.vHospitalSelect.setOnClickListener(v -> {
            if (ByConstant.APPLY_CHANNEL == 50) {
                this.startForResult((ISupportFragment)UnionHospitalListFragment.newInstance(this.mCityId + "", false), 3);
            } else {
                this.startForResult((ISupportFragment)SampleHospitalListFragment.newInstance(this.mCityId + "", false), 3);
            }
        });
        this.vAreaSelect.setOnClickListener(v -> this.startForResult((ISupportFragment)new CityFragment(), 1));
        this.vDepartmentSelect.setOnClickListener(v -> this.startForResult((ISupportFragment)DepartmentFilterFragment.newInstance(this.mHospitalId, this.openCode), 2));
        this.vOrderTypeSelect.setOnClickListener(v -> this.orderTypeSelectDialog.show());
        this.mAdapter.setOnItemChildClickListener(new SelectImageListAdapter.OnItemChildClickListener(){

            public void onDelete(int position) {
                if (BHOrderApplyFragment.this.caseAttachmentList == null) {
                    Log.i((String)BHOrderApplyFragment.TAG, (String)"onDelete: caseAttachmentList is null");
                    return;
                }
                if (position >= BHOrderApplyFragment.this.caseAttachmentList.size()) {
                    Log.i((String)BHOrderApplyFragment.TAG, (String)("onDelete: caseAttachmentList size:" + BHOrderApplyFragment.this.caseAttachmentList.size() + ", position:" + position));
                    return;
                }
                if (BHOrderApplyFragment.this.caseAttachmentList != null && BHOrderApplyFragment.this.caseAttachmentList.size() > 0) {
                    BHOrderApplyFragment.this.caseAttachmentList.remove(position);
                }
                if (BHOrderApplyFragment.this.mAdapter.getImageDatas() != null && BHOrderApplyFragment.this.mAdapter.getImageDatas().size() > 0) {
                    BHOrderApplyFragment.this.mAdapter.getImageDatas().remove(position);
                }
                if (BHOrderApplyFragment.this.ids != null && BHOrderApplyFragment.this.ids.size() > 0) {
                    BHOrderApplyFragment.this.ids.remove(position);
                }
                BHOrderApplyFragment.this.mAdapter.notifyDataSetChanged();
            }

            public void onLook(int position) {
                Bundle bundle = new Bundle();
                List imageDatas = BHOrderApplyFragment.this.mAdapter.getImageDatas();
                ArrayList<String> images = new ArrayList<String>();
                for (int i = 0; i < imageDatas.size(); ++i) {
                    String s = (String)imageDatas.get(i);
                    if (StringUtils.isEmpty((CharSequence)s)) continue;
                    images.add(s);
                }
                bundle.putStringArrayList("images", images);
                bundle.putInt("position", position);
                SkipUtil.skipActivity((Activity)BHOrderApplyFragment.this._mActivity, MulitImageShowActivity.class, bundle);
            }

            public void onAdd() {
                BottomSelectDialog bottomSelectDialog = new BottomSelectDialog(BHOrderApplyFragment.this.mContext, 3);
                BHOrderApplyFragment.this.requestEachPermission(new String[]{"android.permission.CAMERA"}).subscribe(permission2 -> {
                    if (permission2.granted) {
                        bottomSelectDialog.show();
                    } else {
                        ToastUtils.showShort((CharSequence)(BHOrderApplyFragment.this.getContext().getResources().getString(R.string.give_permissions_tips) + permission2.name));
                    }
                });
                bottomSelectDialog.setImageSelectListener(new BottomSelectDialog.ImageSelectListener(){

                    public void onImageList(List<String> strings) {
                        BHOrderApplyFragment.this.mAdapter.addImageData(strings);
                    }
                });
            }
        });
        this.vChangeExpert.setOnClickListener(v -> {
            this.vAlertDialog.show();
            if (mApplicationChannels == 10) {
                this.popTo(SelectHospitalFragment.class, false);
            } else if (mApplicationChannels == 20) {
                this.popTo(FamousExpertFragment.class, false);
            }
        });
        this.vAddPatient.setOnClickListener(v -> this.start((ISupportFragment)AddPatientFragment.newInstance()));
        this.vSelectPatient.setOnClickListener(v -> this.start((ISupportFragment)new NewApplyFragment()));
        this.vCommit.setOnClickListener(v -> {
            if (this.mOrderApplyPresenter == null) {
                return;
            }
            if (this.isUpdateOrder) {
                UpdateCaseEntity caseEntity = this.gatherCaseData();
                this.mOrderApplyPresenter.updateOrderCase(caseEntity, this.mAdapter.getImageDatas(), this.ids);
            } else {
                OrderApplyEntity orderApplyEntity = null;
                boolean ischeck = false;
                if (this.mConsuStatus == 4626) {
                    orderApplyEntity = this.gatherData();
                    ischeck = this.checkGroupOrderFields(orderApplyEntity);
                } else if (this.mConsuStatus == 4627) {
                    orderApplyEntity = this.clcGatherData();
                    orderApplyEntity.setType(6);
                    Long docId = -1L;
                    String doctorId = VertifyDataUtil.getInstance((Context)this.getMContext()).getDoctorId();
                    if (TextUtils.isEmpty((CharSequence)doctorId)) {
                        return;
                    }
                    if (StringUtil.isNumeric((String)doctorId)) {
                        docId = Long.parseLong(doctorId);
                    }
                    orderApplyEntity.setDoctorId(docId);
                    ischeck = this.checkOutdeptFields(orderApplyEntity);
                }
                if (ischeck) {
                    this.mOrderApplyPresenter.applyOrder(orderApplyEntity, this.mAdapter.getImageDatas(), this.ids);
                }
            }
        });
    }

    private UpdateCaseEntity gatherCaseData() {
        UpdateCaseEntity caseEntity = new UpdateCaseEntity();
        caseEntity.setDcmPackUrl(this.orderDetailEntity.getDcmPackUrl());
        caseEntity.setDcmFileUrl(this.orderDetailEntity.getDcmFileUrl());
        caseEntity.setConsultAim(this.vMudi.getText().toString());
        caseEntity.setFamilyHistory(this.vFamilyHistory.getText().toString());
        caseEntity.setMainSuit(this.vMainSuit.getText().toString());
        caseEntity.setMedicationHistory(this.vMedicalHistory.getText().toString());
        caseEntity.setOrderId(this.orderDetailEntity.getOrderId());
        caseEntity.setPastHistory(this.vPerHistory.getText().toString());
        caseEntity.setPresentHistory(this.vPresentHistory.getText().toString());
        caseEntity.setPrimaryDiagno(this.vResult.getText().toString());
        return caseEntity;
    }

    private OrderApplyEntity clcGatherData() {
        OrderApplyEntity orderApplyEntity = new OrderApplyEntity();
        orderApplyEntity.setApplicationChannels(mApplicationChannels);
        orderApplyEntity.setDeptType(1);
        orderApplyEntity.setDeptId(this.mDepartmentId);
        orderApplyEntity.setExpertHospitalId((int)this.mHospitalId);
        orderApplyEntity.setOrderId(this.mOrderId);
        orderApplyEntity.setType(this.mOrderType);
        orderApplyEntity.setPatientId(this.mPatientId);
        orderApplyEntity.setMainSuit(this.vMainSuit.getText().toString());
        orderApplyEntity.setConsultAim(this.vMudi.getText().toString());
        orderApplyEntity.setPrimaryDiagno(this.vResult.getText().toString());
        orderApplyEntity.setInitiatorType("2");
        orderApplyEntity.setMobileNumber(this.vPatientPhone.getText().toString());
        orderApplyEntity.setAge(this.mBirthDate);
        orderApplyEntity.setPatientName(this.vPatientName.getText().toString());
        orderApplyEntity.setSex(this.vPatientSex.getText().toString().equals("\u7537") ? 1 : 2);
        orderApplyEntity.setIdcard(this.vPatientCard.getText().toString());
        orderApplyEntity.setFamilyHistory(this.vFamilyHistory.getText().toString());
        orderApplyEntity.setMedicationHistory(this.vMedicalHistory.getText().toString());
        orderApplyEntity.setPastHistory(this.vPerHistory.getText().toString());
        orderApplyEntity.setPresentHistory(this.vPresentHistory.getText().toString());
        if (this.mExpertEntity != null) {
            orderApplyEntity.setExpertId(Long.valueOf(Long.parseLong(this.mExpertEntity.getDoctorId() + "")));
            orderApplyEntity.setDeptId(this.mExpertEntity.getStdSecondDeptId());
            orderApplyEntity.setExpertHospitalId(this.mExpertEntity.getHospitalId());
            orderApplyEntity.setExpertDepId(Integer.valueOf(this.mExpertEntity.getHospitalDeptId()));
        }
        return orderApplyEntity;
    }

    private OrderApplyEntity gatherData() {
        OrderApplyEntity orderApplyEntity = new OrderApplyEntity();
        orderApplyEntity.setApplicationChannels(mApplicationChannels);
        if (mApplicationChannels == 30 && this.mHospitalId == 0L || mApplicationChannels == 20) {
            orderApplyEntity.setDeptType(2);
            if (this.mExpertEntity != null) {
                orderApplyEntity.setExpertId(Long.valueOf(Long.parseLong(this.mExpertEntity.getDoctorId() + "")));
                orderApplyEntity.setDeptId(1);
                orderApplyEntity.setExpertDepId(Integer.valueOf(this.mExpertEntity.getHospitalDeptId()));
                orderApplyEntity.setExpertHospitalId(this.mExpertEntity.getHospitalId());
            } else {
                orderApplyEntity.setDeptId(this.mDepartmentId);
            }
        } else {
            orderApplyEntity.setDeptType(1);
            if (this.mExpertEntity != null) {
                orderApplyEntity.setExpertId(Long.valueOf(Long.parseLong(this.mExpertEntity.getDoctorId() + "")));
                orderApplyEntity.setDeptId(this.mExpertEntity.getStdSecondDeptId());
                orderApplyEntity.setExpertHospitalId(this.mExpertEntity.getHospitalId());
                orderApplyEntity.setExpertDepId(Integer.valueOf(this.mExpertEntity.getHospitalDeptId()));
            } else {
                orderApplyEntity.setDeptId(this.mDepartmentId);
            }
        }
        orderApplyEntity.setOrderId(this.mOrderId);
        if (this.mOrderId == null || mApplicationChannels != 30) {
            // empty if block
        }
        if (mApplicationChannels == 30) {
            orderApplyEntity.setExpertHospitalId((int)this.mHospitalId);
        }
        orderApplyEntity.setType(this.mOrderType);
        orderApplyEntity.setPatientId(this.mPatientId);
        orderApplyEntity.setMainSuit(this.vMainSuit.getText().toString());
        orderApplyEntity.setConsultAim(this.vMudi.getText().toString());
        orderApplyEntity.setPrimaryDiagno(this.vResult.getText().toString());
        orderApplyEntity.setInitiatorType("2");
        orderApplyEntity.setMobileNumber(this.vPatientPhone.getText().toString());
        orderApplyEntity.setAge(this.mBirthDate);
        orderApplyEntity.setPatientName(this.vPatientName.getText().toString());
        orderApplyEntity.setSex(this.vPatientSex.getText().toString().equals("\u7537") ? 1 : 2);
        orderApplyEntity.setIdcard(this.vPatientCard.getText().toString());
        orderApplyEntity.setFamilyHistory(this.vFamilyHistory.getText().toString());
        orderApplyEntity.setMedicationHistory(this.vMedicalHistory.getText().toString());
        orderApplyEntity.setPastHistory(this.vPerHistory.getText().toString());
        orderApplyEntity.setPresentHistory(this.vPresentHistory.getText().toString());
        return orderApplyEntity;
    }

    private boolean checkOutdeptFields(OrderApplyEntity orderApplyEntity) {
        if (this.mPatientId == null) {
            ToastUtils.showShort((CharSequence)"\u9700\u8981\u9009\u62e9\u60a3\u8005");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)orderApplyEntity.getMainSuit())) {
            ToastUtils.showShort((CharSequence)Objects.requireNonNull(this.getContext()).getResources().getString(R.string.complained_not_null_tips));
            return false;
        }
        return true;
    }

    private boolean checkGroupOrderFields(OrderApplyEntity orderApplyEntity) {
        if (StringUtils.isEmpty((CharSequence)orderApplyEntity.getMainSuit())) {
            ToastUtils.showShort((CharSequence)Objects.requireNonNull(this.getContext()).getResources().getString(R.string.complained_not_null_tips));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)orderApplyEntity.getConsultAim())) {
            ToastUtils.showShort((CharSequence)Objects.requireNonNull(this.getContext()).getResources().getString(R.string.consultation_not_null_tips));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)orderApplyEntity.getPrimaryDiagno())) {
            ToastUtils.showShort((CharSequence)Objects.requireNonNull(this.getContext()).getResources().getString(R.string.preliminary_diagnosis_not_null_tips));
            return false;
        }
        if (this.mPatientId == null) {
            ToastUtils.showShort((CharSequence)"\u9700\u8981\u9009\u62e9\u60a3\u8005");
            return false;
        }
        if (this.mOrderType == -1) {
            ToastUtils.showShort((CharSequence)"\u8bf7\u9009\u62e9\u4f1a\u8bca\u7c7b\u578b");
            return false;
        }
        return true;
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_order_apply;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.vAlertDialog.show();
    }

    @Override
    public void fullExpertInfo(ExpertItemEntity expertItemEntity) {
    }

    @Override
    public void fullExpertInfo(ExpertItemEntityV2 expert) {
        if (expert != null) {
            this.vExpertName.setText((CharSequence)(expert.getName() + ""));
            this.vExpertLevel.setText((CharSequence)(expert.getProfession() + ""));
            this.vExpertHospital.setText((CharSequence)(expert.getRegHospitalName() + ""));
            this.vExpertDepartment.setText((CharSequence)(expert.getHospitalDeptName() + ""));
        }
        if (this.mOrderType == 4) {
            this.vOrderType.setText((CharSequence)this.getContext().getResources().getString(R.string.video));
        } else if (this.mOrderType == 5) {
            this.vOrderType.setText((CharSequence)this.getContext().getResources().getString(R.string.graphic));
        }
    }

    @Override
    @Subscribe(sticky=true)
    public void fullPatientInfo(PatientEntity patientEntity) {
        EventBus.getDefault().removeStickyEvent((Object)patientEntity);
        this.mPatientEntity = patientEntity;
        PatientEntityV2 parse = PatientEntityV2.parse((PatientEntity)patientEntity);
        this.mPatientId = patientEntity.getId() + "";
        this.vPatientName.setText((CharSequence)patientEntity.getName());
        patientEntity.setHospitalId((long)VertifyDataUtil.getInstance((Context)this.mContext).getLoginData().getHospitalId());
        int patientAge = parse.getAge();
        this.mBirthDate = parse.getBirthdate();
        this.vPatientAge.setText((CharSequence)(patientAge + "\u5c81"));
        this.vPatientCard.setText((CharSequence)(patientEntity.getIdCard() + ""));
        this.vPatientPhone.setText((CharSequence)(patientEntity.getMobileNumber() + ""));
        int gender = patientEntity.getGender();
        this.vPatientSex.setText((CharSequence)(gender == 1 ? this.getContext().getResources().getString(R.string.sex_boy) : this.getContext().getResources().getString(R.string.sex_girl)));
        this.vMainSuit.setText((CharSequence)patientEntity.getPatCaseMainSuit());
        this.mOrderId = patientEntity.getOrderId();
        this.caseAttachmentList = patientEntity.getCaseAttachmentList();
        ArrayList<String> images = new ArrayList<String>();
        if (this.caseAttachmentList == null || this.caseAttachmentList.size() <= 0) {
            this.mAdapter.setImageNewData(images);
            return;
        }
        if (this.caseAttachmentList != null && this.caseAttachmentList.size() > 0) {
            for (PatientDetailEntity.AttchMentEntity entity : this.caseAttachmentList) {
                images.add(entity.getUrl());
                this.ids.add(entity.getId());
            }
        }
        this.mAdapter.setImageNewData(images);
    }

    public void onFragmentResult(int requestCode, int resultCode, Bundle data) {
        super.onFragmentResult(requestCode, resultCode, data);
        if (data != null) {
            if (requestCode == 1) {
                this.mCityId = data.getInt("cityCode");
                this.vAreaSelect.setText((CharSequence)data.getString("cityName"));
                this.mHospitalId = 0L;
                this.vHospitalSelect.setText((CharSequence)"\u8bf7\u9009\u62e9");
                this.mDepartmentId = 0;
                this.vDepartmentSelect.setText((CharSequence)"\u8bf7\u9009\u62e9");
            } else if (requestCode == 2) {
                this.mDepartmentId = data.getInt("departmentId");
                this.vDepartmentSelect.setText((CharSequence)data.getString("departmentName"));
            } else if (requestCode == 3) {
                this.mHospitalId = data.getInt("hospitalId");
                this.vHospitalSelect.setText((CharSequence)data.getString("hospitalName"));
                this.openCode = data.getString("openCode");
                this.mDepartmentId = 0;
                this.vDepartmentSelect.setText((CharSequence)"\u8bf7\u9009\u62e9");
            }
        }
    }

    @Override
    public void toSign(long orderId, String viewId, String doctorHosName, int applicationChannels, int initiatorType) {
        if (initiatorType == 1) {
            this.start((ISupportFragment)OrderApplySuccessFragment.newInstance(viewId, applicationChannels));
        } else {
            this.start((ISupportFragment)OrderApplySignFragment.newInstance(orderId, viewId, doctorHosName, applicationChannels));
        }
    }

    @Override
    public void toPatientCaseViewAndUpdate() {
        EventBus.getDefault().post((Object)new IPatientCaseUpdateEvent(){});
        this.pop();
    }
}

