/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.fragment.v2;

import android.content.Context;
import android.os.Bundle;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.byh.entity.v2.ExpertItemEntityV2;
import com.kangxin.common.byh.fragment.ExpertCardFragment;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.byh.widget.BottomSelectDialog;
import com.kangxin.doctor.worktable.ExpertListFragment;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.v2.BHExpertListAdapter;
import com.kangxin.doctor.worktable.fragment.v2.BHOrderApplyFragment;
import com.kangxin.doctor.worktable.presenter.IExpertListPresenter;
import com.kangxin.doctor.worktable.presenter.clc.ClcExpertListPresent;
import com.kangxin.doctor.worktable.presenter.impl2.ExpertListPresenter;
import java.util.ArrayList;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.SupportFragment;

@Route(path="/expert_list/famous")
public class ExpertListFragmentBH
extends ExpertListFragment {
    protected BaseQuickAdapter<ExpertItemEntityV2, ? extends BaseViewHolder> mAdapter;
    protected ArrayList<ExpertItemEntityV2> mExpertList = new ArrayList();
    protected IExpertListPresenter mExpertListPresenter = new ExpertListPresenter(this);
    @Autowired
    IUpdateVerStatus mUpdateVerStatus;
    private int mConsuStatus;

    public static ExpertListFragmentBH newInstance(boolean isFamousExpert) {
        return ExpertListFragmentBH.newInstance(isFamousExpert, "", "", 0, "");
    }

    @Override
    public void init() {
        super.init();
        this.mConsuStatus = this.mUpdateVerStatus.getConsuStatus(this.getMContext());
        if (this.mConsuStatus == 4626) {
            this.mExpertListPresenter = new ExpertListPresenter(this);
        } else if (this.mConsuStatus == 4627) {
            this.mExpertListPresenter = new ClcExpertListPresent(this);
        }
    }

    public static ExpertListFragmentBH newInstance(int hospitalId, long departmentId) {
        ExpertListFragmentBH expertListFragment = new ExpertListFragmentBH();
        expertListFragment.departmentId = departmentId;
        expertListFragment.hospitalId = hospitalId;
        Bundle bundle = new Bundle();
        bundle.putInt("hospitalId", hospitalId);
        bundle.putLong("departmentId", departmentId);
        bundle.putBoolean("isFamousExpert", false);
        bundle.putString("mCityCode", "");
        bundle.putString("mDepartmentCode", "");
        bundle.putInt("mExpertLevel", 104);
        bundle.putString("mOrderType", "52120");
        expertListFragment.setArguments(bundle);
        return expertListFragment;
    }

    public static ExpertListFragmentBH newInstance(boolean isFamousExpert, String mCityCode, String mDepartmentCode, int mExpertLevel, String mOrderType) {
        ExpertListFragmentBH expertListFragment = new ExpertListFragmentBH();
        expertListFragment.isFamousExpert = isFamousExpert;
        expertListFragment.mCityCode = mCityCode;
        expertListFragment.mDepartmentCode = mDepartmentCode;
        expertListFragment.mExpertLevel = mExpertLevel;
        expertListFragment.mOrderType = mOrderType;
        Bundle bundle = new Bundle();
        bundle.putInt("hospitalId", 0);
        bundle.putInt("departmentId", 0);
        bundle.putBoolean("isFamousExpert", isFamousExpert);
        bundle.putString("mCityCode", mCityCode);
        bundle.putString("mDepartmentCode", mDepartmentCode);
        bundle.putInt("mExpertLevel", mExpertLevel);
        bundle.putString("mOrderType", mOrderType);
        return expertListFragment;
    }

    @Override
    protected void flushOrLoad(boolean isGetMore) {
        if (this.isFamousExpert) {
            this.mExpertListPresenter.getFilterExpertList(isGetMore, this.mSearchKey, this.mCityCode, this.mDepartmentCode, this.mExpertLevel, this.mOrderType, 1, 2);
        } else {
            this.mExpertListPresenter.getExpertList(isGetMore, this.mSearchKey, this.hospitalId, this.departmentId, 2);
        }
    }

    @Override
    protected void dispatchEvent() {
        if (this.mAdapter == null) {
            this.mAdapter = this.getBaseQuickAdapter();
        }
        this.mAdapter.setOnItemChildClickListener((adapter, view, position) -> {
            int i = view.getId();
            if (i == R.id.vApply) {
                ExpertItemEntityV2 expertItemEntity = (ExpertItemEntityV2)this.mAdapter.getData().get(position);
                String doctorId = VertifyDataUtil.getInstance((Context)this.mContext).getDoctorId();
                if (expertItemEntity != null && !doctorId.equals(expertItemEntity.getDoctorId() + "")) {
                    this.openTypeDialog(expertItemEntity.getDoctorId(), expertItemEntity);
                } else {
                    ToastUtils.showShort((CharSequence)"\u4e0d\u80fd\u5411\u81ea\u5df1\u53d1\u8d77\u4f1a\u8bca");
                }
            }
        });
        this.mAdapter.setOnItemClickListener((adapter, view, position) -> {
            ExpertItemEntityV2 expertItemEntity = (ExpertItemEntityV2)this.mAdapter.getData().get(position);
            if (expertItemEntity != null) {
                Double remotePrice;
                boolean isOnlyShow = false;
                if (expertItemEntity.getGraphicPrice() == null) {
                    expertItemEntity.setGraphicPrice(Double.valueOf(0.0));
                }
                if (expertItemEntity.getVideoPrice() == null) {
                    expertItemEntity.setVideoPrice(Double.valueOf(0.0));
                }
                if ((remotePrice = expertItemEntity.getRemotelcPrice()) == null) {
                    ((SupportFragment)this.getParentFragment()).start((ISupportFragment)ExpertCardFragment.newInstance((long)expertItemEntity.getDoctorId(), (int)this.applicationChannel, (double)expertItemEntity.getVideoPrice(), (double)expertItemEntity.getGraphicPrice(), (boolean)expertItemEntity.isOpenVideoService(), (boolean)expertItemEntity.isOpenGraphService(), (boolean)isOnlyShow));
                } else {
                    ((SupportFragment)this.getParentFragment()).start((ISupportFragment)ExpertCardFragment.newInstance((long)expertItemEntity.getDoctorId(), (int)this.applicationChannel, (double)expertItemEntity.getVideoPrice(), (double)expertItemEntity.getGraphicPrice(), (double)expertItemEntity.getRemotelcPrice(), (boolean)expertItemEntity.isOpenVideoService(), (boolean)expertItemEntity.isOpenGraphService(), (boolean)isOnlyShow));
                }
            } else {
                LogUtils.e((Object[])new Object[]{"\u9884\u8ba1\u7a7a\u6307\u9488\u5f02\u5e38"});
            }
        });
    }

    protected void openTypeDialog(long doctorId, final ExpertItemEntityV2 expertItemEntity) {
        final BottomSelectDialog bottomSelectDialog = new BottomSelectDialog(this.mContext, 2);
        bottomSelectDialog.show();
        bottomSelectDialog.setListener(new BottomSelectDialog.OptionsOnClickListener(){

            public void onOptionSelected(int position, int value) {
                if (position == 1) {
                    if (expertItemEntity.getVideoStatus() != null && expertItemEntity.getVideoStatus() == 1) {
                        assert (ExpertListFragmentBH.this.getParentFragment() != null);
                        ((SupportFragment)ExpertListFragmentBH.this.getParentFragment()).start((ISupportFragment)BHOrderApplyFragment.newInstance(expertItemEntity, 4, ExpertListFragmentBH.this.applicationChannel));
                    } else {
                        ToastUtils.showShort((CharSequence)ExpertListFragmentBH.this.getContext().getResources().getString(R.string.video_service_not_open_tips));
                    }
                } else if (position == 2) {
                    if (expertItemEntity.getGraphicStatus() != null && expertItemEntity.getGraphicStatus() == 1) {
                        assert (ExpertListFragmentBH.this.getParentFragment() != null);
                        ((SupportFragment)ExpertListFragmentBH.this.getParentFragment()).start((ISupportFragment)BHOrderApplyFragment.newInstance(expertItemEntity, 5, ExpertListFragmentBH.this.applicationChannel));
                    } else {
                        ToastUtils.showShort((CharSequence)ExpertListFragmentBH.this.getContext().getResources().getString(R.string.graphic_Service_not_open_tips));
                    }
                } else {
                    bottomSelectDialog.dismiss();
                }
            }
        });
    }

    protected BaseQuickAdapter getBaseQuickAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new BHExpertListAdapter(this.isFamousExpert, this.mExpertList);
            return this.mAdapter;
        }
        return this.mAdapter;
    }
}

