/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.fragment.v2;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import butterknife.OnClick;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.VerClickItemDispatch;
import com.kangxin.common.byh.event.VertifyClickListener;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.util.StringUtil;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.activity.OrderListActivity;
import com.kangxin.doctor.worktable.adapter.v2.MineCenterAdapterV2;
import com.kangxin.doctor.worktable.entity.v2.MineCenterItemV2;
import com.kangxin.doctor.worktable.event.MineClickItemDispatch;
import com.kangxin.doctor.worktable.event.WorkTabEvent;
import com.kangxin.doctor.worktable.util.SkipUtil;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

@Route(path="/mincenter/minecenter_fragment_v2")
public class MineCenterFragmentV2
extends BaseFragment
implements IToolView,
BaseQuickAdapter.OnItemClickListener {
    private static final String TAG = "MineCenterFragmentV2";
    @BindView(value=2131428171)
    ImageView vHeadShotImg;
    @BindView(value=2131428134)
    TextView vDocName;
    @BindView(value=2131428133)
    TextView vDocLevel;
    @BindView(value=2131428182)
    TextView vHospitalName;
    @BindView(value=2131428173)
    TextView vHospitalDep;
    @BindView(value=2131427646)
    ImageView vIconVerFlagView;
    @BindView(value=2131428249)
    RecyclerView vRecyclerView;
    BaseQuickAdapter mAdapter = new MineCenterAdapterV2();
    private VerClickItemDispatch mineClickItemDispatch;
    @Autowired
    IUpdateVerStatus mUpdateVerStatus;

    public void init() {
        this.mineClickItemDispatch = new MineClickItemDispatch();
        this.mineClickItemDispatch.registerDispatch(this.getContext());
        this.vToolLeftImage.setVisibility(8);
        this.vToolTitleTextView.setText((CharSequence)"\u6211\u7684");
        this.vToolRightView.setImageResource(R.drawable.wktab_ic_erweima);
        this.vToolRightView.setOnClickListener((View.OnClickListener)new VertifyClickListener(){

            protected void onClickOk(View view) {
                MineCenterFragmentV2.this.mineClickItemDispatch.dispatchStatus(true, () -> ARouter.getInstance().build("/minecard/BusinessCardSharingActivity").navigation());
            }
        });
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.mAdapter.setOnItemClickListener((BaseQuickAdapter.OnItemClickListener)this);
        this.vRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.bindDataToViews();
    }

    private void bindDataToViews() {
        int status = VertifyDataUtil.getInstance((Context)this.getContext()).getAcountStatus();
        if (status == 5) {
            this.vIconVerFlagView.setVisibility(0);
        } else {
            this.vIconVerFlagView.setVisibility(8);
        }
        if (VertifyDataUtil.getInstance((Context)this.getContext()).hasLogin()) {
            this.loginOkVisible();
            ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance((Context)this.getContext()).getUserInfo();
            if (userInfoVOBean == null) {
                return;
            }
            Pretty.create().loadImage(userInfoVOBean.getHeadPortrait()).placeholder(R.drawable.ic_byh_comm_header).err(R.drawable.ic_byh_comm_header).centerCrop().transform((Transformation)new RoundedCorners(4)).into(this.vHeadShotImg);
            Log.i((String)TAG, (String)("bindDataToViews: name:" + userInfoVOBean.getName()));
            Log.i((String)TAG, (String)("bindDataToViews: profess:" + userInfoVOBean.getProfession()));
            Log.i((String)TAG, (String)("bindDataToViews: getHosName:" + userInfoVOBean.getHospitalName()));
            Log.i((String)TAG, (String)("bindDataToViews: hosDep:" + userInfoVOBean.getHospitalDeptName()));
            this.vDocName.setText((CharSequence)userInfoVOBean.getName());
            this.vDocLevel.setText((CharSequence)userInfoVOBean.getProfession());
            this.vHospitalName.setText((CharSequence)userInfoVOBean.getHospitalName());
            String hosDeptName = StringUtil.changeSubText((String)userInfoVOBean.getHospitalDeptName(), (int)12);
            this.vHospitalDep.setText((CharSequence)hosDeptName);
        } else {
            this.loginErrDesc("\u672a\u767b\u5f55", "\u767b\u5f55\u540e\u53ef\u4ee5\u4f53\u9a8c\u66f4\u591a\u670d\u52a1");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveJobTitle(WorkTabEvent.UpdateUserInfo updateUserInfo) {
        this.bindDataToViews();
    }

    @OnClick(value={2131427428})
    public void clickHeaderView() {
        if (VertifyDataUtil.getInstance((Context)this.getContext()).hasLogin()) {
            ARouter.getInstance().build("/mineperson/PersonalInformationActivity").navigation();
        } else {
            ARouter.getInstance().build("/verification/LoginActivity").navigation();
        }
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_mine_center;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void updatePersonInfoEvent(ByhCommEvent.UpdatePersonalCenter updatePersonalCenter) {
        switch (updatePersonalCenter.getStatus()) {
            case 4096: {
                this.loginErrDesc("\u6b63\u5728\u62c9\u53d6\u4e2a\u4eba\u4fe1\u606f", "");
                Log.i((String)TAG, (String)"updatePersonInfoEvent: REQUESTINTG_STATUS");
                break;
            }
            case 4097: {
                Log.i((String)TAG, (String)"updatePersonInfoEvent: REQUESTINTG_SUCCESS");
                this.bindDataToViews();
                break;
            }
            case 4098: {
                this.loginErrDesc("\u672a\u83b7\u53d6\u5230\u4e2a\u4eba\u4fe1\u606f", "");
                Log.i((String)TAG, (String)"updatePersonInfoEvent: REQUESTINTG_ERROR");
            }
        }
    }

    private void loginErrDesc(String desc, String subDesc) {
        this.vDocName.setText((CharSequence)desc);
        this.vDocLevel.setVisibility(8);
        this.vHospitalName.setText((CharSequence)subDesc);
        this.vHospitalDep.setVisibility(8);
        this.vIconVerFlagView.setVisibility(8);
    }

    private void loginOkVisible() {
        this.vDocLevel.setVisibility(0);
        this.vHospitalDep.setVisibility(0);
    }

    public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
        MineCenterItemV2 mineCenterItemV2 = (MineCenterItemV2)adapter.getItem(position);
        switch (mineCenterItemV2.getItemType()) {
            case 1: {
                this.mineClickItemDispatch.dispatchStatus(true, () -> ARouter.getInstance().build("/hx/reactnative").withString("path", "/my/record/list").navigation());
                break;
            }
            case 3: {
                this.mineClickItemDispatch.dispatchStatus(true, () -> ARouter.getInstance().build("/hx/reactnative").withString("path", "/my/serviceorder/list").navigation());
                break;
            }
            case 10: {
                this.mineClickItemDispatch.dispatchStatus(true, () -> ARouter.getInstance().build("/hx/reactnative").withString("path", "/my/service/list").navigation());
                break;
            }
            case 2: {
                this.mUpdateVerStatus.changeConsuStatus(this.getContext(), 4626);
                this.mineClickItemDispatch.dispatchStatus(true, () -> SkipUtil.skipActivity((Activity)this.getActivity(), OrderListActivity.class));
                break;
            }
            case 9: {
                ARouter.getInstance().build("/seting/AboutActivity").navigation();
                break;
            }
            case 6: {
                ARouter.getInstance().build("/minecontact/ContactUsActivity").navigation();
                break;
            }
            case 7: {
                ARouter.getInstance().build("/minefeedback/FeedbackInfoActivity").navigation();
                break;
            }
            case 4: {
                this.mineClickItemDispatch.dispatchStatus(true, () -> ARouter.getInstance().build("/acount/AccountManagerCountryActivity").navigation());
                break;
            }
            case 5: {
                this.mineClickItemDispatch.dispatchStatus(true, () -> {
                    Bundle bundle = new Bundle();
                    LoginSuccess.DoctorLoginInfoBean doctorLoginInfoBean = VertifyDataUtil.getInstance((Context)this.getActivity().getBaseContext()).getDoctorLoginInfo();
                    if (doctorLoginInfoBean != null) {
                        bundle.putString("organId", doctorLoginInfoBean.getOrganId());
                        ARouter.getInstance().build("/hx/reactnative").withString("path", "/my/station/overview").withBundle("params", bundle).navigation();
                    } else {
                        ToastUtils.showLong((CharSequence)"\u7528\u6237\u4fe1\u606f\u672a\u83b7\u53d6\u5230");
                    }
                });
                break;
            }
            case 11: {
                this.mUpdateVerStatus.changeConsuStatus(this.getContext(), 4627);
                this.mineClickItemDispatch.dispatchStatus(true, () -> SkipUtil.skipActivity((Activity)this.getActivity(), OrderListActivity.class));
            }
        }
    }
}

