/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.fragment.v2;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import butterknife.BindView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.base.BaseFlushMoreFragment;
import com.kangxin.common.byh.entity.OrderItemEntity;
import com.kangxin.common.byh.entity.OrderItemEntityV2;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.service.ApplyDetailProvider;
import com.kangxin.common.byh.service.IConsChatReceProvider;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.global.ErrorCode;
import com.kangxin.doctor.worktable.OrderDetailFragmentV2;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.OrderListAdapterV2;
import com.kangxin.doctor.worktable.presenter.IOrderListPresenter;
import com.kangxin.doctor.worktable.presenter.clc.ClcOrderListPresent;
import com.kangxin.doctor.worktable.presenter.impl2.BHOrderListPresenter;
import com.kangxin.doctor.worktable.view.IOrderListViewV2;
import com.kangxin.doctor.worktable.widget.OrderFilterPopwindow;
import com.kangxin.doctor.worktable.widget.OutDeptPopwindow;
import com.kangxin.doctor.worktable.widget.PopUpWindowEx;
import com.kangxin.doctor.worktable.widget.listener.OnClickListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.Subscribe;
import org.jetbrains.annotations.NotNull;

public class OrderListFragmentV2
extends BaseFlushMoreFragment<OrderItemEntityV2>
implements IToolView,
IOrderListViewV2<OrderItemEntityV2> {
    private static final String TAG = "OrderListFragmentV2";
    @BindView(value=2131428166)
    TextView vFilterText;
    PopUpWindowEx popwindow;
    @BindView(value=2131427590)
    ConstraintLayout baseLine;
    @BindView(value=2131428269)
    EditText vSearchView;
    @BindView(value=2131428167)
    ImageView vFilterView;
    IOrderListPresenter mPresenter;
    private List orderTypes = new ArrayList();
    private List orderModes = new ArrayList();
    private List orderStatus = new ArrayList();
    @Autowired
    IUpdateVerStatus mUpdateVerStatus;
    private String searchKey = "";
    private int mConsuStatus;
    private IConsChatReceProvider mConsuChatReceiverProvider = (IConsChatReceProvider)ARouter.getInstance().build("/consuchat/receiver/ConsuChatReceiverProvider").navigation();

    public void init() {
        this.mConsuStatus = this.mUpdateVerStatus.getConsuStatus(this.getMContext());
        this.mConsuChatReceiverProvider.registerConsuChatReceiver();
        if (this.mConsuStatus == 4626) {
            this.mPresenter = new BHOrderListPresenter(this);
            this.popwindow = new OrderFilterPopwindow(View.inflate((Context)this.mContext, (int)R.layout.worktab_by_fragment_order_filter, null));
        } else if (this.mConsuStatus == 4627) {
            this.mPresenter = new ClcOrderListPresent(this);
            this.popwindow = new OutDeptPopwindow(View.inflate((Context)this.mContext, (int)R.layout.worktab_by_fragment_order_filter, null));
        }
        super.init();
    }

    public void onInitComplete() {
        super.onInitComplete();
        this.vToolTitleTextView.setText((CharSequence)"\u8ba2\u5355\u5217\u8868");
        this.dispatchEvent();
    }

    protected void flushOrLoad(boolean isGetMore) {
        this.mPresenter.getOrderList(this.orderModes, this.orderStatus, this.orderTypes, this.searchKey, 1, 10, isGetMore);
    }

    private void dispatchEvent() {
        this.vSearchView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                OrderListFragmentV2.this.searchKey = s.toString();
                OrderListFragmentV2.this.flushOrLoad(false);
            }
        });
        this.popwindow.registerClickListener(new OnClickListener(){

            @Override
            public void clear() {
                OrderListFragmentV2.this.orderTypes = new ArrayList();
                OrderListFragmentV2.this.orderModes = new ArrayList();
                OrderListFragmentV2.this.orderStatus = new ArrayList();
                OrderListFragmentV2.this.vFilterView.setImageResource(R.mipmap.ic_filter_normal);
                OrderListFragmentV2.this.flushOrLoad(false);
            }

            @Override
            public void commit(@NotNull List<Integer> result, @NotNull List<Integer> result2, @NotNull List<Integer> result3) {
                OrderListFragmentV2.this.orderTypes = result2;
                OrderListFragmentV2.this.orderModes = result;
                OrderListFragmentV2.this.orderStatus = result3;
                if (result.size() == 0 && result2.size() == 0 && result3.size() == 0) {
                    OrderListFragmentV2.this.vFilterView.setImageResource(R.mipmap.ic_filter_normal);
                } else {
                    OrderListFragmentV2.this.vFilterView.setImageResource(R.mipmap.ic_filter_select);
                }
                OrderListFragmentV2.this.parse();
                OrderListFragmentV2.this.flushOrLoad(false);
            }
        });
        this.vFilterText.setOnClickListener(v -> this.popwindow.showAsDropDownEx((View)this.baseLine));
        this.mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                Object o = adapter.getData().get(position);
                if (o instanceof OrderItemEntityV2) {
                    OrderItemEntityV2 item = (OrderItemEntityV2)o;
                    int orderStatus = item.getOrderStatus();
                    Log.i((String)OrderListFragmentV2.TAG, (String)("onItemClick: orderChannel:" + item.getOrderApplicationChannels()));
                    Log.i((String)OrderListFragmentV2.TAG, (String)("onItemClick: orderStatus:" + orderStatus));
                    switch (orderStatus) {
                        case 20: 
                        case 30: 
                        case 40: {
                            OrderListFragmentV2.this.sendConsMsgCast((OrderItemEntity)item);
                            break;
                        }
                        case 6: {
                            String orderViewId = item.getOrderViewId();
                            ApplyDetailProvider applyDetailProvider = (ApplyDetailProvider)ARouter.getInstance().build("/apply/detail/ApplyDetailProviderImpl").navigation();
                            applyDetailProvider.reqApplyDetail(orderViewId);
                            break;
                        }
                        case 0: 
                        case 5: 
                        case 8: 
                        case 10: 
                        case 50: {
                            OrderListFragmentV2.this.start((ISupportFragment)OrderDetailFragmentV2.newInstance(item.getOrderViewId()));
                            break;
                        }
                        default: {
                            ToastUtils.showShort((CharSequence)("\u8bf7\u91cd\u8bd5\uff0c\u9519\u8bef\u4fe1\u606f " + ErrorCode.INSTANCE.getTYPE_PARSE_ERROR() + "\u8ba2\u5355\u72b6\u6001\u4e3a" + orderStatus + "\u8ba2\u5355\u53f7\u4e3a" + item.getOrderViewId()));
                            break;
                        }
                    }
                } else {
                    ToastUtils.showShort((CharSequence)("\u8bf7\u5c06\u9519\u8bef\u4fe1\u606f" + ErrorCode.INSTANCE.getTYPE_PARSE_ERROR() + "\u53cd\u9988\u7ed9\u5f00\u53d1\u8005"));
                }
            }
        });
    }

    private void parse() {
        int index;
        int i;
        if (this.orderModes != null) {
            for (i = 0; i < this.orderModes.size(); ++i) {
                this.orderModes.set(i, (Integer)this.orderModes.get(i) + 1);
            }
        }
        if (this.orderTypes != null) {
            for (i = 0; i < this.orderTypes.size(); ++i) {
                index = (Integer)this.orderTypes.get(i);
                if (index == 0) {
                    this.orderTypes.set(i, 4);
                }
                if (index != 1) continue;
                this.orderTypes.set(i, 5);
            }
        }
        if (this.orderStatus != null) {
            block10: for (i = 0; i < this.orderStatus.size(); ++i) {
                index = (Integer)this.orderStatus.get(i);
                switch (index) {
                    case 0: {
                        this.orderStatus.set(i, 6);
                        continue block10;
                    }
                    case 1: {
                        this.orderStatus.set(i, 8);
                        continue block10;
                    }
                    case 2: {
                        this.orderStatus.set(i, 30);
                        continue block10;
                    }
                    case 3: {
                        this.orderStatus.set(i, 40);
                        continue block10;
                    }
                    case 4: {
                        this.orderStatus.set(i, 50);
                        continue block10;
                    }
                    case 5: {
                        this.orderStatus.set(i, 56);
                    }
                }
            }
        }
    }

    protected BaseQuickAdapter<OrderItemEntityV2, ? extends BaseViewHolder> getBaseQuickAdapter() {
        this.mAdapter = new OrderListAdapterV2(null);
        return this.mAdapter;
    }

    private void sendConsMsgCast(OrderItemEntity orderItemEntity) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.mConsuChatReceiverProvider.sendConsuChatReceiver((Serializable)orderItemEntity);
        } else {
            Intent intent = new Intent("com.kangxin.doctor.worktable.orderlist.consulation.chat");
            intent.putExtra("ORDER_ITEM_ENTITY", (Serializable)orderItemEntity);
            this.getContext().sendBroadcast(intent);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mConsuChatReceiverProvider.unRegisterConsuChatReceiver();
    }

    @Subscribe
    public void subscribeFlushList(ByhCommEvent.FlushList list) {
        this.flushOrLoad(false);
    }

    protected int getLayoutId() {
        return R.layout.worktab_by_fragment_order_list_v2;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.linearLayout);
    }

    public void finishCurrentView() {
        this._mActivity.finish();
    }
}

