/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.fragment.v2;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import butterknife.BindView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.base.BaseFlushMoreFragment;
import com.kangxin.common.byh.entity.UnionHospitalEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.doctor.worktable.R;
import com.kangxin.doctor.worktable.adapter.v2.UnionHosListAdapter;
import com.kangxin.doctor.worktable.presenter.IUnionHospitalPresenter;
import com.kangxin.doctor.worktable.presenter.impl2.BHUnionHospitalPresenter;
import com.kangxin.doctor.worktable.view.IUnionHospitalView;
import java.util.ArrayList;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;

public class UnionHospitalListFragment
extends BaseFlushMoreFragment<UnionHospitalEntity>
implements IToolView,
IUnionHospitalView<UnionHospitalEntity> {
    private static final String TAG = "SampleHospitalListFragm";
    private static final int REQUEST_HOSPITAL_CODE = 3;
    @BindView(value=2131428269)
    EditText vSearchView;
    @BindView(value=2131427915)
    View vSearchBarView;
    @BindView(value=2131427708)
    View vActionBarView;
    private static boolean isHideSearchBar = false;
    private String mAreaCode = "";
    private IUnionHospitalPresenter mUnionHospitalPresenter = new BHUnionHospitalPresenter(this);
    private ArrayList<UnionHospitalEntity> datas = new ArrayList();

    public static UnionHospitalListFragment newInstance(String areaCode, boolean hideFlag) {
        isHideSearchBar = hideFlag;
        Bundle bundle = new Bundle();
        bundle.putString("areaCode", areaCode);
        UnionHospitalListFragment sampleHospitalListFragment = new UnionHospitalListFragment();
        sampleHospitalListFragment.setArguments(bundle);
        return sampleHospitalListFragment;
    }

    public void init() {
        super.init();
        this.mAreaCode = this.getArguments().getString("areaCode");
        this.vToolTitleTextView.setText((CharSequence)"\u533b\u9662\u540d\u79f0");
        Log.i((String)TAG, (String)("init: isHide:" + isHideSearchBar));
        if (isHideSearchBar) {
            this.vSearchBarView.setVisibility(8);
            this.vActionBarView.setVisibility(8);
        } else {
            this.vSearchBarView.setVisibility(0);
            this.vActionBarView.setVisibility(0);
        }
    }

    public void onInitComplete() {
        super.onInitComplete();
        this.dispatchEvent();
    }

    protected void flushOrLoad(boolean isGetMore) {
        Log.i((String)TAG, (String)("flushOrLoad: isGetMore:" + isGetMore));
        this.mUnionHospitalPresenter.getUnionHospitalList(isGetMore, this.vSearchView.getText().toString());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void updateHosListEvent(ByhCommEvent.UpdateHosListEvent updateHosListEvent) {
        String code = updateHosListEvent.getCode();
        String cityName = updateHosListEvent.getCityName();
        Log.i((String)TAG, (String)("updateHosListEvent: code:" + code + ", cityName:" + cityName));
        this.vSearchView.setText((CharSequence)cityName);
        this.mAreaCode = code;
        this.flushOrLoad(false);
    }

    private void dispatchEvent() {
        this.mAdapter.setOnItemClickListener((adapter, view, position) -> {
            UnionHospitalEntity hospitalEntity = (UnionHospitalEntity)this.mAdapter.getData().get(position);
            int id2 = hospitalEntity.getHospitalId();
            Bundle bundle = new Bundle();
            bundle.putInt("hospitalId", id2);
            bundle.putString("hospitalName", hospitalEntity.getHospitalName());
            this.setFragmentResult(3, bundle);
            String appCode = VertifyDataUtil.getInstance((Context)this.getMContext()).getOpenCode();
            bundle.putString("openCode", appCode);
            if (!isHideSearchBar) {
                this.finishCurrentView();
            }
        });
        this.vSearchView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (isHideSearchBar) {
                    return;
                }
                Log.i((String)UnionHospitalListFragment.TAG, (String)"afterTextChanged:================");
                UnionHospitalListFragment.this.mUnionHospitalPresenter.getUnionHospitalList(false, UnionHospitalListFragment.this.vSearchView.getText().toString());
            }
        });
    }

    protected BaseQuickAdapter<UnionHospitalEntity, ? extends BaseViewHolder> getBaseQuickAdapter() {
        return new UnionHosListAdapter(this.datas);
    }

    protected int getLayoutId() {
        return R.layout.by_fragment_sample_hospital_list;
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.pop();
    }
}

