/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.fragment.v2;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.VertifyIDCardEntity;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.present.IUserPresent;
import com.kangxin.common.byh.present.IVerifyPresenter;
import com.kangxin.common.byh.present.VerifyPresenter;
import com.kangxin.common.byh.present.impl.UserPresent;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IModifyNameIdcardView;
import com.kangxin.common.byh.view.IVerNameByIdcardView;
import com.kangxin.common.util.VerifyUtil;
import com.kangxin.doctor.worktable.R;
import org.jetbrains.annotations.NotNull;

public class VerNameFragment
extends BaseFragment
implements IToolView,
IVerNameByIdcardView,
IModifyNameIdcardView {
    private EditText mVerNameEdt;
    private EditText mVerIdcardNumEdt;
    private IVerifyPresenter mVertifyPresent;
    private IUserPresent mUserPresent;

    public static VerNameFragment getInstance() {
        return new VerNameFragment();
    }

    public void init() {
        this.mVertifyPresent = new VerifyPresenter((IVerNameByIdcardView)this);
        this.mUserPresent = new UserPresent((IModifyNameIdcardView)this);
        this.vToolTitleTextView.setText((CharSequence)"\u5b9e\u540d\u8ba4\u8bc1");
        this.mVerNameEdt = (EditText)this.findViewById(this.rootView, R.id.real_name_edt);
        this.mVerIdcardNumEdt = (EditText)this.findViewById(this.rootView, R.id.idcardnum_edt);
        this.findViewById(this.rootView, R.id.btn_commit).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VerNameFragment.this.commitVertify();
            }
        });
    }

    private void commitVertify() {
        String realName = this.mVerNameEdt.getText().toString().trim();
        String idcardNum = this.mVerIdcardNumEdt.getText().toString().trim();
        if (TextUtils.isEmpty((CharSequence)realName)) {
            ToastUtils.showLong((int)R.string.worktab_pwk_input_realname);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)idcardNum)) {
            ToastUtils.showLong((int)R.string.worktab_p_input_idcard);
            return;
        }
        if (!VerifyUtil.isIdNo((String)(idcardNum = VerifyUtil.changeIdcard((String)idcardNum)))) {
            this.showShortToast(this.getString(R.string.worktab_ver_idcard_err));
            return;
        }
        this.mVertifyPresent.verNameByIdcard(this.getContext(), realName, idcardNum);
    }

    protected int getLayoutId() {
        return R.layout.worktab_vername_fragment;
    }

    @NotNull
    public View getVToolView() {
        return this.findViewById(this.rootView, R.id.vToolBar);
    }

    public void finishCurrentView() {
        this.getActivity().finish();
    }

    public void vertifySuccess(VertifyIDCardEntity vertifyIDCardEntity) {
        String accoundId = VertifyDataUtil.getInstance((Context)this.getContext()).getAccountId();
        ReqWebBody reqWebBody = new ReqWebBody();
        reqWebBody.setAccountNo(accoundId);
        reqWebBody.setId(vertifyIDCardEntity.getIdcard());
        reqWebBody.setDisplayName(vertifyIDCardEntity.getName());
        this.mUserPresent.modifyNameAndIdcard(reqWebBody);
    }

    public void modifyNameIdcardSuccess() {
        this.showShortToast("\u64cd\u4f5c\u6210\u529f");
        this.getActivity().finish();
    }
}

