/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.module.impl2;

import com.google.gson.JsonObject;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.api.v2.BHHospitalApi;
import com.kangxin.common.byh.entity.PageEntity;
import com.kangxin.common.byh.entity.v2.HospitalDepEntityV2;
import com.kangxin.common.byh.entity.v2.HospitalDepsmallEntityV2;
import com.kangxin.common.byh.entity.v2.HospitalEntityV2;
import com.kangxin.common.byh.entity.v2.OneDepEntityV2;
import com.kangxin.common.byh.entity.v2.TwoDepEntityV2;
import com.kangxin.common.byh.module.impl.HospitalModule;
import com.kangxin.common.util.SchedulesSwitch;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;

public class BHHospitalModule
extends HospitalModule {
    public Observable<ResponseBody<List<OneDepEntityV2>>> getStandardDepartmentV2() {
        final OneDepEntityV2 hotDep = this.joinHotDep();
        return ((BHHospitalApi)this.createFitApi(BHHospitalApi.class)).getStandardDepartmentList().compose(SchedulesSwitch.applySchedulers()).doOnNext((Consumer)new Consumer<ResponseBody<List<OneDepEntityV2>>>(){

            public void accept(ResponseBody<List<OneDepEntityV2>> listResponseBody) throws Exception {
                if (listResponseBody.getResult() != null) {
                    ((List)listResponseBody.getResult()).add(0, hotDep);
                }
            }
        });
    }

    private OneDepEntityV2 joinHotDep() {
        OneDepEntityV2 oneDepEntityV2 = new OneDepEntityV2();
        oneDepEntityV2.setStdFirstDeptId(0);
        oneDepEntityV2.setStdFirstDeptName("\u70ed\u95e8\u79d1\u5ba4");
        TwoDepEntityV2 twoDepEntityV2 = new TwoDepEntityV2();
        twoDepEntityV2.setStdSecondDeptId(0);
        twoDepEntityV2.setStdSecondDeptName("\u5168\u90e8\u79d1\u5ba4");
        ArrayList<TwoDepEntityV2> twoDepEntityV2s = new ArrayList<TwoDepEntityV2>();
        twoDepEntityV2s.add(twoDepEntityV2);
        oneDepEntityV2.setStdSecondDeptVOS(twoDepEntityV2s);
        return oneDepEntityV2;
    }

    public Observable<ResponseBody<PageEntity<HospitalEntityV2>>> getHospitalListByAreaCodeV2(String searchKey, String areaCode, int index, int pageSize) {
        JsonObject object = new JsonObject();
        object.addProperty("area", areaCode);
        object.addProperty("pageNum", (Number)index);
        object.addProperty("pageSize", (Number)pageSize);
        object.addProperty("searchParam", searchKey);
        return ((BHHospitalApi)this.createApi2(BHHospitalApi.class)).getHospitalListByAreaCode(object).compose(SchedulesSwitch.applySchedulers());
    }

    public Observable<ResponseBody<List<HospitalDepEntityV2>>> getHospitalAllDepartmentListV2(Long hospitalId, String openCode) {
        JsonObject object = new JsonObject();
        object.addProperty("organId", (Number)hospitalId);
        return ((BHHospitalApi)this.createFitApi(BHHospitalApi.class)).getHospitalAllDepartmentList(object, openCode).compose(SchedulesSwitch.applySchedulers());
    }

    public Observable<ResponseBody<List<HospitalDepsmallEntityV2>>> getHospitalSmallDepartmentListV2(Long hospitalId) {
        JsonObject object = new JsonObject();
        object.addProperty("organId", (Number)hospitalId);
        return ((BHHospitalApi)this.createApi2(BHHospitalApi.class)).getHospitalSmallDepartmentList(object).compose(SchedulesSwitch.applySchedulers());
    }
}

