/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.clc;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.base.ByBasePresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.util.StringUtil;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.DoctorConsultationAllOrderEntity;
import com.kangxin.doctor.worktable.module.clc.ClcOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IConsulationDoctorAllOrderListPresenter;
import com.kangxin.doctor.worktable.view.IConsulationDoctorOrderListView;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.List;

public class ClcConsuDoctorOrderListPresent
extends ByBasePresenter
implements IConsulationDoctorAllOrderListPresenter {
    private IConsulationDoctorOrderListView mOrderListView;
    private OrderModule mOrderModule;

    public ClcConsuDoctorOrderListPresent(IConsulationDoctorOrderListView consulationDoctorOrderListView) {
        this.mOrderListView = consulationDoctorOrderListView;
        this.mOrderModule = new ClcOrderModule();
    }

    @Override
    public void getConsulationReceiverOrderList(final boolean isGetMore, long patientInfoId, boolean isShowLoading) {
        Context context = this.mOrderListView.injectContext();
        String docId = VertifyDataUtil.getInstance((Context)context).getDoctorId();
        Observable<ResponseBody<List<DoctorConsultationAllOrderEntity>>> observable = null;
        long doctorId = -1L;
        if (StringUtil.isNumeric((String)docId)) {
            doctorId = Long.parseLong(docId);
        }
        observable = this.mOrderModule.updateDoctorManagerConsultationInfo(doctorId, patientInfoId, this.getPageIndex(isGetMore), this.getPageSize(), VertifyDataUtil.getInstance((Context)context).getHospitalId());
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<List<DoctorConsultationAllOrderEntity>>>(){

                public void onReqNext(ResponseBody<List<DoctorConsultationAllOrderEntity>> listResponseBody) {
                    ClcConsuDoctorOrderListPresent.this.fullData(ClcConsuDoctorOrderListPresent.this.mOrderListView, (List)listResponseBody.getResult(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    super.onError(e);
                    ClcConsuDoctorOrderListPresent.this.mOrderListView.error(e.toString());
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<List<DoctorConsultationAllOrderEntity>>>(){

                public void onNext(ResponseBody<List<DoctorConsultationAllOrderEntity>> t) {
                    ClcConsuDoctorOrderListPresent.this.fullData(ClcConsuDoctorOrderListPresent.this.mOrderListView, (List)t.getResult(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    ClcConsuDoctorOrderListPresent.this.mOrderListView.error(e.toString());
                }
            });
        }
    }
}

