/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.clc;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BasePresenter;
import com.kangxin.common.widget.ProgressDialogObserver;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.clc.ClcOrderModule;
import com.kangxin.doctor.worktable.presenter.IOrderApplySignPresenter;
import com.kangxin.doctor.worktable.view.IOrderApplySignView;
import io.reactivex.Observer;

public class ClcOrderApplySignPresent
extends BasePresenter
implements IOrderApplySignPresenter {
    private IOrderModule mOrderModule;
    private IOrderApplySignView mOrderApplySignView;

    public ClcOrderApplySignPresent(IOrderApplySignView orderApplySignView) {
        this.mOrderApplySignView = orderApplySignView;
        this.mOrderModule = new ClcOrderModule();
    }

    @Override
    public void uploadSign(String orderId, String mSignUrl, String mTag) {
        if (mTag == null || mTag.equals("")) {
            this.mOrderModule.uploadPatientSign(orderId, mSignUrl).subscribe((Observer)new ProgressDialogObserver<ResponseBody>(){

                public void onNext(ResponseBody responseBody) {
                    if (responseBody.getCode() == 200) {
                        ClcOrderApplySignPresent.this.mOrderApplySignView.success();
                    } else {
                        ClcOrderApplySignPresent.this.mOrderApplySignView.error(responseBody.getMsg());
                    }
                }

                protected Context attachContext() {
                    return ClcOrderApplySignPresent.this.mOrderApplySignView.injectContext();
                }
            });
        } else {
            this.mOrderModule.uploadPatientSign(orderId, mSignUrl, mTag).subscribe((Observer)new ProgressDialogObserver<ResponseBody>(){

                public void onNext(ResponseBody responseBody) {
                    if (responseBody.getCode() == 200) {
                        ClcOrderApplySignPresent.this.mOrderApplySignView.success();
                    } else {
                        ClcOrderApplySignPresent.this.mOrderApplySignView.error(responseBody.getMsg() + "");
                    }
                    this.onComplete();
                }

                protected Context attachContext() {
                    return ClcOrderApplySignPresent.this.mOrderApplySignView.injectContext();
                }
            });
        }
    }

    @Override
    public void getShareUrl() {
    }
}

