/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.clc;

import android.content.Context;
import cn.finalteam.toolsfinal.StringUtils;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.ToastUtils;
import com.google.gson.Gson;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.OrderDetailEntity;
import com.kangxin.common.byh.present.IOrderDetailPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.ProgressDialogObserver;
import com.kangxin.doctor.worktable.entity.v2.DicomEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.clc.ClcOrderModule;
import com.kangxin.doctor.worktable.view.IOrderDetailView;
import io.reactivex.Observer;
import java.util.Arrays;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

@Route(path="/remote_order_service/ClcOrderDetailPresent")
public class ClcOrderDetailPresent
implements IOrderDetailPresenter {
    private IOrderDetailView mOrderDetailView;
    private IOrderModule mOrderModule;
    Context context;

    public ClcOrderDetailPresent(IOrderDetailView orderDetailView) {
        this.mOrderDetailView = orderDetailView;
        this.mOrderModule = new ClcOrderModule();
    }

    public void getOrderDetail(String orderViewId) {
        this.mOrderModule.getOrderDetail(orderViewId).subscribe((Observer)new ProgressDialogObserver<ResponseBody<OrderDetailEntity>>(){

            public void onNext(ResponseBody<OrderDetailEntity> responseBody) {
                OrderDetailEntity data;
                if (responseBody.getCode() == 200 && (data = (OrderDetailEntity)responseBody.getData()) != null) {
                    if (ClcOrderDetailPresent.this.mOrderDetailView != null) {
                        ClcOrderDetailPresent.this.mOrderDetailView.bindOrderDetail(data);
                    }
                    EventBus.getDefault().post((Object)data);
                }
            }

            protected Context attachContext() {
                if (ClcOrderDetailPresent.this.mOrderDetailView == null) {
                    return ClcOrderDetailPresent.this.context;
                }
                return ClcOrderDetailPresent.this.mOrderDetailView.injectContext();
            }
        });
    }

    public void cancleOrder(String orderId, String cancleReason) {
        String closeId = VertifyDataUtil.getInstance((Context)this.mOrderDetailView.injectContext()).getDoctorId();
        this.mOrderModule.cancleOrder(orderId, closeId, "3", cancleReason).subscribe((Observer)new ProgressDialogObserver<ResponseBody>(){

            public void onNext(ResponseBody responseBody) {
                if (responseBody.getCode() == 200) {
                    ToastUtils.showShort((CharSequence)"\u5f88\u62b1\u6b49\uff0c\u4f1a\u8bca\u8ba2\u5355\u5df2\u53d6\u6d88");
                    ClcOrderDetailPresent.this.mOrderDetailView.cancleSuccess();
                    return;
                }
                ToastUtils.showShort((CharSequence)(responseBody.getMsg() + ""));
            }

            protected Context attachContext() {
                if (ClcOrderDetailPresent.this.mOrderDetailView == null) {
                    return ClcOrderDetailPresent.this.context;
                }
                return ClcOrderDetailPresent.this.mOrderDetailView.injectContext();
            }
        });
    }

    public void getDicomInfo(String dcmPackUrl) {
        if (StringUtils.isEmpty((String)dcmPackUrl)) {
            ToastUtils.showShort((CharSequence)"\u6682\u65e0dicom\u6587\u6863");
            return;
        }
        DicomEntity[] dicomEntities = (DicomEntity[])new Gson().fromJson(dcmPackUrl, DicomEntity[].class);
        List<DicomEntity> results = Arrays.asList(dicomEntities);
        String stuuids = "";
        if (results != null) {
            for (DicomEntity entity : results) {
                stuuids = stuuids + entity.getStuuid() + ",";
            }
            stuuids = stuuids.substring(0, stuuids.length() - 1);
        }
        this.mOrderModule.getDicomShareUrl("36000", stuuids).subscribe((Observer)new ProgressDialogObserver<ResponseBody<String>>(){

            public void onNext(ResponseBody<String> responseBody) {
                if (responseBody != null && responseBody.getCode() == 200) {
                    ClcOrderDetailPresent.this.mOrderDetailView.toDicom("dicom\u6587\u4ef6", (String)responseBody.getResult());
                } else {
                    ToastUtils.showShort((CharSequence)"\u670d\u52a1\u5668\u9519\u8bef");
                }
            }

            protected Context attachContext() {
                if (ClcOrderDetailPresent.this.mOrderDetailView == null) {
                    return ClcOrderDetailPresent.this.context;
                }
                return ClcOrderDetailPresent.this.mOrderDetailView.injectContext();
            }
        });
    }

    public void init(Context context) {
    }
}

