/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.clc;

import android.content.Context;
import android.util.Log;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.OrderApplyEntity;
import com.kangxin.common.byh.entity.UpdateCaseEntity;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.byh.module.IFileModule;
import com.kangxin.common.byh.module.impl.UpFileModule;
import com.kangxin.common.byh.present.IOrderApplyPresenter;
import com.kangxin.common.widget.RxBaseObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.OrderApplySuccessEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.clc.ClcOrderModule;
import com.kangxin.doctor.worktable.view.IOrderApplyView;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.ArrayList;
import java.util.List;

public class ClcOrderPresent
implements IOrderApplyPresenter {
    private static final String TAG = "ClcOrderPresent";
    private IOrderModule mOrderModule;
    private IOrderApplyView mOrderApplyView;
    private IFileModule mFileModule;

    public ClcOrderPresent(IOrderApplyView orderApplyView) {
        this.mOrderApplyView = orderApplyView;
        this.mOrderModule = new ClcOrderModule();
        this.mFileModule = new UpFileModule();
    }

    private boolean checkHasSelImgs(List<String> data, List<Integer> ids) {
        return !this.isListEmpty(data) || !this.isListEmpty(ids);
    }

    private boolean isListEmpty(List list) {
        if (list == null) {
            return true;
        }
        return list.isEmpty();
    }

    public void applyOrder(final OrderApplyEntity orderApplyEntity, List<String> data, List<Integer> ids) {
        if (!this.checkHasSelImgs(data, ids)) {
            this.commitOrder(orderApplyEntity);
            Log.i((String)TAG, (String)"applyOrder: no select imgs");
        } else {
            if (this.isListEmpty(data) && !this.isListEmpty(ids)) {
                orderApplyEntity.setOssFileIds(ids);
                this.commitOrder(orderApplyEntity);
                return;
            }
            ArrayList<String> nativeImages = new ArrayList<String>();
            for (String temp : data) {
                if (temp.equals("") || temp.startsWith("http")) continue;
                nativeImages.add(temp);
            }
            if (nativeImages.size() > 0) {
                Log.i((String)TAG, (String)"applyOrder: has local imgs");
                this.upLoadImgs(nativeImages, ids).subscribe((Observer)new RxBaseObserver<List<Integer>>(){

                    public void onReqNext(List<Integer> integers) {
                        Log.i((String)ClcOrderPresent.TAG, (String)("onReqNext: upload imgs:" + integers));
                        orderApplyEntity.setOssFileIds(integers);
                        ClcOrderPresent.this.commitOrder(orderApplyEntity);
                    }

                    public void onError(Throwable e) {
                    }

                    public void onComplete() {
                    }
                });
            } else {
                Log.i((String)TAG, (String)("applyOrder: net imgs:" + ids));
                orderApplyEntity.setOssFileIds(ids);
                this.commitOrder(orderApplyEntity);
            }
        }
    }

    private Observable<List<Integer>> upLoadImgs(List<String> imgs, List<Integer> ids) {
        return this.mFileModule.uploadFiles(imgs).filter(imgList -> {
            if (imgList.getCode() == 200) {
                return true;
            }
            ToastUtils.showShort((CharSequence)"\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            return false;
        }).map(imgListRes -> {
            List result = (List)imgListRes.getResult();
            ArrayList<Integer> integers = new ArrayList<Integer>();
            for (UpImgEntity x : result) {
                integers.add(x.getId());
            }
            if (!this.isListEmpty(ids)) {
                integers.addAll(ids);
            }
            return integers;
        });
    }

    private void commitOrder(OrderApplyEntity orderApplyEntity) {
        Observable<ResponseBody<OrderApplySuccessEntity>> responseBodyObservable = orderApplyEntity.getOrderId() != null ? this.mOrderModule.updateOrder(orderApplyEntity) : this.mOrderModule.newApplyOrder(orderApplyEntity);
        responseBodyObservable.subscribe((Observer)new RxProgressObserver<ResponseBody<OrderApplySuccessEntity>>(){

            public void onReqNext(ResponseBody<OrderApplySuccessEntity> orderApplySuccessEntityResponseBody) {
                OrderApplySuccessEntity orderApplySuccessEntity = (OrderApplySuccessEntity)orderApplySuccessEntityResponseBody.getResult();
                if (orderApplySuccessEntity == null) {
                    Log.i((String)ClcOrderPresent.TAG, (String)"onReqNext: orderApplySuccessEntity is null");
                    return;
                }
                ClcOrderPresent.this.mOrderApplyView.toSign(orderApplySuccessEntity.getId(), orderApplySuccessEntity.getViewId(), orderApplySuccessEntity.getDoctorHosName(), orderApplySuccessEntity.getApplicationChannels(), orderApplySuccessEntity.getInitiatorType());
            }
        });
    }

    public void updateOrderCase(UpdateCaseEntity caseEntity, List<String> imageDatas, List<Integer> ids) {
    }

    public void init(Context context) {
    }
}

