/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.clc;

import android.content.Context;
import cn.finalteam.toolsfinal.StringUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.byh.module.IFileModule;
import com.kangxin.common.byh.module.impl.UpFileModule;
import com.kangxin.common.widget.ProgressDialogObserver;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.clc.ClcOrderModule;
import com.kangxin.doctor.worktable.presenter.IReportDetailPresenter;
import com.kangxin.doctor.worktable.view.IReportDetailView;
import io.reactivex.Observer;

public class ClcReportDetailPresent
implements IReportDetailPresenter {
    private IOrderModule mOrderModule;
    private IReportDetailView mView;
    private IFileModule mFileModule;

    public ClcReportDetailPresent(IReportDetailView reportDetailView) {
        this.mView = reportDetailView;
        this.mOrderModule = new ClcOrderModule();
        this.mFileModule = new UpFileModule();
    }

    @Override
    public void uploadReport(String orderUuid, int orderType, String treatplan, String mSignUrl) {
        if (!StringUtils.isEmpty((String)mSignUrl)) {
            this.mFileModule.uploadFile(mSignUrl).flatMap(upImgEntityResponseBody -> this.mOrderModule.updateConsulationReport(orderUuid, orderType, treatplan, ((UpImgEntity)upImgEntityResponseBody.getResult()).getUrl(), null)).subscribe((Observer)new ProgressDialogObserver<ResponseBody>(){

                public void onNext(ResponseBody responseBody) {
                    if (responseBody.getCode() == 200) {
                        ClcReportDetailPresent.this.mView.success();
                    } else {
                        ToastUtils.showShort((CharSequence)responseBody.getMsg());
                    }
                }

                protected Context attachContext() {
                    return ClcReportDetailPresent.this.mView.injectContext();
                }
            });
        } else {
            ToastUtils.showShort((CharSequence)"\u8bf7\u624b\u5199\u7b7e\u540d\u540e\u91cd\u8bd5");
        }
    }
}

