/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.clc;

import android.content.Context;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.SubscribeTimeEntity;
import com.kangxin.common.widget.ProgressDialogObserver;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.clc.ClcOrderModule;
import com.kangxin.doctor.worktable.presenter.ISubscribeTimePresenter;
import com.kangxin.doctor.worktable.view.ISubscribeTimeView;
import io.reactivex.Observer;
import java.util.List;

public class ClcSubcribeTimePresent
implements ISubscribeTimePresenter {
    private ISubscribeTimeView mSubscribeTimeView;
    private IOrderModule mOrderModule = new ClcOrderModule();

    public ClcSubcribeTimePresent(ISubscribeTimeView subscribeTimeView) {
        this.mSubscribeTimeView = subscribeTimeView;
    }

    @Override
    public void getSubscribeDate(final int expertId) {
        this.mOrderModule.getSubscribeDate().subscribe((Observer)new ProgressDialogObserver<ResponseBody<List<String>>>(){

            public void onNext(ResponseBody<List<String>> listResponseBody) {
                ClcSubcribeTimePresent.this.mSubscribeTimeView.bindDate((List)listResponseBody.getResult());
                this.onComplete();
                ClcSubcribeTimePresent.this.getSubscribeTime((String)((List)listResponseBody.getResult()).get(0), expertId);
            }

            protected Context attachContext() {
                return ClcSubcribeTimePresent.this.mSubscribeTimeView.injectContext();
            }
        });
    }

    @Override
    public void getSubscribeTime(String consultationDate, int expertId) {
        String finalConsultationDate = consultationDate;
        this.mOrderModule.getSubscribeTimeAndCount(expertId, finalConsultationDate).subscribe((Observer)new ProgressDialogObserver<ResponseBody<List<SubscribeTimeEntity>>>(){

            public void onNext(ResponseBody<List<SubscribeTimeEntity>> listResponseBody) {
                List result = (List)listResponseBody.getResult();
                if (result != null && result.size() != 0) {
                    ClcSubcribeTimePresent.this.mSubscribeTimeView.bindTime(result);
                }
                this.onComplete();
            }

            protected Context attachContext() {
                return ClcSubcribeTimePresent.this.mSubscribeTimeView.injectContext();
            }
        });
    }

    @Override
    public void commitSubscribeTime(int mOrderId, String date, String time) {
        this.mOrderModule.subscribeExpert(mOrderId, date, time).filter(responseBody -> {
            if (responseBody.getCode() == 200) {
                return true;
            }
            this.mSubscribeTimeView.error("\u9884\u7ea6\u5931\u8d25");
            return false;
        }).flatMap(responseBody -> this.mOrderModule.expertAcceptOrder(mOrderId)).subscribe((Observer)new ProgressDialogObserver<ResponseBody>(){

            public void onNext(ResponseBody responseBody) {
                if (responseBody.getCode() == 200) {
                    ToastUtils.showShort((CharSequence)("" + responseBody.getMsg()));
                    ClcSubcribeTimePresent.this.mSubscribeTimeView.subscribeSuccess();
                } else {
                    ToastUtils.showShort((CharSequence)responseBody.getMsg());
                }
            }

            protected Context attachContext() {
                return ClcSubcribeTimePresent.this.mSubscribeTimeView.injectContext();
            }
        });
    }
}

