/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import android.text.TextUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BasePresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.RxBaseObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.v2.DocDetailEntity;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.view.IAccountBalanceView;
import io.reactivex.Observer;

public class AccountBalancePersenter
extends BasePresenter {
    private IAccountBalanceView mIAccountBalanceView;
    private OrderModule mOrderModule;

    public AccountBalancePersenter(IAccountBalanceView iAccountBalanceView) {
        this.mIAccountBalanceView = iAccountBalanceView;
        this.mOrderModule = new OrderModule();
    }

    public void reqGetAccountBalance(Context context, boolean isShowLoading) {
        String id2 = VertifyDataUtil.getInstance((Context)context).getDoctorId();
        if (TextUtils.isEmpty((CharSequence)id2)) {
            ToastUtils.showLong((CharSequence)"doctor id is null");
            return;
        }
        long docId = Long.parseLong(id2);
        if (isShowLoading) {
            this.mOrderModule.upDoctorAccountBalance(docId).subscribe((Observer)new RxProgressObserver<ResponseBody<DocDetailEntity>>(){

                public void onReqNext(ResponseBody<DocDetailEntity> docDetailEntityResponseBody) {
                    AccountBalancePersenter.this.mIAccountBalanceView.getAccountSuccess((DocDetailEntity)docDetailEntityResponseBody.getResult());
                }
            });
        } else {
            this.mOrderModule.upDoctorAccountBalance(docId).subscribe((Observer)new RxBaseObserver<ResponseBody<DocDetailEntity>>(){

                public void onReqNext(ResponseBody<DocDetailEntity> docDetailEntityResponseBody) {
                    AccountBalancePersenter.this.mIAccountBalanceView.getAccountSuccess((DocDetailEntity)docDetailEntityResponseBody.getResult());
                }

                public void onError(Throwable e) {
                }

                public void onComplete() {
                }
            });
        }
    }
}

