/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BasePresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.RxBaseObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.BoundBankCardsInfoEntity;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.view.IBankCardsInfoView;
import io.reactivex.Observer;

public class BankCardsInfoPresenter
extends BasePresenter {
    private IBankCardsInfoView mIBankCardsInfoView;
    private OrderModule mOrderModule;

    public BankCardsInfoPresenter(IBankCardsInfoView iBankCardsInfoView) {
        this.mIBankCardsInfoView = iBankCardsInfoView;
        this.mOrderModule = new OrderModule();
    }

    public void sendBankCardDoctorId(Context context, boolean isShowLoading) {
        String docId = VertifyDataUtil.getInstance((Context)context).getDoctorId();
        if (isShowLoading) {
            this.mOrderModule.sendDoctorBankCardsInfo(docId).subscribe((Observer)new RxProgressObserver<ResponseBody<BoundBankCardsInfoEntity>>(){

                public void onReqNext(ResponseBody<BoundBankCardsInfoEntity> boundBankCardsInfoEntityResponseBody) {
                    BankCardsInfoPresenter.this.mIBankCardsInfoView.setBankCardsOk(boundBankCardsInfoEntityResponseBody);
                }

                public void onReqErr(int code, String msg, String errCode) {
                    super.onReqErr(code, msg, errCode);
                    BankCardsInfoPresenter.this.mIBankCardsInfoView.unBindCard();
                }
            });
        } else {
            this.mOrderModule.sendDoctorBankCardsInfo(docId).subscribe((Observer)new RxBaseObserver<ResponseBody<BoundBankCardsInfoEntity>>(){

                public void onReqNext(ResponseBody<BoundBankCardsInfoEntity> boundBankCardsInfoEntityResponseBody) {
                    BankCardsInfoPresenter.this.mIBankCardsInfoView.setBankCardsOk(boundBankCardsInfoEntityResponseBody);
                }

                public void onError(Throwable e) {
                }

                public void onComplete() {
                }

                public void onReqErr(int code, String msg, String errCode) {
                    super.onReqErr(code, msg, errCode);
                    BankCardsInfoPresenter.this.mIBankCardsInfoView.unBindCard();
                }
            });
        }
    }
}

