/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.base.ByBasePresenter;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.DoctorConsultationAllOrderEntity;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IConsulationDoctorAllOrderListPresenter;
import com.kangxin.doctor.worktable.view.IConsulationDoctorOrderListView;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.util.List;

public class ConsulationDoctorOrderListPresenter
extends ByBasePresenter
implements IConsulationDoctorAllOrderListPresenter {
    private IConsulationDoctorOrderListView mOrderListView;
    private OrderModule mOrderModule;
    private IUserModule mIUserModule;

    public ConsulationDoctorOrderListPresenter(IConsulationDoctorOrderListView orderListView) {
        this.mOrderListView = orderListView;
        this.mOrderModule = new OrderModule();
        this.mIUserModule = new UserModule();
    }

    @Override
    public void getConsulationReceiverOrderList(final boolean isGetMore, long patientInfoId, boolean isShowLoading) {
        Observable observable = this.mIUserModule.getNativeUserInfo(this.mOrderListView.injectContext()).flatMap(loginSuccess -> this.mOrderModule.updateDoctorManagerConsultationInfo(loginSuccess.getId(), patientInfoId, this.getPageIndex(isGetMore), this.getPageSize(), VertifyDataUtil.getInstance((Context)this.mOrderListView.injectContext()).getHospitalId()));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody<List<DoctorConsultationAllOrderEntity>>>(){

                public void onReqNext(ResponseBody<List<DoctorConsultationAllOrderEntity>> listResponseBody) {
                    ConsulationDoctorOrderListPresenter.this.fullData(ConsulationDoctorOrderListPresenter.this.mOrderListView, (List)listResponseBody.getResult(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    super.onError(e);
                    ConsulationDoctorOrderListPresenter.this.mOrderListView.error(e.toString());
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody<List<DoctorConsultationAllOrderEntity>>>(){

                public void onNext(ResponseBody<List<DoctorConsultationAllOrderEntity>> t) {
                    ConsulationDoctorOrderListPresenter.this.fullData(ConsulationDoctorOrderListPresenter.this.mOrderListView, (List)t.getResult(), isGetMore);
                    this.onComplete();
                }

                public void onError(Throwable e) {
                    ConsulationDoctorOrderListPresenter.this.mOrderListView.error(e.toString());
                }
            });
        }
    }
}

