/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BasePresenter;
import com.kangxin.common.byh.entity.ExpertItemEntity;
import com.kangxin.common.byh.module.IExpertModule;
import com.kangxin.common.byh.module.impl.ExpertModule;
import com.kangxin.common.rx.ProgressDialogObserver;
import com.kangxin.doctor.worktable.presenter.IExpertListPresenter;
import com.kangxin.doctor.worktable.view.IExpertListView;
import io.reactivex.Observer;
import java.util.ArrayList;
import java.util.List;

public class ExpertListPresenter
extends BasePresenter
implements IExpertListPresenter {
    private IExpertListView mExpertListView;
    private IExpertModule mExpertModule;

    public ExpertListPresenter(IExpertListView mExpertListView) {
        this.mExpertListView = mExpertListView;
        this.mExpertModule = new ExpertModule();
    }

    @Override
    public void getExpertList(final boolean isGetMore, String mSearchKey, int hospitalId, long departmentId, int businessType) {
        this.mExpertModule.getExpertByHospitalIdAndDepartment(mSearchKey, "" + hospitalId, "" + departmentId, businessType, this.getPageIndex(isGetMore), this.getPageSize()).filter(listResponseBody -> {
            if (listResponseBody.getCode() == 200) {
                return true;
            }
            this.mExpertListView.error(listResponseBody.getMsg());
            return false;
        }).doOnNext(listResponseBody -> {
            if (listResponseBody.getResult() == null) {
                listResponseBody.setResult(new ArrayList());
            }
        }).map(ResponseBody::getResult).subscribe((Observer)new ProgressDialogObserver<List<ExpertItemEntity>>(){

            public void onNext(List<ExpertItemEntity> t) {
                ExpertListPresenter.this.fullData(ExpertListPresenter.this.mExpertListView, t, isGetMore);
            }

            protected Context attachContext() {
                return ExpertListPresenter.this.mExpertListView.injectContext();
            }
        });
    }

    @Override
    public void getFilterExpertList(final boolean isGetMore, String mSearchKey, String cityCode, String departmentCode, int expertLevel, String orderType, int userTypeSpecialist, int businessType) {
        this.mExpertModule.getFilterExpertList(cityCode, mSearchKey, departmentCode, expertLevel, orderType, userTypeSpecialist, businessType, this.getPageIndex(isGetMore), this.getPageSize()).filter(listResponseBody -> {
            if (listResponseBody.getCode() == 200) {
                return true;
            }
            this.mExpertListView.error(listResponseBody.getMsg());
            return false;
        }).doOnNext(listResponseBody -> {
            if (listResponseBody.getResult() == null) {
                listResponseBody.setResult(new ArrayList());
            }
        }).map(ResponseBody::getResult).subscribe((Observer)new ProgressDialogObserver<List<ExpertItemEntity>>(){

            public void onNext(List<ExpertItemEntity> t) {
                ExpertListPresenter.this.fullData(ExpertListPresenter.this.mExpertListView, t, isGetMore);
            }

            protected Context attachContext() {
                return ExpertListPresenter.this.mExpertListView.injectContext();
            }
        });
    }
}

