/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.presenter.impl;

import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.doctor.worktable.entity.FeedbackInfoEntity;
import com.kangxin.doctor.worktable.module.IOrderModule;
import com.kangxin.doctor.worktable.module.impl.OrderModule;
import com.kangxin.doctor.worktable.presenter.IFeedbackInfoPresenter;
import com.kangxin.doctor.worktable.view.IFeedbackInfoView;
import io.reactivex.Observable;
import io.reactivex.Observer;

public class FeedbackInfoPresenter
implements IFeedbackInfoPresenter {
    private IFeedbackInfoView mIFeedbackInfoView;
    private IOrderModule mOrderModule;
    private IUserModule mUserModule;

    public FeedbackInfoPresenter(IFeedbackInfoView feedbackInfoView) {
        this.mIFeedbackInfoView = feedbackInfoView;
        this.mOrderModule = new OrderModule();
        this.mUserModule = new UserModule();
    }

    @Override
    public void getFeedbackInfo(FeedbackInfoEntity feedbackInfoEntity, boolean isShowLoading) {
        Observable observable = this.mUserModule.getNativeUserInfo(this.mIFeedbackInfoView.injectContext()).doOnNext(loginSuccess -> feedbackInfoEntity.setUserId(loginSuccess.getId())).flatMap(loginSuccess -> this.mOrderModule.getFeedbackInfo(feedbackInfoEntity));
        if (isShowLoading) {
            observable.subscribe((Observer)new RxProgressObserver<ResponseBody>(){

                public void onReqNext(ResponseBody responseBody) {
                    FeedbackInfoPresenter.this.mIFeedbackInfoView.getFeedbackInfo(responseBody);
                    this.onComplete();
                }

                public void onReqErr(Throwable e) {
                    super.onReqErr(e);
                    FeedbackInfoPresenter.this.mIFeedbackInfoView.error(e.toString());
                    this.onComplete();
                }
            });
        } else {
            observable.subscribe((Observer)new SampleObserver<ResponseBody>(){

                public void onNext(ResponseBody responseBody) {
                    FeedbackInfoPresenter.this.mIFeedbackInfoView.getFeedbackInfo(responseBody);
                }

                public void onError(Throwable e) {
                    FeedbackInfoPresenter.this.mIFeedbackInfoView.error(e.toString());
                }
            });
        }
    }
}

